/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.ui.internal.jpql;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jpt.jpa.core.context.Entity;
import org.eclipse.jpt.jpa.core.context.NamedQuery;
import org.eclipse.jpt.jpa.core.context.PersistentAttribute;
import org.eclipse.jpt.jpa.core.jpql.JpaJpqlQueryHelper;
import org.eclipse.jpt.jpa.ui.JptJpaUiMessages;
import org.eclipse.jpt.jpa.ui.internal.jpql.OpenDeclarationHyperlink;
import org.eclipse.jpt.jpa.ui.internal.jpql.OpenMemberDeclarationHyperlink;
import org.eclipse.persistence.jpa.jpql.ExpressionTools;
import org.eclipse.persistence.jpa.jpql.parser.AbstractExpressionVisitor;
import org.eclipse.persistence.jpa.jpql.parser.Expression;
import org.eclipse.persistence.jpa.jpql.parser.QueryPosition;
import org.eclipse.persistence.jpa.jpql.tools.JPQLQueryContext;
import org.eclipse.persistence.jpa.jpql.tools.spi.IMapping;
import org.eclipse.persistence.jpa.jpql.tools.spi.IType;

public abstract class JpaJpqlHyperlinkBuilder
extends AbstractExpressionVisitor {
    private Collection<IHyperlink> hyperlinks;
    private NamedQuery namedQuery;
    private JpaJpqlQueryHelper queryHelper;
    private QueryPosition queryPosition;

    protected JpaJpqlHyperlinkBuilder(JpaJpqlQueryHelper queryHelper, NamedQuery namedQuery, QueryPosition queryPosition) {
        this.namedQuery = namedQuery;
        this.queryHelper = queryHelper;
        this.queryPosition = queryPosition;
        this.hyperlinks = new ArrayList<IHyperlink>();
    }

    protected final void addFieldHyperlinks(Expression expression, IMapping mapping, int offset) {
        this.addFieldHyperlinks(expression, mapping.getParent().getType(), mapping.getType(), mapping.getName(), offset);
    }

    protected final void addFieldHyperlinks(Expression expression, IType parentType, IType fieldType, String memberName, int offset) {
        IRegion region = this.buildRegion(expression, offset, memberName.length());
        ISourceReference element = this.getJavaElement(parentType, memberName);
        if (element != null) {
            this.addOpenMemberDeclarationHyperlink(parentType, element, region, JptJpaUiMessages.JPA_JPQL_HYPERLINK_BUILDER_OPEN_DECLARATION);
        }
        if (fieldType.isResolvable()) {
            this.addOpenDeclarationHyperlink(fieldType, region, JptJpaUiMessages.JPA_JPQL_HYPERLINK_BUILDER_OPEN_DECLARED_TYPE);
        }
    }

    protected final void addHyperlink(IHyperlink hyperlink) {
        this.hyperlinks.add(hyperlink);
    }

    protected final void addOpenDeclarationHyperlink(IType type, IRegion region) {
        this.addHyperlink(this.buildOpenDeclarationHyperlink(type, region));
    }

    protected final void addOpenDeclarationHyperlink(IType type, IRegion region, String hyperlinkText) {
        this.addHyperlink(this.buildOpenDeclarationHyperlink(type, region, hyperlinkText));
    }

    protected final void addOpenMemberDeclarationHyperlink(IType type, ISourceReference member, IRegion region, String hyperlinkText) {
        this.addHyperlink(this.buildOpenMemberDeclarationHyperlink(type, member, region, hyperlinkText));
    }

    protected final int adjustedPosition(Expression expression) {
        return this.adjustedPosition(expression, 0);
    }

    protected final int adjustedPosition(Expression expression, int offset) {
        int position = ExpressionTools.repositionCursor((CharSequence)expression.getRoot().toActualText(), (int)expression.getOffset(), (CharSequence)this.namedQuery.getQuery());
        return position + offset;
    }

    protected final IHyperlink buildOpenDeclarationHyperlink(IType type, IRegion region) {
        return this.buildOpenDeclarationHyperlink(type, region, JptJpaUiMessages.JPA_JPQL_HYPERLINK_BUILDER_OPEN_DECLARATION);
    }

    protected final IHyperlink buildOpenDeclarationHyperlink(IType type, IRegion region, String hyperlinkText) {
        return new OpenDeclarationHyperlink(this.javaProject(), type.getName(), region, hyperlinkText);
    }

    protected final IHyperlink buildOpenMemberDeclarationHyperlink(IType type, ISourceReference member, IRegion region, String hyperlinkText) {
        return new OpenMemberDeclarationHyperlink(this.javaProject(), type.getName(), member, region, hyperlinkText);
    }

    protected final IRegion buildRegion(Expression expression) {
        return this.buildRegion(expression, 0);
    }

    protected final IRegion buildRegion(Expression expression, int offset) {
        return this.buildRegion(expression, offset, expression.toActualText().length());
    }

    protected final IRegion buildRegion(Expression expression, int offset, int length) {
        return new Region(this.adjustedPosition(expression, offset), length);
    }

    protected Entity getEntity(String typeName) {
        return this.getNamedQuery().getPersistenceUnit().getEntity(typeName);
    }

    protected Entity getEntityNamed(String entityName) {
        for (Entity entity : this.getNamedQuery().getPersistenceUnit().getEntities()) {
            if (!entity.getName().equals(entityName)) continue;
            return entity;
        }
        return null;
    }

    protected final ISourceReference getJavaElement(IType parentType, String memberName) {
        Entity entity = this.getEntity(parentType.getName());
        if (entity == null) {
            return null;
        }
        PersistentAttribute attribute = entity.getPersistentType().getAttributeNamed(memberName);
        if (attribute == null) {
            return null;
        }
        return (ISourceReference)attribute.getJavaPersistentAttribute().getJavaElement();
    }

    protected NamedQuery getNamedQuery() {
        return this.namedQuery;
    }

    protected final int getPosition() {
        return this.queryPosition.getPosition();
    }

    protected final int getPosition(Expression expression) {
        return this.queryPosition.getPosition(expression);
    }

    protected JPQLQueryContext getQueryContext() {
        return this.queryHelper.getQueryContext();
    }

    protected JpaJpqlQueryHelper getQueryHelper() {
        return this.queryHelper;
    }

    protected QueryPosition getQueryPosition() {
        return this.queryPosition;
    }

    protected final IType getType(String typeName) {
        return this.queryHelper.getTypeRepository().getType(typeName);
    }

    protected final IHyperlink[] hyperlinks() {
        int size = this.hyperlinks.size();
        if (size == 0) {
            return null;
        }
        return this.hyperlinks.toArray(new IHyperlink[size]);
    }

    protected final IJavaProject javaProject() {
        return this.namedQuery.getJpaProject().getJavaProject();
    }
}

