/*******************************************************************************
 * Copyright (c) 2013 Zend Techologies Ltd.
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *     Zend Technologies Ltd. - initial API and implementation
 *******************************************************************************/
package org.eclipse.php.internal.formatter.core;

import org.eclipse.wst.html.core.internal.format.HTMLTextFormatter;
import org.eclipse.wst.html.core.internal.provisional.HTMLFormatContraints;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Node;

/**
 * 
 * @author moshe, 2006
 */
@SuppressWarnings("deprecation")
public class HTMLTextFormatterForPHPCode extends HTMLTextFormatter {

	@Override
	protected void formatText(IDOMNode node, HTMLFormatContraints contraints, int mode) {
		Node prev = node.getPreviousSibling();
		Node next = node.getNextSibling();
		if ((prev != null && "PHP".equals(prev.getNodeName())) //$NON-NLS-1$
				|| (next != null && "PHP".equals(next.getNodeName()))) { //$NON-NLS-1$
			return;
		}
		// TODO Auto-generated method stub
		super.formatText(node, contraints, mode);
	}

	@Override
	protected boolean canInsertBreakAfter(Node node) {
		if ("PHP".equals(node.getNodeName())) { //$NON-NLS-1$
			return false;
		}
		Node next = node.getNextSibling();
		if (next != null && "PHP".equals(next.getNodeName())) { //$NON-NLS-1$
			return false;
		}
		return super.canInsertBreakAfter(node);
	}

	@Override
	protected boolean canInsertBreakBefore(Node node) {
		if ("PHP".equals(node.getNodeName())) { //$NON-NLS-1$
			return false;
		}
		Node prev = node.getPreviousSibling();
		if (prev != null && "PHP".equals(prev.getNodeName())) { //$NON-NLS-1$
			return false;
		}
		return super.canInsertBreakBefore(node);
	}

}
