/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsi.internal.core.util;

import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import org.eclipse.wst.wsi.internal.core.util.NullUtil;
import org.eclipse.wst.wsi.internal.core.util.Pair;

public final class ErrorList {
    private Set errors = new HashSet();
    private MessageFormat format = new MessageFormat("{0}:{1}");
    private FieldPosition pos = new FieldPosition(0);

    public ErrorList() {
    }

    public ErrorList(List list) {
        this.add(list);
    }

    public ErrorList(MessageFormat f) {
        if (f != null) {
            this.format = f;
        }
    }

    public void add(List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            this.add((String)iterator.next());
        }
    }

    public void add(String s1, String s2) {
        this.errors.add(new Pair(s1, s2));
    }

    public void add(QName q, String s) {
        this.errors.add(new Pair(NullUtil.toString(q), s));
    }

    public void add(QName q1, QName q2) {
        this.errors.add(new Pair(NullUtil.toString(q1), NullUtil.toString(q2)));
    }

    public void add(QName q) {
        this.errors.add(new Pair(NullUtil.toString(q), null));
    }

    public void add(String s) {
        this.errors.add(new Pair(s, null));
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        Iterator it = this.errors.iterator();
        while (it.hasNext()) {
            Pair p = (Pair)it.next();
            if (p.getFirst() != null && p.getSecond() != null) {
                this.format.format(new Object[]{p.getFirst(), p.getSecond()}, buf, this.pos);
            } else if (p.getFirst() != null) {
                buf.append(p.getFirst());
            } else {
                buf.append(p.getSecond());
            }
            if (!it.hasNext()) continue;
            buf.append(",\n");
        }
        return buf.toString();
    }

    public boolean isEmpty() {
        return this.errors.size() == 0;
    }
}

