/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.commands.internal;

import jakarta.inject.Inject;
import java.util.Map;
import org.eclipse.core.commands.Category;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.CommandManager;
import org.eclipse.core.commands.IParameter;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.e4.core.commands.ECommandService;
import org.eclipse.e4.core.commands.internal.HandlerServiceImpl;
import org.eclipse.e4.core.contexts.IEclipseContext;

public class CommandServiceImpl
implements ECommandService {
    private CommandManager commandManager;
    private IEclipseContext context;

    @Inject
    public void setManager(CommandManager m, IEclipseContext c) {
        this.commandManager = m;
        this.context = c;
    }

    @Override
    public ParameterizedCommand createCommand(String id, Map<String, Object> parameters) {
        Command command = this.getCommand(id);
        if (command == null) {
            return null;
        }
        return ParameterizedCommand.generateCommand((Command)command, parameters);
    }

    @Override
    public Category defineCategory(String id, String name, String description) {
        Category cat = this.commandManager.getCategory(id);
        if (!cat.isDefined()) {
            cat.define(name, description);
        }
        return cat;
    }

    @Override
    public Command defineCommand(String id, String name, String description, Category category, IParameter[] parameters) {
        Command cmd = this.commandManager.getCommand(id);
        if (!cmd.isDefined()) {
            cmd.define(name, description, category, parameters);
            cmd.setHandler(HandlerServiceImpl.getHandler(id, this.context));
        }
        return cmd;
    }

    @Override
    public Category getCategory(String categoryId) {
        return this.commandManager.getCategory(categoryId);
    }

    @Override
    public Command getCommand(String commandId) {
        return this.commandManager.getCommand(commandId);
    }
}

