/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.internal.resources;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.rap.json.JsonObject;
import org.eclipse.rap.rwt.RWT;
import org.eclipse.rap.rwt.SingletonUtil;
import org.eclipse.rap.rwt.internal.protocol.JsonUtil;
import org.eclipse.rap.rwt.internal.protocol.ProtocolMessageWriter;
import org.eclipse.rap.rwt.internal.resources.JavaScriptModule;
import org.eclipse.rap.rwt.internal.resources.JavaScriptModuleLoader;
import org.eclipse.rap.rwt.internal.service.ContextProvider;
import org.eclipse.rap.rwt.internal.util.ClassUtil;
import org.eclipse.rap.rwt.service.ApplicationContext;
import org.eclipse.rap.rwt.service.ResourceManager;

public class JavaScriptModuleLoaderImpl
implements JavaScriptModuleLoader {
    private static final String MODULES_KEY = JavaScriptModuleRegistry.class.getName() + "#instance";
    private static final Object LOCK = new Object();

    @Override
    public void ensureModule(Class<? extends JavaScriptModule> type) {
        if (!JavaScriptModuleLoaderImpl.isLoaded(type)) {
            if (!JavaScriptModuleLoaderImpl.isRegistered(type)) {
                JavaScriptModuleLoaderImpl.registerModule(type);
            }
            JavaScriptModuleLoaderImpl.loadModule(type);
        }
    }

    private static void registerModule(Class<? extends JavaScriptModule> type) {
        JavaScriptModule module = ClassUtil.newInstance(type);
        String[] fileNames = module.getFileNames();
        if (fileNames.length == 0) {
            throw new IllegalStateException("No JavaScript files found!");
        }
        String[] filePaths = new String[fileNames.length];
        try {
            int i = 0;
            while (i < fileNames.length) {
                filePaths[i] = JavaScriptModuleLoaderImpl.registerFile(module, fileNames[i]);
                ++i;
            }
        }
        catch (IOException ioe) {
            throw new IllegalArgumentException("Failed to load resources", ioe);
        }
        JavaScriptModuleLoaderImpl.getApplicationModules().put(type, filePaths);
    }

    private static String registerFile(JavaScriptModule module, String fileName) throws IOException {
        String localPath = JavaScriptModuleLoaderImpl.getLocalPath(module, fileName);
        InputStream inputStream = module.getLoader().getResourceAsStream(localPath);
        if (inputStream == null) {
            throw new IOException("File " + localPath + " does not exist.");
        }
        ResourceManager resourceManager = RWT.getResourceManager();
        String publicPath = JavaScriptModuleLoaderImpl.getPublicPath(module, fileName);
        try {
            resourceManager.register(publicPath, inputStream);
        }
        finally {
            inputStream.close();
        }
        return resourceManager.getLocation(publicPath);
    }

    private static void loadModule(Class<? extends JavaScriptModule> type) {
        String[] files = JavaScriptModuleLoaderImpl.getApplicationModules().get(type);
        ProtocolMessageWriter writer = ContextProvider.getProtocolWriter();
        JsonObject parameters = new JsonObject().add("files", JsonUtil.createJsonArray(files));
        writer.appendCall("rwt.client.JavaScriptLoader", "load", parameters);
        JavaScriptModuleLoaderImpl.getSessionModules().put(type, files);
    }

    private static String getPublicPath(JavaScriptModule module, String fileName) {
        Class<?> type = module.getClass();
        return type.getSimpleName() + type.hashCode() + "/" + fileName;
    }

    private static String getLocalPath(JavaScriptModule module, String fileName) {
        return module.getDirectory() + "/" + fileName;
    }

    private static boolean isRegistered(Class<? extends JavaScriptModule> clazz) {
        return JavaScriptModuleLoaderImpl.getApplicationModules().get(clazz) != null;
    }

    private static boolean isLoaded(Class<? extends JavaScriptModule> clazz) {
        return JavaScriptModuleLoaderImpl.getSessionModules().get(clazz) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static JavaScriptModuleRegistry getApplicationModules() {
        ApplicationContext context = RWT.getApplicationContext();
        Object object = LOCK;
        synchronized (object) {
            JavaScriptModuleRegistry result = (JavaScriptModuleRegistry)context.getAttribute(MODULES_KEY);
            if (result == null) {
                result = new JavaScriptModuleRegistry();
                context.setAttribute(MODULES_KEY, result);
            }
            return result;
        }
    }

    private static JavaScriptModuleRegistry getSessionModules() {
        return SingletonUtil.getSessionInstance(JavaScriptModuleRegistry.class);
    }

    private static class JavaScriptModuleRegistry {
        private final Map<Class<? extends JavaScriptModule>, String[]> map = new HashMap<Class<? extends JavaScriptModule>, String[]>();

        private JavaScriptModuleRegistry() {
        }

        public void put(Class<? extends JavaScriptModule> type, String[] files) {
            this.map.put(type, files);
        }

        public String[] get(Class<? extends JavaScriptModule> type) {
            return this.map.get(type);
        }
    }
}

