/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.tests.unit.tree.tools;

import junit.framework.TestCase;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.sirius.tools.internal.SiriusCopierHelper;
import org.eclipse.sirius.tree.business.internal.dialect.description.TreeToolVariables;
import org.eclipse.sirius.tree.description.DescriptionFactory;
import org.eclipse.sirius.tree.description.TreeItemContainerDropTool;
import org.eclipse.sirius.tree.description.TreeItemCreationTool;
import org.eclipse.sirius.tree.description.TreeItemDeletionTool;
import org.eclipse.sirius.tree.description.TreeItemEditionTool;
import org.eclipse.sirius.tree.description.TreeVariable;

public class NoVariableDuplicationTest
extends TestCase {
    public void testNoVariableDuplicationInCreateTreeItemCreationTool() {
        TreeItemCreationTool treeItemCreationTool = DescriptionFactory.eINSTANCE.createTreeItemCreationTool();
        NoVariableDuplicationTest.assertEquals((String)"No variable must be present in the treeItemCreationTool", (int)0, (int)treeItemCreationTool.getVariables().size());
        new TreeToolVariables().doSwitch((EObject)treeItemCreationTool);
        NoVariableDuplicationTest.assertEquals((String)"The number of variable of treeItemCreationTool must be 3", (int)3, (int)treeItemCreationTool.getVariables().size());
        for (TreeVariable variable : treeItemCreationTool.getVariables()) {
            if ("root".equals(variable.getName()) || "element".equals(variable.getName()) || "container".equals(variable.getName())) continue;
            NoVariableDuplicationTest.fail((String)("The treeItemCreationTool variables' must be naming element, root and container, not " + variable.getName()));
        }
        for (TreeVariable variable : treeItemCreationTool.getVariables()) {
            variable.setName(variable.getName() + "1");
            if ("root1".equals(variable.getName()) || "element1".equals(variable.getName()) || "container1".equals(variable.getName())) continue;
            NoVariableDuplicationTest.fail((String)("The treeItemCreationTool variables' must be naming element1, root1 and container1, not " + variable.getName()));
        }
        this.checkNoModifOncopy((EObject)treeItemCreationTool);
    }

    public void testNoVariableDuplicationTreeItemDeletionTool() {
        TreeItemDeletionTool treeItemDeletionTool = DescriptionFactory.eINSTANCE.createTreeItemDeletionTool();
        NoVariableDuplicationTest.assertEquals((String)"No variable must be present in the treeItemDeletionTool", (int)0, (int)treeItemDeletionTool.getVariables().size());
        new TreeToolVariables().doSwitch((EObject)treeItemDeletionTool);
        NoVariableDuplicationTest.assertEquals((String)"The number of variable of treeItemDeletionTool must be 2", (int)2, (int)treeItemDeletionTool.getVariables().size());
        for (TreeVariable variable : treeItemDeletionTool.getVariables()) {
            if ("root".equals(variable.getName()) || "element".equals(variable.getName())) continue;
            NoVariableDuplicationTest.fail((String)("The treeItemDeletionTool variables' must be naming element and root, not " + variable.getName()));
        }
        for (TreeVariable variable : treeItemDeletionTool.getVariables()) {
            variable.setName(variable.getName() + "1");
            if ("root1".equals(variable.getName()) || "element1".equals(variable.getName())) continue;
            NoVariableDuplicationTest.fail((String)("The treeItemDeletionTool variables' must be naming element1, and root1, not " + variable.getName()));
        }
        this.checkNoModifOncopy((EObject)treeItemDeletionTool);
    }

    public void testNoVariableDuplicationInCreateTreeItemEditionTool() {
        TreeItemEditionTool treeItemEditionTool = DescriptionFactory.eINSTANCE.createTreeItemEditionTool();
        NoVariableDuplicationTest.assertEquals((String)"No variable must be present in the treeItemEditionTool", (int)0, (int)treeItemEditionTool.getVariables().size());
        new TreeToolVariables().doSwitch((EObject)treeItemEditionTool);
        String elementName = treeItemEditionTool.getElement().getName();
        String rootName = treeItemEditionTool.getRoot().getName();
        NoVariableDuplicationTest.assertNotNull((String)"The variable element should not be null", (Object)treeItemEditionTool.getElement());
        NoVariableDuplicationTest.assertEquals((String)("The name of variable element must be \"element\" not " + elementName), (String)"element", (String)elementName);
        NoVariableDuplicationTest.assertNotNull((String)"The variable root should not be null", (Object)treeItemEditionTool.getRoot());
        NoVariableDuplicationTest.assertEquals((String)("The name of variable root must be \"root\" not " + rootName), (String)"root", (String)rootName);
        treeItemEditionTool.getElement().setName(elementName + "1");
        treeItemEditionTool.getRoot().setName(rootName + "1");
        elementName = treeItemEditionTool.getElement().getName();
        rootName = treeItemEditionTool.getRoot().getName();
        NoVariableDuplicationTest.assertEquals((String)("The name of variable element must be \"element1\" not " + elementName), (String)"element1", (String)elementName);
        NoVariableDuplicationTest.assertEquals((String)("The name of variable root must be \"root1\" not " + rootName), (String)"root1", (String)rootName);
        this.checkNoModifOncopy((EObject)treeItemEditionTool);
    }

    public void testNoVariableDuplicationInCreateTreeItemDragTool() {
        TreeItemContainerDropTool dropTool = DescriptionFactory.eINSTANCE.createTreeItemContainerDropTool();
        NoVariableDuplicationTest.assertEquals((String)"No variable must be present in the treeItemDragTool", (int)0, (int)dropTool.getVariables().size());
        new TreeToolVariables().doSwitch((EObject)dropTool);
        String elementName = dropTool.getElement().getName();
        String oldContainerName = dropTool.getOldContainer().getName();
        String newContainerName = dropTool.getNewContainer().getName();
        String newViewContainerName = dropTool.getNewViewContainer().getName();
        String precedingSiblingName = dropTool.getPrecedingSiblings().getName();
        NoVariableDuplicationTest.assertNotNull((String)"The variable element should not be null", (Object)dropTool.getElement());
        NoVariableDuplicationTest.assertEquals((String)("The name of variable element must be \"element\" not " + elementName), (String)"element", (String)elementName);
        NoVariableDuplicationTest.assertNotNull((String)"The variable oldContainer should not be null", (Object)dropTool.getOldContainer());
        NoVariableDuplicationTest.assertEquals((String)("The name of variable oldContainer must be \"oldContainer\" not " + oldContainerName), (String)"oldContainer", (String)oldContainerName);
        NoVariableDuplicationTest.assertNotNull((String)"The variable newContainer should not be null", (Object)dropTool.getNewContainer());
        NoVariableDuplicationTest.assertEquals((String)("The name of variable newContainer must be \"newContainer\" not " + newContainerName), (String)"newContainer", (String)newContainerName);
        NoVariableDuplicationTest.assertNotNull((String)"The variable newViewContainer should not be null", (Object)dropTool.getNewViewContainer());
        NoVariableDuplicationTest.assertEquals((String)("The name of variable newViewContainer must be \"newViewContainer\" not " + newViewContainerName), (String)"newViewContainer", (String)newViewContainerName);
        NoVariableDuplicationTest.assertNotNull((String)"The variable precedingSiblings should not be null", (Object)dropTool.getPrecedingSiblings());
        NoVariableDuplicationTest.assertEquals((String)("The name of variable precedingSiblings must be \"precedingSiblings\" not " + precedingSiblingName), (String)"precedingSiblings", (String)precedingSiblingName);
        dropTool.getElement().setName(elementName + "1");
        dropTool.getOldContainer().setName(oldContainerName + "1");
        dropTool.getNewContainer().setName(newContainerName + "1");
        dropTool.getNewViewContainer().setName(newViewContainerName + "1");
        dropTool.getPrecedingSiblings().setName(precedingSiblingName + "1");
        elementName = dropTool.getElement().getName();
        oldContainerName = dropTool.getOldContainer().getName();
        newContainerName = dropTool.getNewContainer().getName();
        newViewContainerName = dropTool.getNewViewContainer().getName();
        precedingSiblingName = dropTool.getPrecedingSiblings().getName();
        NoVariableDuplicationTest.assertEquals((String)("The name of variable element must be \"element1\" not " + elementName), (String)"element1", (String)elementName);
        NoVariableDuplicationTest.assertEquals((String)("The name of variable oldContainer must be \"oldContainer1\" not " + oldContainerName), (String)"oldContainer1", (String)oldContainerName);
        NoVariableDuplicationTest.assertEquals((String)("The name of variable newContainer must be \"newContainer1\" not " + newContainerName), (String)"newContainer1", (String)newContainerName);
        NoVariableDuplicationTest.assertEquals((String)("The name of variable newViewContainer must be \"newViewContainer1\" not " + newViewContainerName), (String)"newViewContainer1", (String)newViewContainerName);
        NoVariableDuplicationTest.assertEquals((String)("The name of variable precedingSiblings must be \"precedingSiblings1\" not " + precedingSiblingName), (String)"precedingSiblings1", (String)precedingSiblingName);
        this.checkNoModifOncopy((EObject)dropTool);
    }

    private void checkNoModifOncopy(EObject tool) {
        EObject copy = SiriusCopierHelper.copyWithNoUidDuplication((EObject)tool);
        NoVariableDuplicationTest.assertTrue((String)"The copy must be same that origin", (boolean)EcoreUtil.equals((EObject)tool, (EObject)copy));
    }
}

