/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtchart.export.menu.text;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swtchart.ISeries;
import org.eclipse.swtchart.export.core.AbstractSeriesExportHandler;
import org.eclipse.swtchart.export.core.AxisSettings;
import org.eclipse.swtchart.export.core.ISeriesExportConverter;
import org.eclipse.swtchart.export.core.VectorExportSettingsDialog;
import org.eclipse.swtchart.export.menu.text.Messages;
import org.eclipse.swtchart.extensions.core.BaseChart;
import org.eclipse.swtchart.extensions.core.IAxisScaleConverter;
import org.eclipse.swtchart.extensions.core.IAxisSettings;
import org.eclipse.swtchart.extensions.core.ISecondaryAxisSettings;
import org.eclipse.swtchart.extensions.core.ResourceSupport;
import org.eclipse.swtchart.extensions.core.ScrollableChart;

public class LaTeXTableExportHandler
extends AbstractSeriesExportHandler
implements ISeriesExportConverter {
    private static final String FILE_EXTENSION = "*.tex";
    public static final String NAME = String.valueOf(Messages.getString("LATEX_TABLE")) + "*.tex" + ")";
    private static final String TITLE = Messages.getString("SAVE_AS_LATEX");
    private static final String TAB = "\t";
    private static final String DELIMITER = " & ";
    private static final String HORIZONTAL_LINE = "\\hline";
    private static final String LINE_END = " \\\\";

    public String getName() {
        return NAME;
    }

    public Image getIcon() {
        return ResourceSupport.getImage((String)"tex.gif");
    }

    public void execute(Shell shell, ScrollableChart scrollableChart) {
        BaseChart baseChart = scrollableChart.getBaseChart();
        FileDialog fileDialog = new FileDialog(shell, 8192);
        fileDialog.setOverwrite(true);
        fileDialog.setText(TITLE);
        fileDialog.setFilterExtensions(new String[]{FILE_EXTENSION});
        String fileName = fileDialog.open();
        if (fileName != null) {
            VectorExportSettingsDialog exportSettingsDialog = new VectorExportSettingsDialog(shell, baseChart);
            exportSettingsDialog.create();
            if (exportSettingsDialog.open() == 0) {
                int indexAxisX = exportSettingsDialog.getIndexAxisSelectionX();
                int indexAxisY = exportSettingsDialog.getIndexAxisSelectionY();
                if (indexAxisX >= 0 && indexAxisY >= 0) {
                    Object secondaryAxisSettings;
                    IAxisSettings axisSettingsX = baseChart.getXAxisSettings(indexAxisX);
                    IAxisScaleConverter axisScaleConverterX = null;
                    if (axisSettingsX instanceof ISecondaryAxisSettings) {
                        ISecondaryAxisSettings secondaryAxisSettings2 = (ISecondaryAxisSettings)axisSettingsX;
                        axisScaleConverterX = secondaryAxisSettings2.getAxisScaleConverter();
                    }
                    IAxisSettings axisSettingsY = baseChart.getYAxisSettings(indexAxisY);
                    IAxisScaleConverter axisScaleConverterY = null;
                    if (axisSettingsY instanceof ISecondaryAxisSettings) {
                        secondaryAxisSettings = (ISecondaryAxisSettings)axisSettingsY;
                        axisScaleConverterY = secondaryAxisSettings.getAxisScaleConverter();
                    }
                    try {
                        secondaryAxisSettings = null;
                        Object var14_16 = null;
                        try (PrintWriter printWriter = new PrintWriter(new File(fileName));){
                            ISeries[] series;
                            printWriter.println("\\begin{center}");
                            printWriter.println("\\begin{tabular}{ c c }");
                            printWriter.print(TAB);
                            printWriter.print(axisSettingsX.getLabel());
                            printWriter.print(DELIMITER);
                            printWriter.print(axisSettingsY.getLabel());
                            printWriter.println(LINE_END);
                            AxisSettings axisSettings = new AxisSettings();
                            axisSettings.setIndexAxisX(indexAxisX);
                            axisSettings.setIndexAxisY(indexAxisY);
                            axisSettings.setAxisSettingsX(axisSettingsX);
                            axisSettings.setAxisScaleConverterX(axisScaleConverterX);
                            axisSettings.setAxisSettingsY(axisSettingsY);
                            axisSettings.setAxisScaleConverterY(axisScaleConverterY);
                            int widthPlotArea = baseChart.getPlotArea().getSize().x;
                            ISeries[] iSeriesArray = series = baseChart.getSeriesSet().getSeries();
                            int n = series.length;
                            int n2 = 0;
                            while (n2 < n) {
                                ISeries dataSeries = iSeriesArray[n2];
                                if (dataSeries != null && dataSeries.isVisible()) {
                                    this.exportSeries(dataSeries, widthPlotArea, axisSettings, printWriter);
                                }
                                ++n2;
                            }
                            printWriter.println("\\end{tabular}");
                            printWriter.println("\\end{center}");
                            printWriter.flush();
                            MessageDialog.openInformation((Shell)shell, (String)TITLE, (String)MESSAGE_OK);
                        }
                        catch (Throwable throwable) {
                            if (secondaryAxisSettings == null) {
                                secondaryAxisSettings = throwable;
                            } else if (secondaryAxisSettings != throwable) {
                                ((Throwable)secondaryAxisSettings).addSuppressed(throwable);
                            }
                            throw secondaryAxisSettings;
                        }
                    }
                    catch (FileNotFoundException e) {
                        MessageDialog.openError((Shell)shell, (String)TITLE, (String)MESSAGE_ERROR);
                        e.printStackTrace();
                    }
                }
            }
            exportSettingsDialog.reset();
            scrollableChart.updateLegend();
        }
    }

    private void exportSeries(ISeries<?> dataSeries, int widthPlotArea, AxisSettings axisSettings, PrintWriter printWriter) {
        int indexAxisX = axisSettings.getIndexAxisX();
        int indexAxisY = axisSettings.getIndexAxisY();
        IAxisSettings axisSettingsX = axisSettings.getAxisSettingsX();
        DecimalFormat decimalFormatX = axisSettingsX.getDecimalFormat();
        IAxisScaleConverter axisScaleConverterX = axisSettings.getAxisScaleConverterX();
        IAxisSettings axisSettingsY = axisSettings.getAxisSettingsY();
        DecimalFormat decimalFormatY = axisSettingsY.getDecimalFormat();
        IAxisScaleConverter axisScaleConverterY = axisSettings.getAxisScaleConverterY();
        printWriter.println("\t\\hline");
        printWriter.println(TAB + this.getIdentifier(dataSeries) + DELIMITER + LINE_END);
        printWriter.println("\t\\hline");
        double[] xSeries = dataSeries.getXSeries();
        double[] ySeries = dataSeries.getYSeries();
        int size = dataSeries.getXSeries().length;
        int i = 0;
        while (i < size) {
            Point point = dataSeries.getPixelCoordinates(i);
            if (point.x >= 0 && point.x <= widthPlotArea) {
                printWriter.print(TAB);
                this.printValue(printWriter, xSeries[i], indexAxisX, 0, decimalFormatX, axisScaleConverterX);
                printWriter.print(DELIMITER);
                this.printValue(printWriter, ySeries[i], indexAxisY, 0, decimalFormatY, axisScaleConverterY);
                printWriter.println(LINE_END);
            }
            ++i;
        }
        printWriter.print(TAB);
        printWriter.print(DELIMITER);
        printWriter.println(LINE_END);
    }

    private void printValue(PrintWriter printWriter, double value, int indexAxis, int indexPrimaryAxis, DecimalFormat decimalFormat, IAxisScaleConverter axisScaleConverter) {
        if (indexAxis == indexPrimaryAxis) {
            printWriter.print(value);
        } else if (axisScaleConverter != null) {
            printWriter.print(decimalFormat.format(axisScaleConverter.convertToSecondaryUnit(value)));
        } else {
            printWriter.print(decimalFormat.format(value));
        }
    }
}

