/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtchart.extensions.core;

import java.text.DecimalFormat;
import java.text.ParseException;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swtchart.IAxis;
import org.eclipse.swtchart.Range;
import org.eclipse.swtchart.extensions.core.BaseChart;
import org.eclipse.swtchart.extensions.core.IAxisScaleConverter;
import org.eclipse.swtchart.extensions.core.IChartSettings;
import org.eclipse.swtchart.extensions.core.Messages;
import org.eclipse.swtchart.extensions.core.ResourceSupport;
import org.eclipse.swtchart.extensions.core.ScrollableChart;
import org.eclipse.swtchart.extensions.widgets.ExtendedCombo;

public class RangeSelector
extends Composite {
    private ScrollableChart scrollableChart;
    private Text textStartX;
    private Text textStopX;
    private Combo comboScaleX;
    private Text textStartY;
    private Text textStopY;
    private Combo comboScaleY;

    public RangeSelector(Composite parent, int style, ScrollableChart scrollableChart) {
        super(parent, style);
        this.scrollableChart = scrollableChart;
        this.createControl();
    }

    public void resetRanges() {
        IChartSettings chartSettings = this.scrollableChart.getChartSettings();
        BaseChart baseChart = this.scrollableChart.getBaseChart();
        String[] axisLabelsX = baseChart.getAxisLabels("X_AXIS");
        this.comboScaleX.setItems(axisLabelsX);
        if (axisLabelsX.length > 0) {
            int selectedIndex = chartSettings.getRangeSelectorDefaultAxisX();
            if (selectedIndex >= 0 && selectedIndex < axisLabelsX.length) {
                this.comboScaleX.select(selectedIndex);
            } else {
                this.comboScaleX.select(0);
            }
        }
        String[] axisLabelsY = baseChart.getAxisLabels("Y_AXIS");
        this.comboScaleY.setItems(axisLabelsY);
        if (axisLabelsY.length > 0) {
            int selectedIndex = chartSettings.getRangeSelectorDefaultAxisY();
            if (selectedIndex >= 0 && selectedIndex < axisLabelsY.length) {
                this.comboScaleY.select(selectedIndex);
            } else {
                this.comboScaleY.select(0);
            }
        }
    }

    public void adjustRanges(boolean redraw) {
        BaseChart baseChart = this.scrollableChart.getBaseChart();
        int indexX = this.comboScaleX.getSelectionIndex() >= 0 ? this.comboScaleX.getSelectionIndex() : 0;
        int indexY = this.comboScaleY.getSelectionIndex() >= 0 ? this.comboScaleY.getSelectionIndex() : 0;
        IAxis xAxis = baseChart.getAxisSet().getXAxis(indexX);
        IAxis yAxis = baseChart.getAxisSet().getYAxis(indexY);
        Range rangeX = xAxis.getRange();
        Range rangeY = yAxis.getRange();
        DecimalFormat decimalFormatX = baseChart.getDecimalFormat("X_AXIS", indexX);
        DecimalFormat decimalFormatY = baseChart.getDecimalFormat("Y_AXIS", indexY);
        if (rangeX != null && rangeY != null) {
            this.textStartX.setText(decimalFormatX.format(rangeX.lower));
            this.textStopX.setText(decimalFormatX.format(rangeX.upper));
            this.textStartY.setText(decimalFormatY.format(rangeY.lower));
            this.textStopY.setText(decimalFormatY.format(rangeY.upper));
            if (redraw) {
                baseChart.redraw();
            }
        }
    }

    private void createControl() {
        this.setLayout((Layout)new GridLayout(9, false));
        this.textStartX = new Text((Composite)this, 2048);
        this.textStartX.setText("");
        this.textStartX.setLayoutData((Object)this.getTextGridData());
        this.textStopX = new Text((Composite)this, 2048);
        this.textStopX.setText("");
        this.textStopX.setLayoutData((Object)this.getTextGridData());
        this.comboScaleX = ExtendedCombo.create(this, 8);
        this.comboScaleX.setLayoutData((Object)this.getComboGridData());
        this.comboScaleX.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int selectionIndex = RangeSelector.this.comboScaleX.getSelectionIndex();
                BaseChart baseChart = RangeSelector.this.scrollableChart.getBaseChart();
                IAxis xAxis = baseChart.getAxisSet().getXAxis(selectionIndex);
                Range rangeX = xAxis.getRange();
                if (rangeX != null) {
                    DecimalFormat decimalFormatX = baseChart.getDecimalFormat("X_AXIS", selectionIndex);
                    RangeSelector.this.textStartX.setText(decimalFormatX.format(rangeX.lower));
                    RangeSelector.this.textStopX.setText(decimalFormatX.format(rangeX.upper));
                }
            }
        });
        this.textStartY = new Text((Composite)this, 2048);
        this.textStartY.setText("");
        this.textStartY.setLayoutData((Object)this.getTextGridData());
        this.textStopY = new Text((Composite)this, 2048);
        this.textStopY.setText("");
        this.textStopY.setLayoutData((Object)this.getTextGridData());
        this.comboScaleY = ExtendedCombo.create(this, 8);
        this.comboScaleY.setLayoutData((Object)this.getComboGridData());
        this.comboScaleY.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int selectionIndex = RangeSelector.this.comboScaleY.getSelectionIndex();
                BaseChart baseChart = RangeSelector.this.scrollableChart.getBaseChart();
                IAxis yAxis = baseChart.getAxisSet().getYAxis(selectionIndex);
                Range rangeY = yAxis.getRange();
                if (rangeY != null) {
                    DecimalFormat decimalFormatY = baseChart.getDecimalFormat("Y_AXIS", selectionIndex);
                    RangeSelector.this.textStartY.setText(decimalFormatY.format(rangeY.lower));
                    RangeSelector.this.textStopY.setText(decimalFormatY.format(rangeY.upper));
                }
            }
        });
        Button buttonSetRange = new Button((Composite)this, 8);
        buttonSetRange.setText("");
        buttonSetRange.setImage(ResourceSupport.getImage("set_range.svg"));
        buttonSetRange.setToolTipText(Messages.getString("SET_CURRENT_SELECTION"));
        buttonSetRange.setLayoutData((Object)this.getButtonGridData());
        buttonSetRange.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    RangeSelector.this.setRange();
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        });
        Button buttonResetRange = new Button((Composite)this, 8);
        buttonResetRange.setText("");
        buttonResetRange.setImage(ResourceSupport.getImage("reset.svg"));
        buttonResetRange.setToolTipText(Messages.getString("RESET_RANGE"));
        buttonResetRange.setLayoutData((Object)this.getButtonGridData());
        buttonResetRange.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    RangeSelector.this.resetRange();
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        });
        Button buttonHide = new Button((Composite)this, 8);
        buttonHide.setText("");
        buttonHide.setImage(ResourceSupport.getImage("hide.svg"));
        buttonHide.setToolTipText(Messages.getString("HIDE_RANGE_SELECTOR_UI"));
        buttonHide.setLayoutData((Object)this.getButtonGridData());
        buttonHide.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GridData gridData = (GridData)RangeSelector.this.getLayoutData();
                gridData.exclude = true;
                RangeSelector.this.setVisible(false);
                Composite parent = RangeSelector.this.getParent();
                parent.layout(false);
                parent.redraw();
            }
        });
    }

    private void setRange() {
        try {
            Range rangeX = this.getRange("X_AXIS");
            Range rangeY = this.getRange("Y_AXIS");
            if (rangeX != null && rangeY != null) {
                this.scrollableChart.setRange("X_AXIS", rangeX);
                this.scrollableChart.setRange("Y_AXIS", rangeY);
                this.fireUpdateRangeSelection();
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
    }

    private void resetRange() {
        this.scrollableChart.adjustRange(true);
        this.fireUpdateRangeSelection();
    }

    private void fireUpdateRangeSelection() {
        BaseChart baseChart = this.scrollableChart.getBaseChart();
        baseChart.fireUpdateCustomRangeSelectionHandlers();
    }

    private Range getRange(String axis) throws ParseException {
        double valueStop;
        double valueStart;
        DecimalFormat decimalFormat;
        int selectedAxis;
        BaseChart baseChart = this.scrollableChart.getBaseChart();
        if (axis.equals("X_AXIS")) {
            selectedAxis = this.comboScaleX.getSelectionIndex();
            decimalFormat = baseChart.getDecimalFormat("X_AXIS", selectedAxis);
        } else {
            selectedAxis = this.comboScaleY.getSelectionIndex();
            decimalFormat = baseChart.getDecimalFormat("Y_AXIS", selectedAxis);
        }
        if (axis.equals("X_AXIS")) {
            valueStart = decimalFormat.parse(this.textStartX.getText().trim()).doubleValue();
            valueStop = decimalFormat.parse(this.textStopX.getText().trim()).doubleValue();
        } else {
            valueStart = decimalFormat.parse(this.textStartY.getText().trim()).doubleValue();
            valueStop = decimalFormat.parse(this.textStopY.getText().trim()).doubleValue();
        }
        Range range = null;
        if (selectedAxis == 0) {
            range = new Range(valueStart, valueStop);
        } else {
            IAxisScaleConverter axisScaleConverter = baseChart.getAxisScaleConverter(axis, selectedAxis);
            if (axisScaleConverter != null) {
                valueStart = axisScaleConverter.convertToPrimaryUnit(valueStart);
                valueStop = axisScaleConverter.convertToPrimaryUnit(valueStop);
                range = new Range(valueStart, valueStop);
            }
        }
        return range;
    }

    private GridData getTextGridData() {
        GridData gridData = new GridData(768);
        gridData.widthHint = 100;
        return gridData;
    }

    private GridData getComboGridData() {
        GridData gridData = new GridData(768);
        gridData.widthHint = 100;
        return gridData;
    }

    private GridData getButtonGridData() {
        GridData gridData = new GridData();
        gridData.widthHint = 40;
        return gridData;
    }
}

