/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tea.library.build.chain;

import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.runtime.Assert;
import org.eclipse.tea.library.build.chain.TeaDependencyWire;
import org.eclipse.tea.library.build.chain.TeaUnhandledElement;
import org.eclipse.tea.library.build.services.TeaElementFailurePolicy;

@TeaElementFailurePolicy(value=TeaElementFailurePolicy.FailurePolicy.USE_THRESHOLD)
public abstract class TeaBuildElement
implements Comparable<TeaBuildElement> {
    private final TeaDependencyWire selfWire = new TeaDependencyWire(this);
    private final Set<TeaDependencyWire> dependencyWires = new TreeSet<TeaDependencyWire>();
    private int buildOrder = -1;

    public abstract String getName();

    protected final int getBuildOrder() {
        if (this.buildOrder >= 0) {
            return this.buildOrder;
        }
        if (this.buildOrder == -2) {
            throw new IllegalStateException("circular dependency detected in " + this);
        }
        this.buildOrder = -2;
        this.buildOrder = this.calcBuildOrder(1);
        return this.buildOrder;
    }

    protected int calcBuildOrder(int minValue) {
        int result = minValue;
        for (TeaDependencyWire wire : this.dependencyWires) {
            TeaBuildElement target = wire.getTarget();
            if (target instanceof TeaUnhandledElement) {
                throw new RuntimeException("depenendecy from " + this.getName() + " to " + target.getName() + " not possible. Target unhandled.");
            }
            int depOrder = target.getBuildOrder();
            if (depOrder < result) continue;
            result = depOrder + 1;
        }
        return result;
    }

    public void addDependencyWire(TeaDependencyWire wire) {
        Assert.isTrue((this.buildOrder == -1 ? 1 : 0) != 0, (String)"may add dependencies only before order calculation");
        this.dependencyWires.add(wire);
    }

    public Set<TeaDependencyWire> getDependencyWires() {
        return this.dependencyWires;
    }

    public TeaDependencyWire createWire() {
        return this.selfWire;
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + ", name=" + this.getName();
    }

    @Override
    public int compareTo(TeaBuildElement o) {
        return this.getName().compareTo(o.getName());
    }
}

