/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tea.core.internal.model.impl;

import java.lang.reflect.Field;
import java.util.List;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Creatable;
import org.eclipse.e4.core.di.extensions.Service;
import org.eclipse.tea.core.annotations.TaskChainMenuEntry;
import org.eclipse.tea.core.internal.model.iface.TaskingContainer;
import org.eclipse.tea.core.internal.model.impl.TaskingAdditionalItemImpl;
import org.eclipse.tea.core.internal.model.impl.TaskingContainerImpl;
import org.eclipse.tea.core.internal.model.impl.TaskingItemImpl;
import org.eclipse.tea.core.internal.model.impl.TaskingRootGroupImpl;
import org.eclipse.tea.core.services.TaskChain;
import org.eclipse.tea.core.services.TaskingAdditionalMenuEntryProvider;
import org.eclipse.tea.core.services.TaskingMenuDecoration;

@Creatable
public class TaskingModelCreator {
    @Inject
    @Service
    private List<TaskChain> chains;
    @Inject
    @Service
    private List<TaskingAdditionalMenuEntryProvider> additional;
    @Inject
    @Service
    private List<TaskingMenuDecoration> decorations;

    public TaskingContainer createModel() {
        TaskingRootGroupImpl root = new TaskingRootGroupImpl();
        for (TaskingMenuDecoration decoration : this.decorations) {
            Field[] fieldArray = decoration.getClass().getDeclaredFields();
            int n = fieldArray.length;
            int n2 = 0;
            while (n2 < n) {
                TaskingMenuDecoration.TaskingMenuGroupingId grouping;
                Field field = fieldArray[n2];
                TaskingMenuDecoration.TaskingMenuPathDecoration pathDeco = field.getAnnotation(TaskingMenuDecoration.TaskingMenuPathDecoration.class);
                if (pathDeco != null) {
                    TaskingContainerImpl impl = root.createGroup(pathDeco.menuPath(), 0);
                    impl.setDecoration(field);
                }
                if ((grouping = field.getAnnotation(TaskingMenuDecoration.TaskingMenuGroupingId.class)) != null) {
                    TaskingContainerImpl impl = root.createGroup(grouping.menuPath(), 0);
                    impl.addGroupingId(field);
                }
                ++n2;
            }
        }
        for (TaskChain chain : this.chains) {
            TaskChainMenuEntry taskChainMenuEntry = chain.getClass().getAnnotation(TaskChainMenuEntry.class);
            TaskingContainerImpl impl = taskChainMenuEntry != null && taskChainMenuEntry.path().length > 0 ? root.createGroup(taskChainMenuEntry.path(), 0) : root;
            impl.addChild(new TaskingItemImpl(chain));
        }
        for (TaskingAdditionalMenuEntryProvider provider : this.additional) {
            for (TaskingAdditionalMenuEntryProvider.TaskingAdditionalMenuEntry taskingAdditionalMenuEntry : provider.getAdditionalEntries()) {
                TaskingContainerImpl impl = taskingAdditionalMenuEntry.getMenuPath() != null && taskingAdditionalMenuEntry.getMenuPath().length > 0 ? root.createGroup(taskingAdditionalMenuEntry.getMenuPath(), 0) : root;
                impl.addChild(new TaskingAdditionalItemImpl(taskingAdditionalMenuEntry));
            }
        }
        return root;
    }
}

