/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.s.widgetmap;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import org.eclipse.scout.sdk.core.s.widgetmap.IdObjectTypeMap;
import org.eclipse.scout.sdk.core.typescript.model.api.IDataType;
import org.eclipse.scout.sdk.core.typescript.model.api.IES6Class;
import org.eclipse.scout.sdk.core.typescript.model.api.INodeElement;

public class IdObjectTypeMapReference {
    private final IES6Class m_es6Class;
    private final IdObjectTypeMap m_idObjectTypeMap;

    protected IdObjectTypeMapReference(IES6Class es6Class, IdObjectTypeMap idObjectTypeMap) {
        this.m_es6Class = es6Class;
        this.m_idObjectTypeMap = idObjectTypeMap;
    }

    public static Optional<IdObjectTypeMapReference> create(IES6Class es6Class) {
        return Optional.ofNullable(es6Class).map(c -> new IdObjectTypeMapReference((IES6Class)c, null));
    }

    public static Optional<IdObjectTypeMapReference> create(IdObjectTypeMap idObjectTypeMap) {
        return Optional.ofNullable(idObjectTypeMap).map(wm -> new IdObjectTypeMapReference(null, (IdObjectTypeMap)wm));
    }

    protected Optional<IES6Class> es6Class() {
        return Optional.ofNullable(this.m_es6Class);
    }

    protected Optional<IdObjectTypeMap> idObjectTypeMap() {
        return Optional.ofNullable(this.m_idObjectTypeMap);
    }

    public String name() {
        return this.es6Class().map(INodeElement::name).or(() -> this.idObjectTypeMap().map(IdObjectTypeMap::name)).orElseThrow();
    }

    public IDataType reference() {
        return this.es6Class().map(Function.identity()).orElseGet(() -> this.m_idObjectTypeMap.model().spi().createDataType(this.name()).api());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        IdObjectTypeMapReference other = (IdObjectTypeMapReference)obj;
        return Objects.equals(this.m_es6Class, other.m_es6Class) && Objects.equals(this.m_idObjectTypeMap, other.m_idObjectTypeMap);
    }

    public int hashCode() {
        return Objects.hash(this.m_es6Class, this.m_idObjectTypeMap);
    }
}

