/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.internal.proxy.remote;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import org.eclipse.core.runtime.Status;
import org.eclipse.jem.internal.proxy.core.ProxyPlugin;
import org.eclipse.jem.internal.proxy.remote.REMCallbackRegistry;
import org.eclipse.jem.internal.proxy.remote.REMProxyFactoryRegistry;
import org.eclipse.jem.internal.proxy.remote.REMRegistryController;

class REMMasterServerThread
extends Thread {
    protected ServerSocket masterServerSocket;
    protected REMRegistryController registryController;
    protected boolean shuttingDown = false;
    static boolean LINUX_1_3 = "linux".equalsIgnoreCase(System.getProperty("os.name")) && System.getProperty("java.version", "").startsWith("1.3");

    public REMMasterServerThread(REMRegistryController registryController) {
        super("Remote Proxy Master Server Thread");
        this.registryController = registryController;
        try {
            this.masterServerSocket = new ServerSocket(0, 50, InetAddress.getByName("localhost"));
            if (LINUX_1_3) {
                this.masterServerSocket.setSoTimeout(1000);
            }
        }
        catch (SocketException e) {
            ProxyPlugin.getPlugin().getLogger().log((Object)new Status(4, ProxyPlugin.getPlugin().getBundle().getSymbolicName(), 0, "", (Throwable)e));
        }
        catch (IOException e) {
            ProxyPlugin.getPlugin().getLogger().log((Object)new Status(4, ProxyPlugin.getPlugin().getBundle().getSymbolicName(), 0, "", (Throwable)e));
        }
    }

    public ServerSocket getMasterSocket() {
        return this.masterServerSocket;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        block13: {
            try {
                while (this.masterServerSocket != null) {
                    Socket incoming = null;
                    try {
                        incoming = this.masterServerSocket.accept();
                    }
                    catch (InterruptedIOException interruptedIOException) {
                        continue;
                    }
                    catch (NullPointerException nullPointerException) {
                        continue;
                    }
                    boolean close = false;
                    try {
                        close = this.processRequest(incoming);
                    }
                    catch (Throwable throwable) {
                        if (!close) throw throwable;
                        try {
                            incoming.close();
                            throw throwable;
                        }
                        catch (IOException iOException) {}
                        throw throwable;
                    }
                    if (close) {
                        try {
                            incoming.close();
                        }
                        catch (IOException iOException) {}
                    }
                    incoming = null;
                }
            }
            catch (Exception e) {
                if (this.shuttingDown) break block13;
                ProxyPlugin.getPlugin().getLogger().log((Object)new Status(4, ProxyPlugin.getPlugin().getBundle().getSymbolicName(), 0, "", (Throwable)e));
            }
        }
        this.shutdown();
    }

    public void requestShutdown() {
        if (this.masterServerSocket == null) {
            return;
        }
        try {
            this.shuttingDown = true;
            this.masterServerSocket.close();
        }
        catch (Exception exception) {}
    }

    protected boolean processRequest(Socket remote) throws IOException {
        boolean close;
        block28: {
            DataInputStream in = new DataInputStream(remote.getInputStream());
            DataOutputStream out = new DataOutputStream(remote.getOutputStream());
            close = true;
            try {
                try {
                    byte cmd = in.readByte();
                    switch (cmd) {
                        case 16: {
                            int registryID = in.readInt();
                            out.writeBoolean(this.registryController.getRegistry(new Integer(registryID)) != null);
                            out.flush();
                            break;
                        }
                        case 17: {
                            int registryID = in.readInt();
                            int remoteServerPort = in.readInt();
                            REMProxyFactoryRegistry registry = this.registryController.getRegistry(new Integer(registryID));
                            if (registry != null) {
                                registry.setServerPort(remoteServerPort);
                                out.writeBoolean(true);
                            } else {
                                out.writeBoolean(false);
                            }
                            out.flush();
                            break;
                        }
                        case 18: {
                            int registryID = in.readInt();
                            REMProxyFactoryRegistry registry = this.registryController.getRegistry(new Integer(registryID));
                            if (registry != null) {
                                close = !((REMCallbackRegistry)registry.getCallbackRegistry()).createCallback(remote);
                                out.writeBoolean(!close);
                            } else {
                                out.writeBoolean(false);
                            }
                            out.flush();
                        }
                    }
                }
                catch (Exception e) {
                    ProxyPlugin.getPlugin().getLogger().log((Object)new Status(4, ProxyPlugin.getPlugin().getBundle().getSymbolicName(), 0, "", (Throwable)e));
                    if (!close) break block28;
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                    try {
                        out.close();
                    }
                    catch (IOException iOException) {}
                    break block28;
                }
            }
            catch (Throwable throwable) {
                if (close) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                    try {
                        out.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (close) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
        return close;
    }

    private void shutdown() {
        this.requestShutdown();
        this.masterServerSocket = null;
    }
}

