/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.java.ecj;

import java.util.Collections;
import java.util.List;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.scout.sdk.core.java.ecj.AbstractMemberWithEcj;
import org.eclipse.scout.sdk.core.java.ecj.AbstractTypeWithEcj;
import org.eclipse.scout.sdk.core.java.ecj.BindingAnnotationWithEcj;
import org.eclipse.scout.sdk.core.java.ecj.SpiWithEcjUtils;
import org.eclipse.scout.sdk.core.java.model.api.IField;
import org.eclipse.scout.sdk.core.java.model.api.IMetaValue;
import org.eclipse.scout.sdk.core.java.model.api.internal.FieldImplementor;
import org.eclipse.scout.sdk.core.java.model.spi.AbstractJavaEnvironment;
import org.eclipse.scout.sdk.core.java.model.spi.AnnotatableSpi;
import org.eclipse.scout.sdk.core.java.model.spi.FieldSpi;
import org.eclipse.scout.sdk.core.java.model.spi.TypeParameterSpi;
import org.eclipse.scout.sdk.core.java.model.spi.TypeSpi;
import org.eclipse.scout.sdk.core.util.Ensure;
import org.eclipse.scout.sdk.core.util.FinalValue;
import org.eclipse.scout.sdk.core.util.SourceRange;

public class BindingFieldWithEcj
extends AbstractMemberWithEcj<IField>
implements FieldSpi {
    private final AbstractTypeWithEcj m_declaringType;
    private final FieldBinding m_binding;
    private final FinalValue<String> m_name;
    private final FinalValue<TypeSpi> m_type;
    private final FinalValue<List<BindingAnnotationWithEcj>> m_annotations;
    private final FinalValue<IMetaValue> m_constRef;
    private final FinalValue<SourceRange> m_source;
    private final FinalValue<SourceRange> m_initializerSource;
    private final FinalValue<SourceRange> m_javaDocSource;
    private int m_flags;

    protected BindingFieldWithEcj(AbstractJavaEnvironment env, AbstractTypeWithEcj declaringType, FieldBinding binding) {
        super(env);
        this.m_declaringType = (AbstractTypeWithEcj)((Object)Ensure.notNull((Object)((Object)declaringType)));
        this.m_binding = (FieldBinding)Ensure.notNull((Object)binding);
        this.m_flags = -1;
        this.m_name = new FinalValue();
        this.m_type = new FinalValue();
        this.m_annotations = new FinalValue();
        this.m_constRef = new FinalValue();
        this.m_source = new FinalValue();
        this.m_initializerSource = new FinalValue();
        this.m_javaDocSource = new FinalValue();
    }

    public FieldSpi internalFindNewElement() {
        TypeSpi newType = (TypeSpi)this.getDeclaringType().internalFindNewElement();
        if (newType == null) {
            return null;
        }
        String thisElementName = this.getElementName();
        return newType.getFields().stream().filter(newF -> thisElementName.equals(newF.getElementName())).findFirst().orElse(null);
    }

    protected IField internalCreateApi() {
        return new FieldImplementor((FieldSpi)this);
    }

    public FieldBinding getInternalBinding() {
        return this.m_binding;
    }

    public AbstractTypeWithEcj getDeclaringType() {
        return this.m_declaringType;
    }

    public int getFlags() {
        if (this.m_flags < 0) {
            this.m_flags = SpiWithEcjUtils.getTypeFlags(this.m_binding.modifiers, null, SpiWithEcjUtils.hasDeprecatedAnnotation(this.getAnnotations()));
        }
        return this.m_flags;
    }

    protected static TypeBinding getFieldType(BindingFieldWithEcj f) {
        return f.m_binding.type;
    }

    public TypeSpi getDataType() {
        return (TypeSpi)this.m_type.computeIfAbsentAndGet(() -> SpiWithEcjUtils.bindingToType(this.javaEnvWithEcj(), BindingFieldWithEcj.getFieldType(this), () -> (TypeBinding)this.withNewElement(BindingFieldWithEcj::getFieldType)));
    }

    public List<BindingAnnotationWithEcj> getAnnotations() {
        return (List)this.m_annotations.computeIfAbsentAndGet(() -> SpiWithEcjUtils.createBindingAnnotations((AnnotatableSpi)this, (Binding)this.m_binding));
    }

    public String getElementName() {
        return (String)this.m_name.computeIfAbsentAndGet(() -> new String(this.m_binding.name));
    }

    protected static Object getFieldValue(BindingFieldWithEcj f) {
        return f.m_binding.constant();
    }

    public IMetaValue getConstantValue() {
        return (IMetaValue)this.m_constRef.computeIfAbsentAndGet(() -> {
            IMetaValue resolvedValue = SpiWithEcjUtils.resolveCompiledValue(this.javaEnvWithEcj(), (AnnotatableSpi)this, BindingFieldWithEcj.getFieldValue(this), () -> this.withNewElement(BindingFieldWithEcj::getFieldValue));
            if (resolvedValue != null) {
                return resolvedValue;
            }
            return SpiWithEcjUtils.resolveCompiledValue(this.javaEnvWithEcj(), (AnnotatableSpi)this, this.resolveExpressionOf(this), () -> this.withNewElement(this::resolveExpressionOf));
        });
    }

    protected Object resolveExpressionOf(BindingFieldWithEcj field) {
        FieldBinding origBinding = field.m_binding.original();
        ReferenceBinding refBinding = origBinding.declaringClass;
        if (refBinding instanceof SourceTypeBinding) {
            SourceTypeBinding stb = (SourceTypeBinding)refBinding;
            Expression initEx = stb.scope.referenceContext.declarationOf((FieldBinding)origBinding).initialization;
            return SpiWithEcjUtils.compileExpression(initEx, stb.scope, this.javaEnvWithEcj());
        }
        return null;
    }

    public List<TypeParameterSpi> getTypeParameters() {
        return Collections.emptyList();
    }

    public boolean hasTypeParameters() {
        return false;
    }

    public SourceRange getSource() {
        return (SourceRange)this.m_source.computeIfAbsentAndGet(() -> {
            FieldDeclaration decl = this.m_binding.sourceField();
            if (decl == null) {
                return null;
            }
            return this.javaEnvWithEcj().getSource(this.m_declaringType.getCompilationUnit(), decl.declarationSourceStart, decl.declarationSourceEnd);
        });
    }

    public SourceRange getSourceOfInitializer() {
        return (SourceRange)this.m_initializerSource.computeIfAbsentAndGet(() -> {
            FieldDeclaration decl = this.m_binding.sourceField();
            if (decl == null) {
                return null;
            }
            return SpiWithEcjUtils.createSourceRange((ASTNode)decl.initialization, this.m_declaringType.getCompilationUnit(), this.javaEnvWithEcj());
        });
    }

    public SourceRange getJavaDoc() {
        return (SourceRange)this.m_javaDocSource.computeIfAbsentAndGet(() -> {
            FieldDeclaration decl = this.m_binding.sourceField();
            if (decl == null) {
                return null;
            }
            return SpiWithEcjUtils.createSourceRange((ASTNode)decl.javadoc, this.m_declaringType.getCompilationUnit(), this.javaEnvWithEcj());
        });
    }
}

