/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.ws.internal.explorer.platform.uddi.perspective;

import org.eclipse.wst.ws.internal.explorer.platform.datamodel.ListElement;
import org.eclipse.wst.ws.internal.explorer.platform.datamodel.TreeElement;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.Controller;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.NodeManager;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.actions.ServiceGetBusinessAction;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.actions.ServiceGetServiceInterfacesAction;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.datamodel.RegistryElement;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.perspective.AddToFavoritesTool;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.perspective.DetailsTool;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.perspective.GetBusinessesTool;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.perspective.GetServiceInterfacesTool;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.perspective.ServiceDetailsTool;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.perspective.UDDIAddToWSDLPerspectiveTool;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.perspective.UDDIImportWSDLToFileSystemTool;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.perspective.UDDIImportWSDLToWorkbenchTool;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.perspective.UDDILaunchWebServiceWizardTool;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.perspective.UDDINavigatorNode;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.perspective.UDDIPerspective;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.perspective.UnpublishTool;

public class ServiceNode
extends UDDINavigatorNode {
    private DetailsTool detailsTool_;
    private UnpublishTool unpublishTool_;

    public ServiceNode(TreeElement element, NodeManager nodeManager, int nodeDepth) {
        super(element, nodeManager, nodeDepth, "uddi/images/service_highlighted.gif");
    }

    @Override
    protected final void initTools() {
        Controller controller = this.nodeManager_.getController();
        UDDIPerspective uddiPerspective = controller.getUDDIPerspective();
        this.detailsTool_ = new ServiceDetailsTool(this.toolManager_, uddiPerspective.getMessage("ALT_SERVICE_DETAILS"));
        new GetBusinessesTool(this.toolManager_, "uddi/images/business_enabled.gif", "uddi/images/business_highlighted.gif", uddiPerspective.getMessage("ALT_GET_BUSINESS"), ServiceGetBusinessAction.getActionLink(this.nodeId_));
        new GetServiceInterfacesTool(this.toolManager_, uddiPerspective.getMessage("ALT_GET_SERVICE_INTERFACES"), ServiceGetServiceInterfacesAction.getActionLink(this.nodeId_));
        new UDDIImportWSDLToWorkbenchTool(this.toolManager_, controller.getMessage("ALT_IMPORT_WSDL_TO_WORKBENCH"));
        new UDDIImportWSDLToFileSystemTool(this.toolManager_, controller.getMessage("ALT_WSDL_IMPORT_TO_FS"));
        new UDDILaunchWebServiceWizardTool(this.toolManager_, controller.getMessage("ALT_LAUNCH_WEB_SERVICE_WIZARD"));
        new UDDIAddToWSDLPerspectiveTool(this.toolManager_, uddiPerspective.getMessage("ALT_ADD_TO_WSDL_PERSPECTIVE"));
        new AddToFavoritesTool(this.toolManager_, uddiPerspective.getMessage("ALT_ADD_TO_FAVORITES"));
        this.unpublishTool_ = new UnpublishTool(this.toolManager_, "uddi/images/unpublish_service_enabled.gif", "uddi/images/unpublish_service_highlighted.gif", uddiPerspective.getMessage("ALT_UNPUBLISH_SERVICE"));
    }

    @Override
    public void addAuthenticationProperties(RegistryElement regElement) {
        this.detailsTool_.addAuthenticationProperties(regElement);
        this.unpublishTool_.addAuthenticationProperties(regElement);
    }

    public String getWSDLURLFromDetailsTool() {
        ListElement wsdlURLListElement = (ListElement)this.detailsTool_.getProperty("advancedServiceWSDLURL");
        if (wsdlURLListElement != null) {
            return (String)wsdlURLListElement.getObject();
        }
        return "temp.wsdl";
    }
}

