/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d.text;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.text.FlowBorder;
import org.eclipse.draw2d.text.FlowBox;
import org.eclipse.draw2d.text.FlowFigure;
import org.eclipse.draw2d.text.FlowFigureLayout;
import org.eclipse.draw2d.text.InlineFlowLayout;
import org.eclipse.pde.api.tools.annotations.NoExtend;

@NoExtend
public class InlineFlow
extends FlowFigure {
    List<FlowBox> fragments = new ArrayList<FlowBox>(1);

    @Override
    public boolean addLeadingWordRequirements(int[] width) {
        for (IFigure iFigure : this.getChildren()) {
            if (!((FlowFigure)iFigure).addLeadingWordRequirements(width)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsPoint(int x, int y) {
        if (super.containsPoint(x, y)) {
            for (FlowBox flowBox : this.getFragments()) {
                if (!flowBox.containsPoint(x, y)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    protected FlowFigureLayout createDefaultFlowLayout() {
        return new InlineFlowLayout(this);
    }

    public List<? extends FlowBox> getFragments() {
        return this.fragments;
    }

    @Override
    protected void paintBorder(Graphics graphics) {
        if (this.getBorder() != null) {
            FlowBorder fb = (FlowBorder)this.getBorder();
            List<? extends FlowBox> frags = this.getFragments();
            Rectangle where = new Rectangle();
            int i = 0;
            while (i < frags.size()) {
                FlowBox box = frags.get(i);
                where.x = box.getX();
                where.width = box.getWidth();
                where.y = -box.getAscentWithBorder();
                where.height = box.getDescentWithBorder() - where.y;
                where.y += box.getBaseline();
                int sides = 0;
                if (i == 0) {
                    sides = 16384;
                }
                if (i == frags.size() - 1) {
                    sides |= 0x20000;
                }
                fb.paint(this, graphics, where, sides);
                ++i;
            }
            graphics.restoreState();
        }
        if (this.selectionStart != -1) {
            this.paintSelection(graphics);
        }
    }

    protected void paintSelection(Graphics graphics) {
        graphics.restoreState();
        graphics.setXORMode(true);
        graphics.setBackgroundColor(ColorConstants.white);
        for (FlowBox flowBox : this.getFragments()) {
            int top = flowBox.getLineRoot().getVisibleTop();
            int bottom = flowBox.getLineRoot().getVisibleBottom();
            graphics.fillRectangle(flowBox.getX(), top, flowBox.getWidth(), bottom - top);
        }
    }

    @Override
    public void postValidate() {
        int right;
        int left;
        int top = left = Integer.MAX_VALUE;
        int bottom = right = Integer.MIN_VALUE;
        for (FlowBox flowBox : this.getFragments()) {
            left = Math.min(left, flowBox.getX());
            right = Math.max(right, flowBox.getX() + flowBox.getWidth());
            top = Math.min(top, flowBox.getLineRoot().getVisibleTop());
            bottom = Math.max(bottom, flowBox.getLineRoot().getVisibleBottom());
        }
        this.setBounds(new Rectangle(left, top, right - left, bottom - top));
        this.repaint();
        this.getChildren().forEach(child -> ((FlowFigure)child).postValidate());
    }

    @Override
    public void setBorder(Border border) {
        if (border != null && !(border instanceof FlowBorder)) {
            throw new RuntimeException("Border must be an instance of FlowBorder");
        }
        super.setBorder(border);
    }
}

