/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.typescript.model.api.query;

import java.util.stream.Stream;
import org.eclipse.scout.sdk.core.model.query.AbstractQuery;
import org.eclipse.scout.sdk.core.typescript.model.api.IFunction;
import org.eclipse.scout.sdk.core.typescript.model.spi.ES6ClassSpi;
import org.eclipse.scout.sdk.core.typescript.model.spi.FunctionSpi;

public class FunctionQuery
extends AbstractQuery<IFunction> {
    private final ES6ClassSpi m_es6ClassSpi;
    private String m_name;

    public FunctionQuery(ES6ClassSpi es6Class) {
        this.m_es6ClassSpi = es6Class;
    }

    public FunctionQuery withName(String name) {
        this.m_name = name;
        return this;
    }

    protected String getName() {
        return this.m_name;
    }

    protected ES6ClassSpi es6Class() {
        return this.m_es6ClassSpi;
    }

    protected Stream<IFunction> createStream() {
        return this.es6Class().functions().stream().filter(this::test).map(FunctionSpi::api);
    }

    protected boolean test(FunctionSpi function) {
        String name = this.getName();
        return name == null || name.equals(function.name());
    }
}

