/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.java.ecj;

import java.util.Collections;
import java.util.List;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Argument;
import org.eclipse.jdt.internal.compiler.lookup.AnnotationBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.scout.sdk.core.java.ecj.AbstractJavaElementWithEcj;
import org.eclipse.scout.sdk.core.java.ecj.BindingAnnotationWithEcj;
import org.eclipse.scout.sdk.core.java.ecj.BindingMethodWithEcj;
import org.eclipse.scout.sdk.core.java.ecj.SpiWithEcjUtils;
import org.eclipse.scout.sdk.core.java.model.api.IMethodParameter;
import org.eclipse.scout.sdk.core.java.model.api.internal.MethodParameterImplementor;
import org.eclipse.scout.sdk.core.java.model.spi.AbstractJavaEnvironment;
import org.eclipse.scout.sdk.core.java.model.spi.AnnotatableSpi;
import org.eclipse.scout.sdk.core.java.model.spi.CompilationUnitSpi;
import org.eclipse.scout.sdk.core.java.model.spi.MethodParameterSpi;
import org.eclipse.scout.sdk.core.java.model.spi.MethodSpi;
import org.eclipse.scout.sdk.core.java.model.spi.TypeSpi;
import org.eclipse.scout.sdk.core.util.Ensure;
import org.eclipse.scout.sdk.core.util.FinalValue;
import org.eclipse.scout.sdk.core.util.SourceRange;

public class BindingMethodParameterWithEcj
extends AbstractJavaElementWithEcj<IMethodParameter>
implements MethodParameterSpi {
    private final BindingMethodWithEcj m_declaringMethod;
    private final TypeBinding m_binding;
    private final int m_index;
    private final int m_flags;
    private final char[] m_name;
    private final FinalValue<TypeSpi> m_dataType;
    private final FinalValue<SourceRange> m_source;
    private final FinalValue<String> m_nameAsString;
    private final FinalValue<List<BindingAnnotationWithEcj>> m_annotations;

    protected BindingMethodParameterWithEcj(AbstractJavaEnvironment env, BindingMethodWithEcj declaringMethod, TypeBinding binding, char[] name, int flags, int index) {
        super(env);
        this.m_index = index;
        this.m_flags = flags;
        this.m_name = (char[])Ensure.notNull((Object)name);
        this.m_binding = (TypeBinding)Ensure.notNull((Object)binding);
        this.m_declaringMethod = (BindingMethodWithEcj)((Object)Ensure.notNull((Object)((Object)declaringMethod)));
        this.m_dataType = new FinalValue();
        this.m_source = new FinalValue();
        this.m_nameAsString = new FinalValue();
        this.m_annotations = new FinalValue();
    }

    public MethodParameterSpi internalFindNewElement() {
        MethodSpi newMethod = this.getDeclaringMethod().internalFindNewElement();
        if (newMethod != null && newMethod.getParameters().size() > this.m_index) {
            return (MethodParameterSpi)newMethod.getParameters().get(this.m_index);
        }
        return null;
    }

    protected IMethodParameter internalCreateApi() {
        return new MethodParameterImplementor((MethodParameterSpi)this);
    }

    public TypeBinding getInternalBinding() {
        return this.m_binding;
    }

    public String getElementName() {
        return (String)this.m_nameAsString.computeIfAbsentAndGet(() -> new String(this.m_name));
    }

    protected static TypeBinding getParameterType(BindingMethodParameterWithEcj mp) {
        return mp.m_binding;
    }

    public TypeSpi getDataType() {
        return (TypeSpi)this.m_dataType.computeIfAbsentAndGet(() -> SpiWithEcjUtils.bindingToType(this.javaEnvWithEcj(), BindingMethodParameterWithEcj.getParameterType(this), () -> (TypeBinding)this.withNewElement(BindingMethodParameterWithEcj::getParameterType)));
    }

    public int getIndex() {
        return this.m_index;
    }

    public int getFlags() {
        return this.m_flags;
    }

    public BindingMethodWithEcj getDeclaringMethod() {
        return this.m_declaringMethod;
    }

    public List<BindingAnnotationWithEcj> getAnnotations() {
        return (List)this.m_annotations.computeIfAbsentAndGet(this::computeAnnotations);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<BindingAnnotationWithEcj> computeAnnotations() {
        AnnotationBinding[][] annotations;
        Object object = this.javaEnvWithEcj().lock();
        synchronized (object) {
            annotations = this.m_declaringMethod.getInternalBinding().getParameterAnnotations();
        }
        if (annotations == null || this.m_index >= annotations.length) {
            return Collections.emptyList();
        }
        return SpiWithEcjUtils.createBindingAnnotations((AnnotatableSpi)this, annotations[this.m_index]);
    }

    public SourceRange getSource() {
        return (SourceRange)this.m_source.computeIfAbsentAndGet(() -> {
            AbstractMethodDeclaration declMethod = SpiWithEcjUtils.sourceMethodOf(this.m_declaringMethod);
            if (declMethod != null) {
                CompilationUnitSpi cu = this.m_declaringMethod.getDeclaringType().getCompilationUnit();
                Argument decl = declMethod.arguments[this.m_index];
                return this.javaEnvWithEcj().getSource(cu, decl.declarationSourceStart, decl.declarationSourceEnd);
            }
            return null;
        });
    }
}

