/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.core.internal;

import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IModuleType;
import org.eclipse.wst.server.core.IPublishListener;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IRuntimeWorkingCopy;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerListener;
import org.eclipse.wst.server.core.IServerType;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.core.ServerUtil;
import org.eclipse.wst.server.core.internal.Messages;
import org.eclipse.wst.server.core.internal.Module;
import org.eclipse.wst.server.core.internal.ProgressUtil;
import org.eclipse.wst.server.core.internal.Publisher;
import org.eclipse.wst.server.core.internal.Server;
import org.eclipse.wst.server.core.internal.ServerPlugin;
import org.eclipse.wst.server.core.internal.ServerType;
import org.eclipse.wst.server.core.internal.Trace;
import org.eclipse.wst.server.core.internal.WorkingCopyHelper;
import org.eclipse.wst.server.core.model.InternalInitializer;
import org.eclipse.wst.server.core.model.PublishOperation;
import org.eclipse.wst.server.core.model.ServerBehaviourDelegate;
import org.eclipse.wst.server.core.model.ServerDelegate;

public class ServerWorkingCopy
extends Server
implements IServerWorkingCopy {
    protected Server server;
    protected WorkingCopyHelper wch;
    protected ServerDelegate workingCopyDelegate;

    public ServerWorkingCopy(Server server) {
        super(server.getFile());
        this.server = server;
        this.map = new HashMap(server.map);
        this.wch = new WorkingCopyHelper(this);
        this.resolve();
    }

    public ServerWorkingCopy(String id, IFile file, IRuntime runtime, IServerType serverType) {
        super(id, file, runtime, serverType);
        this.wch = new WorkingCopyHelper(this);
        this.wch.setDirty(true);
        if (serverType instanceof ServerType) {
            this.serverState = ((ServerType)serverType).getInitialState();
        }
    }

    @Override
    public boolean isWorkingCopy() {
        return true;
    }

    @Override
    public IServer getOriginal() {
        return this.server;
    }

    @Override
    public IServerWorkingCopy createWorkingCopy() {
        return this;
    }

    @Override
    public int getServerState() {
        if (this.server != null) {
            return this.server.getServerState();
        }
        return super.getServerState();
    }

    @Override
    public void setServerState(int state) {
        if (this.server != null) {
            this.server.setServerState(state);
        } else {
            super.setServerState(state);
        }
    }

    @Override
    public int getServerPublishState() {
        if (this.server != null) {
            return this.server.getServerPublishState();
        }
        return super.getServerPublishState();
    }

    @Override
    public void setServerPublishState(int state) {
        if (this.server != null) {
            this.server.setServerPublishState(state);
        } else {
            super.setServerPublishState(state);
        }
    }

    @Override
    public IStatus getServerStatus() {
        if (this.server != null) {
            return this.server.getServerStatus();
        }
        return super.getServerStatus();
    }

    @Override
    public void setServerStatus(IStatus status) {
        if (this.server != null) {
            this.server.setServerStatus(status);
        } else {
            super.setServerStatus(status);
        }
    }

    @Override
    public int getModuleState(IModule[] module) {
        if (this.server != null) {
            return this.server.getModuleState(module);
        }
        return super.getModuleState(module);
    }

    @Override
    public void setModuleState(IModule[] module, int state) {
        if (this.server != null) {
            this.server.setModuleState(module, state);
        } else {
            super.setModuleState(module, state);
        }
    }

    @Override
    public int getModulePublishState(IModule[] module) {
        if (this.server != null) {
            return this.server.getModulePublishState(module);
        }
        return super.getModulePublishState(module);
    }

    @Override
    public void setModulePublishState(IModule[] module, int state) {
        if (this.server != null) {
            this.server.setModulePublishState(module, state);
        } else {
            super.setModulePublishState(module, state);
        }
    }

    @Override
    public boolean getModuleRestartState(IModule[] module) {
        if (this.server != null) {
            return this.server.getModuleRestartState(module);
        }
        return super.getModuleRestartState(module);
    }

    @Override
    public void setModuleRestartState(IModule[] module, boolean r) {
        if (this.server != null) {
            this.server.setModuleRestartState(module, r);
        } else {
            super.setModuleRestartState(module, r);
        }
    }

    @Override
    public IStatus getModuleStatus(IModule[] module) {
        if (this.server != null) {
            return this.server.getModuleStatus(module);
        }
        return super.getModuleStatus(module);
    }

    @Override
    public void setModuleStatus(IModule[] module, IStatus status) {
        if (this.server != null) {
            this.server.setModuleStatus(module, status);
        } else {
            super.setModuleStatus(module, status);
        }
    }

    @Override
    public String getMode() {
        if (this.server != null) {
            return this.server.getMode();
        }
        return this.mode;
    }

    @Override
    public void setMode(String mode) {
        if (this.server != null) {
            this.server.setMode(mode);
        } else {
            super.setMode(mode);
        }
    }

    @Override
    public void setAttribute(String attributeName, int value) {
        this.canModifyAttribute(attributeName);
        this.wch.setAttribute(attributeName, value);
    }

    @Override
    public void setAttribute(String attributeName, boolean value) {
        this.canModifyAttribute(attributeName);
        this.wch.setAttribute(attributeName, value);
    }

    @Override
    public void setAttribute(String attributeName, String value) {
        this.canModifyAttribute(attributeName);
        this.wch.setAttribute(attributeName, value);
    }

    @Override
    public void setAttribute(String attributeName, List<String> value) {
        this.canModifyAttribute(attributeName);
        this.wch.setAttribute(attributeName, value);
    }

    @Override
    public void setAttribute(String attributeName, Map value) {
        this.canModifyAttribute(attributeName);
        this.wch.setAttribute(attributeName, value);
    }

    @Override
    public void setName(String name) {
        this.setAttribute("name", name);
        boolean set = this.getAttribute("id-set", false);
        if (this.server == null && !set) {
            this.setAttribute("id", name);
        }
    }

    @Override
    public void setReadOnly(boolean b) {
        this.setAttribute("locked", b);
    }

    public void setPrivate(boolean b) {
        this.setAttribute("private", b);
    }

    @Override
    public void setHost(String host) {
        this.setAttribute("hostname", host);
    }

    public void setAutoPublishTime(int p) {
        this.setAttribute("auto-publish-time", p);
    }

    public void setStartTimeout(int p) {
        this.setAttribute("start-timeout", p);
    }

    public void setStopTimeout(int p) {
        this.setAttribute("stop-timeout", p);
    }

    public void setAutoPublishSetting(int s) {
        this.setAttribute("auto-publish-setting", s);
    }

    @Override
    public void setServerConfiguration(IFolder config) {
        this.configuration = config;
        if (this.configuration == null) {
            this.setAttribute("configuration-id", (String)null);
        } else {
            this.setAttribute("configuration-id", this.configuration.getFullPath().toString());
        }
    }

    public boolean disablePreferredPublishOperations(PublishOperation op) {
        String opId;
        List<String> list = this.getAttribute("disabled-preferred-publish-tasks", (List<String>)null);
        if (list == null) {
            list = new ArrayList<String>();
        }
        if (list.contains(opId = this.getPublishOperationId(op))) {
            return false;
        }
        list.add(opId);
        this.setAttribute("disabled-preferred-publish-tasks", list);
        return true;
    }

    public boolean enableOptionalPublishOperations(PublishOperation op) {
        String opId;
        List<String> list = this.getAttribute("enabled-optional-publish-tasks", (List<String>)null);
        if (list == null) {
            list = new ArrayList<String>();
        }
        if (list.contains(opId = this.getPublishOperationId(op))) {
            return false;
        }
        list.add(opId);
        this.setAttribute("enabled-optional-publish-tasks", list);
        return true;
    }

    public void resetPreferredPublishOperations() {
        this.setAttribute("disabled-preferred-publish-tasks", (List<String>)null);
    }

    public void resetOptionalPublishOperations() {
        this.setAttribute("enabled-optional-publish-tasks", (List<String>)null);
    }

    public void setPublisherEnabled(Publisher pub, boolean enabled) {
        if (pub == null) {
            return;
        }
        List<String> list = this.getAttribute("publishers", EMPTY_LIST);
        ArrayList<String> newList = new ArrayList<String>();
        for (String id : list) {
            int ind = id.indexOf(":");
            if (pub.getId().equals(id.substring(0, ind))) continue;
            newList.add(id);
        }
        String s = String.valueOf(pub.getId()) + ":";
        s = enabled ? String.valueOf(s) + "true" : String.valueOf(s) + "false";
        newList.add(s);
        this.setAttribute("publishers", newList);
    }

    public void setFile(IFile file) {
        this.file = file;
    }

    @Override
    public boolean isDirty() {
        return this.wch.isDirty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServerDelegate getWorkingCopyDelegate(IProgressMonitor monitor) {
        if (this.workingCopyDelegate != null || this.serverType == null) {
            return this.workingCopyDelegate;
        }
        ServerWorkingCopy serverWorkingCopy = this;
        synchronized (serverWorkingCopy) {
            block8: {
                if (this.workingCopyDelegate == null) {
                    try {
                        long time = System.currentTimeMillis();
                        this.workingCopyDelegate = ((ServerType)this.serverType).createServerDelegate();
                        InternalInitializer.initializeServerDelegate(this.workingCopyDelegate, this, monitor);
                        if (Trace.PERFORMANCE) {
                            Trace.trace("/performance", "ServerWorkingCopy.getWorkingCopyDelegate(): <" + (System.currentTimeMillis() - time) + "> " + this.getServerType().getId());
                        }
                    }
                    catch (Exception e) {
                        if (!Trace.SEVERE) break block8;
                        Trace.trace("/severe", "Could not create delegate " + this.toString(), e);
                    }
                }
            }
        }
        return this.workingCopyDelegate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ServerBehaviourDelegate getBehaviourDelegate(IProgressMonitor monitor) {
        if (this.server == null) {
            return null;
        }
        if (this.behaviourDelegate != null) {
            return this.behaviourDelegate;
        }
        ServerWorkingCopy serverWorkingCopy = this;
        synchronized (serverWorkingCopy) {
            if (this.behaviourDelegate == null) {
                this.behaviourDelegate = this.server.getBehaviourDelegate(monitor);
            }
        }
        return this.behaviourDelegate;
    }

    @Override
    public void dispose() {
        this.behaviourDelegate = null;
        super.dispose();
        if (this.workingCopyDelegate != null) {
            this.workingCopyDelegate.dispose();
        }
    }

    @Override
    public IServer save(boolean force, IProgressMonitor monitor) throws CoreException {
        IFolder folder;
        monitor = ProgressUtil.getMonitorFor(monitor);
        monitor.subTask(NLS.bind((String)Messages.savingTask, (Object)this.getName()));
        if (!force && this.getOriginal() != null) {
            this.wch.validateTimestamp(((Server)this.getOriginal()).getTimestamp());
        }
        int timestamp = this.getTimestamp();
        this.map.put("timestamp", Integer.toString(timestamp + 1));
        if (this.server == null) {
            this.server = new Server(this.file);
            this.server.setServerState(this.serverState);
            this.server.publishListeners = this.publishListeners;
            this.server.notificationManager = this.notificationManager;
        }
        if (this.getServerType() != null && this.getServerType().hasServerConfiguration() && (folder = this.getServerConfiguration()) == null) {
            folder = ServerType.getServerProject().getFolder(String.valueOf(this.getName()) + "-config");
            if (!folder.exists()) {
                folder.create(true, true, null);
            }
            this.setServerConfiguration(folder);
        }
        this.server.setInternal(this);
        this.server.doSave(monitor);
        if (this.getServerType() != null && this.getServerType().hasServerConfiguration() && (folder = this.getServerConfiguration()) != null) {
            IProject project = folder.getProject();
            if (project != null && !project.exists()) {
                project.create(null);
                project.open(null);
                ServerPlugin.getProjectProperties(project).setServerProject(true, monitor);
            }
            if (!folder.exists()) {
                folder.create(1, true, null);
            }
        }
        if (this.getWorkingCopyDelegate(monitor) != null) {
            this.getWorkingCopyDelegate(monitor).saveConfiguration(monitor);
        }
        this.wch.setDirty(false);
        if (this.getServerState() == 2) {
            this.server.autoPublish();
        }
        return this.server;
    }

    @Override
    public IServer saveAll(boolean force, IProgressMonitor monitor) throws CoreException {
        if (this.runtime != null && this.runtime.isWorkingCopy()) {
            IRuntimeWorkingCopy wc = (IRuntimeWorkingCopy)this.runtime;
            wc.save(force, monitor);
        }
        return this.save(force, monitor);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Listener cannot be null");
        }
        this.wch.addPropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Listener cannot be null");
        }
        this.wch.removePropertyChangeListener(listener);
    }

    public void firePropertyChangeEvent(String propertyName, Object oldValue, Object newValue) {
        this.wch.firePropertyChangeEvent(propertyName, oldValue, newValue);
    }

    @Override
    public void addServerListener(IServerListener listener) {
        if (this.server != null) {
            this.server.addServerListener(listener);
        } else {
            super.addServerListener(listener);
        }
    }

    @Override
    public void removeServerListener(IServerListener listener) {
        if (this.server != null) {
            this.server.removeServerListener(listener);
        } else {
            super.removeServerListener(listener);
        }
    }

    @Override
    public void addPublishListener(IPublishListener listener) {
        if (this.server != null) {
            this.server.addPublishListener(listener);
        } else {
            super.addPublishListener(listener);
        }
    }

    @Override
    public void removePublishListener(IPublishListener listener) {
        if (this.server != null) {
            this.server.removePublishListener(listener);
        } else {
            super.removePublishListener(listener);
        }
    }

    @Override
    public void setRuntime(IRuntime runtime) {
        this.runtime = runtime;
        if (runtime != null) {
            this.setAttribute("runtime-id", runtime.getId());
        } else {
            this.setAttribute("runtime-id", (String)null);
        }
    }

    public void setRuntimeId(String runtimeId) {
        this.setAttribute("runtime-id", runtimeId);
        this.resolve();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void modifyModules(IModule[] add, IModule[] remove, IProgressMonitor monitor) throws CoreException {
        IStatus status = this.canModifyModules(add, remove, monitor);
        if (status != null && status.getSeverity() == 4) {
            throw new CoreException(status);
        }
        try {
            monitor = ProgressUtil.getMonitorFor(monitor);
            monitor.subTask(Messages.taskModifyModules);
            this.getWorkingCopyDelegate(monitor).modifyModules(add, remove, monitor);
            this.wch.setDirty(true);
            Object object = this.modulesLock;
            synchronized (object) {
                int i;
                int size;
                this.getModulesWithoutLock();
                if (add != null) {
                    size = add.length;
                    i = 0;
                    while (i < size) {
                        if (!this.modules.contains(add[i])) {
                            this.modules.add(add[i]);
                            this.resetState(new IModule[]{add[i]}, monitor);
                        }
                        ++i;
                    }
                }
                if (remove != null) {
                    size = remove.length;
                    this.externalModules = this.getExternalModules();
                    i = 0;
                    while (i < size) {
                        if (this.modules.contains(remove[i])) {
                            this.modules.remove(remove[i]);
                            this.resetState(new IModule[]{remove[i]}, monitor);
                        }
                        if (this.externalModules != null && this.externalModules.contains(remove[i])) {
                            this.externalModules.remove(remove[i]);
                            this.resetState(new IModule[]{remove[i]}, monitor);
                        }
                        ++i;
                    }
                }
                ArrayList<String> list = new ArrayList<String>();
                for (IModule module : this.modules) {
                    StringBuffer sb = new StringBuffer(module.getName());
                    sb.append("::");
                    sb.append(module.getId());
                    IModuleType mt = module.getModuleType();
                    if (mt != null) {
                        sb.append("::");
                        sb.append(mt.getId());
                        sb.append("::");
                        sb.append(mt.getVersion());
                    }
                    list.add(sb.toString());
                }
                this.setAttribute("modules", list);
            }
            this.resetOptionalPublishOperations();
            this.resetPreferredPublishOperations();
        }
        catch (CoreException ce) {
            throw ce;
        }
        catch (Exception e) {
            if (Trace.SEVERE) {
                Trace.trace("/severe", "Error calling delegate modifyModule() " + this.toString(), e);
            }
            throw new CoreException((IStatus)new Status(4, "org.eclipse.wst.server.core", 0, e.getLocalizedMessage(), (Throwable)e));
        }
    }

    protected void resetState(IModule[] module, IProgressMonitor monitor) {
        this.setModulePublishState(module, 0);
        this.setModuleState(module, 0);
        this.setModuleRestartState(module, false);
        this.setModuleStatus(module, null);
        try {
            IModule[] children = this.getChildModules(module, monitor);
            int size = children.length;
            int size2 = module.length;
            int i = 0;
            while (i < size) {
                IModule[] child = new Module[size2 + 1];
                System.arraycopy(module, 0, child, 0, size2);
                child[size2] = children[i];
                this.resetPublishState(child, monitor);
                this.setModuleState(module, 0);
                this.setModuleRestartState(module, false);
                this.setModuleStatus(module, null);
                ++i;
            }
        }
        catch (Exception exception) {}
    }

    protected void resetPublishState(IModule[] module, IProgressMonitor monitor) {
        this.setModulePublishState(module, 0);
        try {
            IModule[] children = this.getChildModules(module, monitor);
            int size = children.length;
            int size2 = module.length;
            int i = 0;
            while (i < size) {
                IModule[] child = new Module[size2 + 1];
                System.arraycopy(module, 0, child, 0, size2);
                child[size2] = children[i];
                this.resetPublishState(child, monitor);
                ++i;
            }
        }
        catch (Exception exception) {}
    }

    public void setDefaults(IProgressMonitor monitor) {
        block2: {
            try {
                ServerUtil.setServerDefaultName(this);
                this.getWorkingCopyDelegate(monitor).setDefaults(monitor);
            }
            catch (Exception e) {
                if (!Trace.SEVERE) break block2;
                Trace.trace("/severe", "Error calling delegate setDefaults() " + this.toString(), e);
            }
        }
    }

    public void newServerDetailsChanged(IProgressMonitor monitor) {
        block2: {
            try {
                this.getWorkingCopyDelegate(monitor).newServerDetailsChanged(monitor);
            }
            catch (Exception e) {
                if (!Trace.SEVERE) break block2;
                Trace.trace("/severe", "Error calling delegate newServerDetailsChanged() " + this.toString(), e);
            }
        }
    }

    public void renameFiles(IProgressMonitor monitor) throws CoreException {
        if (this.getServerConfiguration() != null) {
            IFolder folder = this.getServerConfiguration();
            IFolder folder2 = ServerType.getServerProject().getFolder(String.valueOf(this.getName()) + "-config");
            folder.move(folder2.getFullPath(), true, true, monitor);
            this.setServerConfiguration(folder2);
            this.save(true, monitor);
        }
        if (this.file != null) {
            IFile file2 = ServerUtil.getUnusedServerFile(this.file.getProject(), this);
            this.file.move(file2.getFullPath(), true, true, monitor);
        }
    }

    @Override
    public IStatus publish(int kind, IProgressMonitor monitor) {
        if (this.server != null) {
            return this.server.publish(kind, monitor);
        }
        return new Status(4, "org.eclipse.wst.server.core", 0, Messages.errorPublishing, null);
    }

    @Override
    public void publish(int kind, List<IModule[]> modules2, IAdaptable info, IServer.IOperationListener listener) {
        if (this.server != null) {
            this.server.publish(kind, modules2, info, listener);
            return;
        }
        listener.done((IStatus)new Status(4, "org.eclipse.wst.server.core", 0, Messages.errorPublishing, null));
    }

    @Override
    public ILaunch getLaunch() {
        if (this.server != null) {
            return this.server.getLaunch();
        }
        return null;
    }

    @Override
    public ILaunchConfiguration getLaunchConfiguration(boolean create, IProgressMonitor monitor) throws CoreException {
        if (this.server != null) {
            return this.server.getLaunchConfiguration(create, monitor);
        }
        return null;
    }

    @Override
    public void setServerRestartState(boolean state) {
        if (this.server != null) {
            this.server.setServerRestartState(state);
        } else {
            super.setServerRestartState(state);
        }
    }

    @Override
    public Object getAdapter(Class adapter) {
        if (this.workingCopyDelegate != null && adapter.isInstance(this.workingCopyDelegate)) {
            return this.workingCopyDelegate;
        }
        if (this.delegate != null && adapter.isInstance(this.delegate)) {
            return this.delegate;
        }
        if (this.behaviourDelegate != null && adapter.isInstance(this.behaviourDelegate)) {
            return this.behaviourDelegate;
        }
        return Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }

    @Override
    public Object loadAdapter(Class adapter, IProgressMonitor monitor) {
        this.getWorkingCopyDelegate(monitor);
        if (adapter.isInstance(this.workingCopyDelegate)) {
            return this.workingCopyDelegate;
        }
        this.getDelegate(monitor);
        if (adapter.isInstance(this.delegate)) {
            return this.delegate;
        }
        this.getBehaviourDelegate(monitor);
        if (adapter.isInstance(this.behaviourDelegate)) {
            return this.behaviourDelegate;
        }
        return Platform.getAdapterManager().loadAdapter((Object)this, adapter.getName());
    }

    public void importConfiguration(IRuntime runtime2, IProgressMonitor monitor) {
        block2: {
            try {
                this.getWorkingCopyDelegate(monitor).importConfiguration(runtime2, monitor);
            }
            catch (Exception e) {
                if (!Trace.SEVERE) break block2;
                Trace.trace("/severe", "Error calling delegate importConfiguration() " + this.toString(), e);
            }
        }
    }

    public void importRuntimeConfiguration(IRuntime runtime2, IProgressMonitor monitor) throws CoreException {
        block4: {
            try {
                this.getWorkingCopyDelegate(monitor).importRuntimeConfiguration(runtime2, monitor);
            }
            catch (CoreException ce) {
                if (Trace.SEVERE) {
                    Trace.trace("/severe", "CoreException calling delegate importConfiguration() " + this.toString(), ce);
                }
                throw ce;
            }
            catch (Exception e) {
                if (!Trace.SEVERE) break block4;
                Trace.trace("/severe", "Error calling delegate importConfiguration() " + this.toString(), e);
            }
        }
    }

    @Override
    public void setExternalModules(IModule[] modules) {
        if (this.server != null) {
            this.server.setExternalModules(modules);
        }
        super.setExternalModules(modules);
    }

    @Override
    public List<IModule> getExternalModules() {
        if (this.server != null) {
            return this.server.getExternalModules();
        }
        return super.getExternalModules();
    }

    public void disassociate() {
        this.server = null;
        if (this.getAttribute("locked", false)) {
            this.setAttribute("locked", false);
        }
        if (this.getAttribute("id-set", false)) {
            this.setAttribute("id-set", false);
        }
    }

    protected void canModifyAttribute(String attributeName) {
        if (attributeName != null && "timestamp".equalsIgnoreCase(attributeName)) {
            throw new IllegalArgumentException("Unmodifiable attribute: " + attributeName);
        }
    }

    @Override
    public String toString() {
        return "ServerWorkingCopy " + this.getId();
    }
}

