/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.ui.spi.editor;

import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.MultiValuedMap;
import org.apache.commons.collections4.multimap.ArrayListValuedHashMap;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.mylyn.reviews.core.model.IComment;
import org.eclipse.mylyn.reviews.core.model.IFileItem;
import org.eclipse.mylyn.reviews.core.model.ILocation;
import org.eclipse.mylyn.reviews.core.model.IReviewItemSet;

final class ReviewSetContentProvider
implements ITreeContentProvider {
    private final MultiValuedMap<ILocation, IComment> threads = new ArrayListValuedHashMap();
    private final MultiValuedMap<String, ILocation> threadLocationsByFile = new ArrayListValuedHashMap();

    ReviewSetContentProvider() {
    }

    public Object[] getElements(Object inputElement) {
        return this.getReviewItems(inputElement).toArray();
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public void dispose() {
        this.threads.clear();
        this.threadLocationsByFile.clear();
    }

    public boolean hasChildren(Object element) {
        return !this.getFileComments(element).isEmpty() || element instanceof ILocation;
    }

    public Object getParent(Object element) {
        return null;
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof IFileItem) {
            IFileItem file = (IFileItem)parentElement;
            ArrayListValuedHashMap commentsByLocation = new ArrayListValuedHashMap();
            for (IComment comment : this.getFileComments(file)) {
                commentsByLocation.put((Object)((ILocation)comment.getLocations().iterator().next()).getIndex(), (Object)comment);
            }
            for (ILocation location : this.threadLocationsByFile.get((Object)file.getId())) {
                this.threads.remove((Object)location);
            }
            this.threadLocationsByFile.remove((Object)file.getId());
            for (Long line : commentsByLocation.keySet()) {
                ILocation location = null;
                for (IComment comment : commentsByLocation.get((Object)line)) {
                    if (location == null) {
                        location = (ILocation)comment.getLocations().iterator().next();
                        this.threadLocationsByFile.put((Object)file.getId(), (Object)location);
                    }
                    if (this.threads.containsValue((Object)comment)) continue;
                    this.threads.put((Object)location, (Object)comment);
                }
            }
            Collection relevantThreads = this.threadLocationsByFile.get((Object)file.getId());
            Object[] locations = relevantThreads.toArray(new ILocation[relevantThreads.size()]);
            Arrays.sort(locations, this.lineNumberComparator());
            return locations;
        }
        if (parentElement instanceof ILocation) {
            return this.threads.get((Object)((ILocation)parentElement)).toArray();
        }
        return new Object[0];
    }

    private Comparator<ILocation> lineNumberComparator() {
        return (o1, o2) -> (int)(o1.getIndex() - o2.getIndex());
    }

    private List<IFileItem> getReviewItems(Object inputElement) {
        if (inputElement instanceof IReviewItemSet) {
            return ((IReviewItemSet)inputElement).getItems();
        }
        return List.of();
    }

    private List<IComment> getFileComments(Object inputElement) {
        if (inputElement instanceof IFileItem) {
            return ((IFileItem)inputElement).getAllComments().stream().filter(input -> input.getLocations().iterator().hasNext()).collect(Collectors.toUnmodifiableList());
        }
        return List.of();
    }
}

