/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.fix;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BooleanLiteral;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.IfStatement;
import org.eclipse.jdt.core.dom.PatternInstanceofExpression;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.internal.corext.fix.CompilationUnitRewriteOperationsFixCore;
import org.eclipse.jdt.internal.corext.fix.LinkedProposalModelCore;
import org.eclipse.jdt.internal.corext.refactoring.nls.NLSElement;
import org.eclipse.jdt.internal.corext.refactoring.nls.NLSLine;
import org.eclipse.jdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.jdt.internal.ui.fix.AbstractMultiFix;
import org.eclipse.jdt.internal.ui.fix.CleanUpNLSUtils;
import org.eclipse.jdt.internal.ui.fix.MultiFixMessages;
import org.eclipse.jdt.ui.cleanup.CleanUpRequirements;
import org.eclipse.jdt.ui.cleanup.ICleanUpFix;
import org.eclipse.jdt.ui.text.java.IProblemLocation;
import org.eclipse.text.edits.TextEditGroup;

public class SimplifyBooleanIfElseCleanUpCore
extends AbstractMultiFix {
    public SimplifyBooleanIfElseCleanUpCore() {
        this(Collections.emptyMap());
    }

    public SimplifyBooleanIfElseCleanUpCore(Map<String, String> options) {
        super(options);
    }

    @Override
    public CleanUpRequirements getRequirements() {
        boolean requireAST = this.isEnabled("cleanup.simplify_boolean_if_else");
        return new CleanUpRequirements(requireAST, false, false, null);
    }

    @Override
    public String[] getStepDescriptions() {
        if (this.isEnabled("cleanup.simplify_boolean_if_else")) {
            return new String[]{MultiFixMessages.CodeStyleCleanUp_SimplifyBooleanIfElse_description};
        }
        return new String[0];
    }

    @Override
    public String getPreview() {
        StringBuilder bld = new StringBuilder();
        if (this.isEnabled("cleanup.simplify_boolean_if_else")) {
            bld.append("return i > 0;\n");
        } else {
            bld.append("if (i > 0) {\n");
            bld.append("    return true;\n");
            bld.append("} else {\n");
            bld.append("    return false;\n");
            bld.append("}\n");
        }
        return bld.toString();
    }

    @Override
    public boolean canFix(ICompilationUnit compilationUnit, IProblemLocation problem) {
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SimplifyStatus verifyBooleanIfElse(IfStatement ifStatement) {
        Object e;
        Block block;
        Statement elseStatement;
        if (ifStatement.getElseStatement() == null || ifStatement.getExpression() instanceof PatternInstanceofExpression) {
            return SimplifyStatus.INVALID;
        }
        boolean thenValue = true;
        Statement thenStatement = ifStatement.getThenStatement();
        if (thenStatement instanceof ReturnStatement) {
            ReturnStatement returnStatement = (ReturnStatement)thenStatement;
            Expression expression = returnStatement.getExpression();
            if (expression instanceof BooleanLiteral) {
                BooleanLiteral literal = (BooleanLiteral)expression;
                thenValue = literal.booleanValue();
            }
        } else {
            Object e2;
            Block block2;
            if (!(thenStatement instanceof Block) || (block2 = (Block)thenStatement).statements().size() != 1 || !((e2 = block2.statements().get(0)) instanceof ReturnStatement)) return SimplifyStatus.INVALID;
            ReturnStatement returnStatement = (ReturnStatement)e2;
            Expression expression = returnStatement.getExpression();
            if (!(expression instanceof BooleanLiteral)) return SimplifyStatus.INVALID;
            BooleanLiteral literal = (BooleanLiteral)expression;
            thenValue = literal.booleanValue();
        }
        if ((elseStatement = ifStatement.getElseStatement()) instanceof ReturnStatement) {
            BooleanLiteral literal;
            ReturnStatement returnStatement = (ReturnStatement)elseStatement;
            Expression expression = returnStatement.getExpression();
            if (!(expression instanceof BooleanLiteral) || (literal = (BooleanLiteral)expression).booleanValue() != thenValue) return thenValue ? SimplifyStatus.VALID_THEN_TRUE : SimplifyStatus.VALID_ELSE_TRUE;
            return SimplifyStatus.INVALID;
        }
        if (!(elseStatement instanceof Block) || (block = (Block)elseStatement).statements().size() != 1 || !((e = block.statements().get(0)) instanceof ReturnStatement)) return SimplifyStatus.INVALID;
        ReturnStatement returnStatement = (ReturnStatement)e;
        Expression expression = returnStatement.getExpression();
        if (!(expression instanceof BooleanLiteral)) return SimplifyStatus.INVALID;
        BooleanLiteral literal = (BooleanLiteral)expression;
        if (literal.booleanValue() != thenValue) return thenValue ? SimplifyStatus.VALID_THEN_TRUE : SimplifyStatus.VALID_ELSE_TRUE;
        return SimplifyStatus.INVALID;
    }

    @Override
    protected ICleanUpFix createFix(CompilationUnit unit) throws CoreException {
        if (!this.isEnabled("cleanup.simplify_boolean_if_else")) {
            return null;
        }
        final ArrayList rewriteOperations = new ArrayList();
        unit.accept(new ASTVisitor(){

            public boolean visit(IfStatement visited) {
                SimplifyStatus status = SimplifyBooleanIfElseCleanUpCore.verifyBooleanIfElse(visited);
                if (status != SimplifyStatus.INVALID) {
                    rewriteOperations.add(new SimplifyBooleanIfElseOperation(visited, status));
                }
                return true;
            }
        });
        if (rewriteOperations.isEmpty()) {
            return null;
        }
        return new CompilationUnitRewriteOperationsFixCore(MultiFixMessages.CodeStyleCleanUp_SimplifyBooleanIfElse_description, unit, rewriteOperations.toArray(new CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperationWithSourceRange[0]));
    }

    @Override
    protected ICleanUpFix createFix(CompilationUnit unit, IProblemLocation[] problems) throws CoreException {
        return null;
    }

    private static class SimplifyBooleanIfElseOperation
    extends CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperationWithSourceRange {
        private final IfStatement visited;
        private final SimplifyStatus status;

        public SimplifyBooleanIfElseOperation(IfStatement visited, SimplifyStatus status) {
            this.visited = visited;
            this.status = status;
        }

        @Override
        public void rewriteASTInternal(CompilationUnitRewrite cuRewrite, LinkedProposalModelCore linkedModel) throws CoreException {
            ASTRewrite rewrite = cuRewrite.getASTRewrite();
            TextEditGroup group = this.createTextEditGroup(MultiFixMessages.CodeStyleCleanUp_SimplifyBooleanIfElse_description, cuRewrite);
            CompilationUnit cu = (CompilationUnit)this.visited.getRoot();
            ICompilationUnit icu = (ICompilationUnit)cu.getJavaElement();
            NLSLine nlsLine = CleanUpNLSUtils.scanCurrentLine(icu, (ASTNode)this.visited.getExpression());
            StringBuilder nlsBuffer = new StringBuilder();
            if (nlsLine != null) {
                NLSElement[] nlsElements = nlsLine.getElements();
                int i = 0;
                while (i < nlsElements.length) {
                    NLSElement element = nlsElements[i];
                    if (element.hasTag()) {
                        nlsBuffer.append(" //$NON-NLS-" + (i + 1) + "$");
                    }
                    ++i;
                }
            }
            ReturnStatement newReturn = null;
            String ifExpression = icu.getBuffer().getText(this.visited.getExpression().getStartPosition(), this.visited.getExpression().getLength());
            newReturn = this.status == SimplifyStatus.VALID_THEN_TRUE ? (ReturnStatement)rewrite.createStringPlaceholder("return " + ifExpression + ";" + nlsBuffer.toString(), 41) : (ReturnStatement)rewrite.createStringPlaceholder("return !(" + ifExpression + ");" + nlsBuffer.toString(), 41);
            rewrite.replace((ASTNode)this.visited, (ASTNode)newReturn, group);
        }
    }

    public static enum SimplifyStatus {
        INVALID,
        VALID_THEN_TRUE,
        VALID_ELSE_TRUE;

    }
}

