/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.correction.proposals;

import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.NodeFinder;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.manipulation.CUCorrectionProposalCore;
import org.eclipse.jdt.core.manipulation.SharedASTProviderCore;
import org.eclipse.jdt.internal.core.manipulation.JavaManipulationPlugin;
import org.eclipse.jdt.internal.corext.dom.LinkedNodeFinder;
import org.eclipse.jdt.internal.ui.text.correction.CorrectionMessages;
import org.eclipse.jdt.ui.text.java.IInvocationContext;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.jface.text.link.LinkedPosition;
import org.eclipse.jface.text.link.LinkedPositionGroup;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

public class LinkedNamesAssistProposalCore
extends CUCorrectionProposalCore {
    public static final String ASSIST_ID = "org.eclipse.jdt.ui.correction.renameInFile.assist";
    private SimpleName fNode;
    private IInvocationContext fContext;
    private String fLabel;
    private String fValueSuggestion;

    public LinkedNamesAssistProposalCore(IInvocationContext context, SimpleName node) {
        this(CorrectionMessages.LinkedNamesAssistProposal_description, context, node, null);
    }

    public LinkedNamesAssistProposalCore(String label, IInvocationContext context, SimpleName node, String valueSuggestion) {
        super(label, context.getCompilationUnit(), 8);
        this.fLabel = label;
        this.fNode = node;
        this.fContext = context;
        this.fValueSuggestion = valueSuggestion;
    }

    public String getLabel() {
        return this.fLabel;
    }

    public SimpleName getNode() {
        return this.fNode;
    }

    public IInvocationContext getContext() {
        return this.fContext;
    }

    public String getValueSuggestion() {
        return this.fValueSuggestion;
    }

    @Override
    public void addEdits(IDocument document, TextEdit rootEdit) throws CoreException {
        try {
            CompilationUnit root = SharedASTProviderCore.getAST((ITypeRoot)this.fContext.getCompilationUnit(), SharedASTProviderCore.WAIT_YES, null);
            ASTNode nameNode = NodeFinder.perform((ASTNode)root, (int)this.fNode.getStartPosition(), (int)this.fNode.getLength());
            final int pos = this.fNode.getStartPosition();
            Object[] sameNodes = nameNode instanceof SimpleName ? LinkedNodeFinder.findByNode((ASTNode)root, (SimpleName)nameNode) : new ASTNode[]{nameNode};
            Arrays.sort(sameNodes, new Comparator<ASTNode>(){

                @Override
                public int compare(ASTNode o1, ASTNode o2) {
                    return this.rank(o1) - this.rank(o2);
                }

                private int rank(ASTNode node) {
                    int relativeRank = node.getStartPosition() + node.getLength() - pos;
                    if (relativeRank < 0) {
                        return Integer.MAX_VALUE + relativeRank;
                    }
                    return relativeRank;
                }
            });
            LinkedPositionGroup group = new LinkedPositionGroup();
            int i = 0;
            while (i < sameNodes.length) {
                SimpleName elem = sameNodes[i];
                group.addPosition(new LinkedPosition(document, elem.getStartPosition(), elem.getLength(), i));
                ++i;
            }
            LinkedModeModel model = new LinkedModeModel();
            model.addGroup(group);
            model.forceInstall();
            if (this.fValueSuggestion != null) {
                ReplaceEdit edit = new ReplaceEdit(nameNode.getStartPosition(), nameNode.getLength(), this.fValueSuggestion);
                SimpleName[] simpleNameArray = sameNodes;
                int n = sameNodes.length;
                int n2 = 0;
                while (n2 < n) {
                    SimpleName sameNode = simpleNameArray[n2];
                    edit = new ReplaceEdit(sameNode.getStartPosition(), sameNode.getLength(), this.fValueSuggestion);
                    rootEdit.addChild((TextEdit)edit);
                    ++n2;
                }
            }
        }
        catch (BadLocationException e) {
            JavaManipulationPlugin.log(e);
        }
    }

    @Override
    public String getCommandId() {
        return ASSIST_ID;
    }
}

