/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.contentmodel.settings;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.lemminx.extensions.contentmodel.settings.SchemaEnabled;
import org.eclipse.lemminx.extensions.contentmodel.settings.XMLSchemaSettings;
import org.eclipse.lemminx.extensions.contentmodel.settings.XMLValidationFilter;
import org.eclipse.lemminx.extensions.contentmodel.settings.XMLValidationSettings;

public class XMLValidationRootSettings
extends XMLValidationSettings {
    private static final XMLValidationFilter[] DEFAULT_FILTERS = XMLValidationRootSettings.createDefaultFilters();
    private XMLValidationFilter[] filters;

    public XMLValidationRootSettings() {
        this.setFilters(DEFAULT_FILTERS);
    }

    public XMLValidationFilter[] getFilters() {
        return this.filters;
    }

    public void setFilters(XMLValidationFilter[] filters) {
        this.filters = filters;
    }

    public XMLValidationSettings getValidationSettings(String uri) {
        if (this.filters != null) {
            for (XMLValidationFilter filter : this.filters) {
                if (!filter.matches(uri)) continue;
                return filter;
            }
        }
        return this;
    }

    public XMLValidationRootSettings merge(XMLValidationRootSettings settings) {
        if (settings != null) {
            this.filters = settings.getFilters();
        }
        super.merge(settings);
        return this;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Arrays.hashCode(this.filters);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        XMLValidationRootSettings other = (XMLValidationRootSettings)obj;
        return Arrays.equals(this.filters, other.filters);
    }

    private static XMLValidationFilter[] createDefaultFilters() {
        ArrayList<XMLValidationFilter> filters = new ArrayList<XMLValidationFilter>();
        XMLValidationFilter filter = new XMLValidationFilter();
        filter.setNoGrammar("ignore");
        XMLSchemaSettings schema = new XMLSchemaSettings();
        schema.setEnabled(SchemaEnabled.never);
        filter.setSchema(schema);
        filter.setPattern("**.exsd");
        filters.add(filter);
        filter = new XMLValidationFilter();
        filter.setNoGrammar("ignore");
        filter.setPattern("**{.project,.classpath,plugin.xml,feature.xml,category.xml,.target,.product}");
        filters.add(filter);
        return filters.toArray(new XMLValidationFilter[filters.size()]);
    }
}

