/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.internal.launch;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.m2e.internal.launch.IMavenLaunchParticipant;

public class MavenLaunchParticipantInfo {
    private final IConfigurationElement extension;

    private MavenLaunchParticipantInfo(IConfigurationElement extension) {
        this.extension = extension;
    }

    public String getId() {
        return this.extension.getAttribute("id");
    }

    public String getName() {
        return this.extension.getAttribute("name");
    }

    public IMavenLaunchParticipant createParticipant() throws CoreException {
        return (IMavenLaunchParticipant)this.extension.createExecutableExtension("class");
    }

    public List<String> getModes() {
        String modes = this.extension.getAttribute("modes");
        if (modes == null) {
            return Collections.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(modes, ",");
        while (st.hasMoreTokens()) {
            result.add(st.nextToken().trim());
        }
        return result;
    }

    public static List<MavenLaunchParticipantInfo> readParticipantsInfo() {
        ArrayList<MavenLaunchParticipantInfo> result = new ArrayList<MavenLaunchParticipantInfo>();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint("org.eclipse.m2e.launching.mavenLaunchParticipants");
        if (extensionPoint != null) {
            IExtension[] iExtensionArray = extensionPoint.getExtensions();
            int n = iExtensionArray.length;
            int n2 = 0;
            while (n2 < n) {
                IExtension extension = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
                int n3 = iConfigurationElementArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement element = iConfigurationElementArray[n4];
                    result.add(new MavenLaunchParticipantInfo(element));
                    ++n4;
                }
                ++n2;
            }
        }
        return result;
    }
}

