/*
 * Decompiled with CFR 0.152.
 */
package jdk.test.lib.security;

import java.io.ByteArrayOutputStream;
import java.security.SecureRandom;

public class FixedSecureRandom
extends SecureRandom {
    private static final long serialVersionUID = -8753752741562231543L;
    private byte[] buffer;
    private int offset;

    public FixedSecureRandom(byte[] ... data) {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        for (byte[] b : data) {
            os.writeBytes(b);
        }
        this.buffer = os.toByteArray();
        this.offset = 0;
    }

    @Override
    public void nextBytes(byte[] bytes) {
        if (bytes.length > this.buffer.length - this.offset) {
            throw new IllegalStateException("Not enough bytes");
        }
        System.arraycopy(this.buffer, this.offset, bytes, 0, bytes.length);
        this.offset += bytes.length;
    }

    public boolean hasRemaining() {
        return this.offset != this.buffer.length;
    }
}

