/*
 * Decompiled with CFR 0.152.
 */
package jdk.test.lib.thread;

import java.util.concurrent.ThreadFactory;

public class TestThreadFactory {
    private static ThreadFactory threadFactory = "Virtual".equals(System.getProperty("test.thread.factory")) ? TestThreadFactory.virtualThreadFactory() : TestThreadFactory.platformThreadFactory();

    public static Thread newThread(Runnable task) {
        return threadFactory.newThread(task);
    }

    public static Thread newThread(Runnable task, String name) {
        Thread t = threadFactory.newThread(task);
        t.setName(name);
        return t;
    }

    private static ThreadFactory platformThreadFactory() {
        return Thread.ofPlatform().factory();
    }

    private static ThreadFactory virtualThreadFactory() {
        return Thread.ofVirtual().factory();
    }
}

