/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.dom;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTMatcher;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.ChildPropertyDescriptor;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimplePropertyDescriptor;

public class PrefixExpression
extends Expression {
    public static final SimplePropertyDescriptor OPERATOR_PROPERTY = new SimplePropertyDescriptor(PrefixExpression.class, "operator", Operator.class, true);
    public static final ChildPropertyDescriptor OPERAND_PROPERTY = new ChildPropertyDescriptor(PrefixExpression.class, "operand", Expression.class, true, true);
    private static final List PROPERTY_DESCRIPTORS;
    private Operator operator = Operator.PLUS;
    private Expression operand = null;

    static {
        ArrayList propertyList = new ArrayList(3);
        PrefixExpression.createPropertyList(PrefixExpression.class, propertyList);
        PrefixExpression.addProperty(OPERATOR_PROPERTY, propertyList);
        PrefixExpression.addProperty(OPERAND_PROPERTY, propertyList);
        PROPERTY_DESCRIPTORS = PrefixExpression.reapPropertyList(propertyList);
    }

    public static List propertyDescriptors(int apiLevel) {
        return PROPERTY_DESCRIPTORS;
    }

    PrefixExpression(AST ast) {
        super(ast);
    }

    @Override
    final List internalStructuralPropertiesForType(int apiLevel) {
        return PrefixExpression.propertyDescriptors(apiLevel);
    }

    @Override
    final Object internalGetSetObjectProperty(SimplePropertyDescriptor property, boolean get, Object value) {
        if (property == OPERATOR_PROPERTY) {
            if (get) {
                return this.getOperator();
            }
            this.setOperator((Operator)value);
            return null;
        }
        return super.internalGetSetObjectProperty(property, get, value);
    }

    @Override
    final ASTNode internalGetSetChildProperty(ChildPropertyDescriptor property, boolean get, ASTNode child) {
        if (property == OPERAND_PROPERTY) {
            if (get) {
                return this.getOperand();
            }
            this.setOperand((Expression)child);
            return null;
        }
        return super.internalGetSetChildProperty(property, get, child);
    }

    @Override
    final int getNodeType0() {
        return 38;
    }

    @Override
    ASTNode clone0(AST target) {
        PrefixExpression result = new PrefixExpression(target);
        result.setSourceRange(this.getStartPosition(), this.getLength());
        result.setOperator(this.getOperator());
        result.setOperand((Expression)this.getOperand().clone(target));
        return result;
    }

    @Override
    final boolean subtreeMatch0(ASTMatcher matcher, Object other) {
        return matcher.match(this, other);
    }

    @Override
    void accept0(ASTVisitor visitor) {
        boolean visitChildren = visitor.visit(this);
        if (visitChildren) {
            this.acceptChild(visitor, this.getOperand());
        }
        visitor.endVisit(this);
    }

    public Operator getOperator() {
        return this.operator;
    }

    public void setOperator(Operator operator) {
        if (operator == null) {
            throw new IllegalArgumentException();
        }
        this.preValueChange(OPERATOR_PROPERTY);
        this.operator = operator;
        this.postValueChange(OPERATOR_PROPERTY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Expression getOperand() {
        if (this.operand == null) {
            PrefixExpression prefixExpression = this;
            synchronized (prefixExpression) {
                if (this.operand == null) {
                    this.preLazyInit();
                    this.operand = new SimpleName(this.ast);
                    this.postLazyInit(this.operand, OPERAND_PROPERTY);
                }
            }
        }
        return this.operand;
    }

    public void setOperand(Expression expression) {
        if (expression == null) {
            throw new IllegalArgumentException();
        }
        Expression oldChild = this.operand;
        this.preReplaceChild(oldChild, expression, OPERAND_PROPERTY);
        this.operand = expression;
        this.postReplaceChild(oldChild, expression, OPERAND_PROPERTY);
    }

    @Override
    int memSize() {
        return 48;
    }

    @Override
    int treeSize() {
        return this.memSize() + (this.operand == null ? 0 : this.getOperand().treeSize());
    }

    public static class Operator {
        private final String token;
        public static final Operator INCREMENT;
        public static final Operator DECREMENT;
        public static final Operator PLUS;
        public static final Operator MINUS;
        public static final Operator COMPLEMENT;
        public static final Operator NOT;
        private static final Map CODES;

        static {
            Operator[] ops;
            INCREMENT = new Operator("++");
            DECREMENT = new Operator("--");
            PLUS = new Operator("+");
            MINUS = new Operator("-");
            COMPLEMENT = new Operator("~");
            NOT = new Operator("!");
            CODES = new HashMap(20);
            Operator[] operatorArray = ops = new Operator[]{INCREMENT, DECREMENT, PLUS, MINUS, COMPLEMENT, NOT};
            int n = ops.length;
            int n2 = 0;
            while (n2 < n) {
                Operator op = operatorArray[n2];
                CODES.put(op.toString(), op);
                ++n2;
            }
        }

        private Operator(String token) {
            this.token = token;
        }

        public String toString() {
            return this.token;
        }

        public static Operator toOperator(String token) {
            return (Operator)CODES.get(token);
        }
    }
}

