/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.test.plugin.handler;

import com.microsoft.java.test.plugin.launchers.JUnitLaunchUtils;
import com.microsoft.java.test.plugin.util.ProjectTestUtils;
import com.microsoft.java.test.plugin.util.TestGenerationUtils;
import com.microsoft.java.test.plugin.util.TestNavigationUtils;
import com.microsoft.java.test.plugin.util.TestSearchUtils;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.ls.core.internal.IDelegateCommandHandler;

public class TestDelegateCommandHandler
implements IDelegateCommandHandler {
    private static final String GET_TEST_SOURCE_PATH = "vscode.java.test.get.testpath";
    private static final String RESOLVE_JUNIT_ARGUMENT = "vscode.java.test.junit.argument";
    private static final String GENERATE_TESTS = "vscode.java.test.generateTests";
    private static final String FIND_JAVA_PROJECT = "vscode.java.test.findJavaProjects";
    private static final String FIND_PACKAGES_AND_TYPES = "vscode.java.test.findTestPackagesAndTypes";
    private static final String FIND_DIRECT_CHILDREN_FOR_CLASS = "vscode.java.test.findDirectTestChildrenForClass";
    private static final String FIND_TYPES_AND_METHODS = "vscode.java.test.findTestTypesAndMethods";
    private static final String RESOLVE_PATH = "vscode.java.test.resolvePath";
    private static final String FIND_TEST_LOCATION = "vscode.java.test.findTestLocation";
    private static final String NAVIGATE_TO_TEST_OR_TARGET = "vscode.java.test.navigateToTestOrTarget";

    public Object executeCommand(String commandId, List<Object> arguments, IProgressMonitor monitor) throws Exception {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        switch (commandId) {
            case "vscode.java.test.get.testpath": {
                return ProjectTestUtils.listTestSourcePaths(arguments, monitor);
            }
            case "vscode.java.test.junit.argument": {
                return JUnitLaunchUtils.resolveLaunchArgument(arguments, monitor);
            }
            case "vscode.java.test.generateTests": {
                return TestGenerationUtils.generateTests(arguments, monitor);
            }
            case "vscode.java.test.findJavaProjects": {
                return TestSearchUtils.findJavaProjects(arguments, monitor);
            }
            case "vscode.java.test.findTestPackagesAndTypes": {
                return TestSearchUtils.findTestPackagesAndTypes(arguments, monitor);
            }
            case "vscode.java.test.findDirectTestChildrenForClass": {
                return TestSearchUtils.findDirectTestChildrenForClass(arguments, monitor);
            }
            case "vscode.java.test.findTestTypesAndMethods": {
                return TestSearchUtils.findTestTypesAndMethods(arguments, monitor);
            }
            case "vscode.java.test.resolvePath": {
                return TestSearchUtils.resolvePath(arguments, monitor);
            }
            case "vscode.java.test.findTestLocation": {
                return TestSearchUtils.findTestLocation(arguments, monitor);
            }
            case "vscode.java.test.navigateToTestOrTarget": {
                return TestNavigationUtils.findTestOrTarget(arguments, monitor);
            }
        }
        throw new UnsupportedOperationException(String.format("Java test plugin doesn't support the command '%s'.", commandId));
    }
}

