/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.test.plugin.launchers;

import com.google.gson.Gson;
import com.microsoft.java.test.plugin.launchers.JUnitLaunchArguments;
import com.microsoft.java.test.plugin.launchers.JUnitLaunchConfiguration;
import com.microsoft.java.test.plugin.launchers.JUnitLaunchConfigurationDelegate;
import com.microsoft.java.test.plugin.launchers.TestInfo;
import com.microsoft.java.test.plugin.model.Response;
import com.microsoft.java.test.plugin.model.TestKind;
import com.microsoft.java.test.plugin.model.TestLevel;
import com.microsoft.java.test.plugin.util.JUnitPlugin;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.ArrayUtils;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.ls.core.internal.ProjectUtils;

public class JUnitLaunchUtils {
    private static final String TESTNG_LOADER = "com.microsoft.java.test.loader.testng";
    private static final String JUNIT5_LOADER = "org.eclipse.jdt.junit.loader.junit5";
    private static final String JUNIT4_LOADER = "org.eclipse.jdt.junit.loader.junit4";

    private JUnitLaunchUtils() {
    }

    public static Response<JUnitLaunchArguments> resolveLaunchArgument(List<Object> arguments, IProgressMonitor monitor) throws URISyntaxException, CoreException {
        IPath realLocation;
        Gson gson = new Gson();
        Argument args = (Argument)gson.fromJson((String)arguments.get(0), Argument.class);
        TestInfo info = new TestInfo();
        info.testKind = JUnitLaunchUtils.getEclipseTestKind(args.testKind);
        IJavaProject javaProject = ProjectUtils.getJavaProject((String)args.projectName);
        if (javaProject == null || !javaProject.exists()) {
            JUnitPlugin.logError("Failed to get the project: " + args.projectName);
            throw new RuntimeException("Failed to get the project: " + args.projectName);
        }
        info.project = javaProject.getProject();
        if (!Objects.equals(info.testKind, TESTNG_LOADER) && ArrayUtils.isNotEmpty((Object[])args.testNames)) {
            if (args.testLevel == TestLevel.CLASS) {
                info.mainType = args.testNames[0].substring(args.testNames[0].indexOf("@") + 1);
            } else if (args.testLevel == TestLevel.METHOD) {
                IMethod method = (IMethod)JavaCore.create((String)args.testNames[0]);
                info.mainType = method.getDeclaringType().getFullyQualifiedName();
            }
        }
        JUnitLaunchConfiguration configuration = new JUnitLaunchConfiguration("JUnit Launch Configuration", info);
        JUnitLaunchConfigurationDelegate delegate = new JUnitLaunchConfigurationDelegate(args);
        if (monitor.isCanceled()) {
            return null;
        }
        Response<JUnitLaunchArguments> result = TESTNG_LOADER.equals(info.testKind) ? JUnitLaunchUtils.resolveTestNGLaunchArguments((ILaunchConfiguration)configuration, javaProject, delegate) : delegate.getJUnitLaunchArguments((ILaunchConfiguration)configuration, "run", monitor);
        if (result != null && result.getStatus() == 0 && ProjectUtils.isUnmanagedFolder((IProject)javaProject.getProject()) && (realLocation = ProjectUtils.getProjectRealFolder((IProject)javaProject.getProject())) != null) {
            result.getBody().workingDirectory = realLocation.toOSString();
        }
        return result;
    }

    public static void addOverrideDependencies(List<String> vmArgs, String dependencies) {
        if (dependencies != null && dependencies.length() > 0) {
            String[] parseArguments = DebugPlugin.parseArguments((String)dependencies);
            vmArgs.addAll(Arrays.asList(parseArguments));
        }
    }

    private static Response<JUnitLaunchArguments> resolveTestNGLaunchArguments(ILaunchConfiguration configuration, IJavaProject javaProject, JUnitLaunchConfigurationDelegate delegate) throws CoreException {
        String id;
        IRuntimeClasspathEntry[] unresolved = JavaRuntime.computeUnresolvedRuntimeClasspath((ILaunchConfiguration)configuration);
        IRuntimeClasspathEntry[] resolved = JavaRuntime.resolveRuntimeClasspath((IRuntimeClasspathEntry[])unresolved, (ILaunchConfiguration)configuration);
        LinkedHashSet<String> classpaths = new LinkedHashSet<String>();
        LinkedHashSet<String> modulepaths = new LinkedHashSet<String>();
        IRuntimeClasspathEntry[] iRuntimeClasspathEntryArray = resolved;
        int n = resolved.length;
        int n2 = 0;
        while (n2 < n) {
            IRuntimeClasspathEntry entry = iRuntimeClasspathEntryArray[n2];
            String location = entry.getLocation();
            if (location != null) {
                if (entry.getClasspathProperty() == 3 || entry.getClasspathProperty() == 5) {
                    classpaths.add(location);
                } else if (entry.getClasspathProperty() == 4) {
                    modulepaths.add(location);
                }
            }
            ++n2;
        }
        JUnitLaunchArguments launchArguments = new JUnitLaunchArguments();
        launchArguments.projectName = javaProject.getProject().getName();
        launchArguments.classpath = classpaths.toArray(new String[classpaths.size()]);
        launchArguments.modulepath = modulepaths.toArray(new String[modulepaths.size()]);
        IPath projectLocation = javaProject.getProject().getLocation();
        if (projectLocation != null) {
            launchArguments.workingDirectory = projectLocation.toFile().getAbsolutePath();
        }
        ArrayList<String> vmArgs = new ArrayList<String>();
        vmArgs.add("-ea");
        if (JavaRuntime.isModularProject((IJavaProject)javaProject)) {
            for (String pkg : JUnitLaunchUtils.getSourcePackages(javaProject)) {
                JUnitLaunchUtils.collectAddOpensVmArgs(vmArgs, pkg, javaProject);
            }
            vmArgs.add("--add-modules=ALL-MODULE-PATH");
        }
        if ("enabled".equals(id = javaProject.getOption("org.eclipse.jdt.core.compiler.problem.enablePreviewFeatures", true))) {
            vmArgs.add("--enable-preview");
        }
        JUnitLaunchUtils.addOverrideDependencies(vmArgs, delegate.getModuleCLIOptions(configuration));
        launchArguments.vmArguments = vmArgs.toArray(new String[vmArgs.size()]);
        return new Response<JUnitLaunchArguments>(launchArguments, null);
    }

    private static void collectAddOpensVmArgs(List<String> addOpensVmArgs, String pkgName, IJavaProject javaProject) throws CoreException {
        String sourceModuleName = javaProject.getModuleDescription().getElementName();
        addOpensVmArgs.add("--add-opens");
        addOpensVmArgs.add(String.valueOf(sourceModuleName) + "/" + pkgName + "=ALL-UNNAMED");
    }

    private static Set<String> getSourcePackages(IJavaProject javaProject) throws JavaModelException {
        HashSet<String> pkgs = new HashSet<String>();
        IPackageFragmentRoot[] iPackageFragmentRootArray = javaProject.getPackageFragmentRoots();
        int n = iPackageFragmentRootArray.length;
        int n2 = 0;
        while (n2 < n) {
            IPackageFragmentRoot pkgFragmentRoot = iPackageFragmentRootArray[n2];
            if (!pkgFragmentRoot.isArchive()) {
                IJavaElement[] iJavaElementArray = pkgFragmentRoot.getChildren();
                int n3 = iJavaElementArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IJavaElement pkg = iJavaElementArray[n4];
                    if (!pkg.getElementName().isEmpty() && !(pkg instanceof IFolder) && ((IPackageFragment)pkg).containsJavaResources()) {
                        pkgs.add(((IPackageFragment)pkg).getElementName());
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        return pkgs;
    }

    private static String getEclipseTestKind(TestKind testKind) {
        switch (testKind) {
            case JUnit: {
                return JUNIT4_LOADER;
            }
            case JUnit5: {
                return JUNIT5_LOADER;
            }
            case TestNG: {
                return TESTNG_LOADER;
            }
        }
        throw new IllegalArgumentException("The test kind: " + testKind.name() + " is not supported yet.");
    }

    class Argument {
        public String projectName;
        public TestLevel testLevel;
        public TestKind testKind;
        public String[] testNames;
        public String uniqueId;

        Argument() {
        }
    }
}

