/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.handlers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IOpenable;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.NodeFinder;
import org.eclipse.jdt.core.manipulation.CoreASTProvider;
import org.eclipse.jdt.internal.core.manipulation.search.BreakContinueTargetFinder;
import org.eclipse.jdt.internal.core.manipulation.search.ExceptionOccurrencesFinder;
import org.eclipse.jdt.internal.core.manipulation.search.IOccurrencesFinder;
import org.eclipse.jdt.internal.core.manipulation.search.ImplementOccurrencesFinder;
import org.eclipse.jdt.internal.core.manipulation.search.MethodExitsFinder;
import org.eclipse.jdt.internal.core.manipulation.search.OccurrencesFinder;
import org.eclipse.jdt.ls.core.internal.JDTUtils;
import org.eclipse.jdt.ls.core.internal.handlers.JsonRpcHelpers;
import org.eclipse.lsp4j.DocumentHighlight;
import org.eclipse.lsp4j.DocumentHighlightKind;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextDocumentPositionParams;

public class DocumentHighlightHandler {
    public static List<DocumentHighlight> documentHighlight(TextDocumentPositionParams params, IProgressMonitor monitor) {
        ITypeRoot typeRoot = JDTUtils.resolveTypeRoot(params.getTextDocument().getUri());
        if (typeRoot == null || monitor.isCanceled()) {
            return Collections.emptyList();
        }
        CompilationUnit ast = CoreASTProvider.getInstance().getAST(typeRoot, CoreASTProvider.WAIT_YES, monitor);
        if (ast == null || monitor.isCanceled()) {
            return Collections.emptyList();
        }
        int offset = JsonRpcHelpers.toOffset((IOpenable)typeRoot, params.getPosition().getLine(), params.getPosition().getCharacter());
        ASTNode node = NodeFinder.perform((ASTNode)ast, (int)offset, (int)0);
        if (monitor.isCanceled()) {
            return Collections.emptyList();
        }
        return DocumentHighlightHandler.findHighlights(ast, node, monitor);
    }

    private static List<DocumentHighlight> findHighlights(CompilationUnit ast, ASTNode node, IProgressMonitor monitor) {
        ExceptionOccurrencesFinder finder = new ExceptionOccurrencesFinder();
        if (finder.initialize(ast, node) == null) {
            return DocumentHighlightHandler.convertToHighlights(ast, finder.getOccurrences());
        }
        if (monitor.isCanceled()) {
            return Collections.emptyList();
        }
        finder = new MethodExitsFinder();
        if (finder.initialize(ast, node) == null) {
            return DocumentHighlightHandler.convertToHighlights(ast, finder.getOccurrences());
        }
        if (monitor.isCanceled()) {
            return Collections.emptyList();
        }
        finder = new BreakContinueTargetFinder();
        if (finder.initialize(ast, node) == null) {
            return DocumentHighlightHandler.convertToHighlights(ast, finder.getOccurrences());
        }
        if (monitor.isCanceled()) {
            return Collections.emptyList();
        }
        finder = new ImplementOccurrencesFinder();
        if (finder.initialize(ast, node) == null) {
            return DocumentHighlightHandler.convertToHighlights(ast, finder.getOccurrences());
        }
        if (monitor.isCanceled()) {
            return Collections.emptyList();
        }
        finder = new OccurrencesFinder();
        if (finder.initialize(ast, node) == null) {
            return DocumentHighlightHandler.convertToHighlights(ast, finder.getOccurrences());
        }
        return Collections.emptyList();
    }

    private static List<DocumentHighlight> convertToHighlights(CompilationUnit ast, IOccurrencesFinder.OccurrenceLocation[] locations) {
        if (locations == null || locations.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<DocumentHighlight> highlights = new ArrayList<DocumentHighlight>(locations.length);
        IOccurrencesFinder.OccurrenceLocation[] occurrenceLocationArray = locations;
        int n = locations.length;
        int n2 = 0;
        while (n2 < n) {
            IOccurrencesFinder.OccurrenceLocation loc = occurrenceLocationArray[n2];
            highlights.add(DocumentHighlightHandler.convertToHighlight(ast, loc));
            ++n2;
        }
        return highlights;
    }

    private static DocumentHighlight convertToHighlight(CompilationUnit ast, IOccurrencesFinder.OccurrenceLocation occurrence) {
        DocumentHighlight highlight = new DocumentHighlight();
        if ((occurrence.getFlags() & 1) != 0) {
            highlight.setKind(DocumentHighlightKind.Write);
        } else {
            highlight.setKind(DocumentHighlightKind.Read);
        }
        int[] startPos = JsonRpcHelpers.toLine((IOpenable)ast.getTypeRoot(), occurrence.getOffset());
        int[] endPos = JsonRpcHelpers.toLine((IOpenable)ast.getTypeRoot(), occurrence.getOffset() + occurrence.getLength());
        highlight.setRange(new Range(new Position(startPos[0], startPos[1]), new Position(endPos[0], endPos[1])));
        return highlight;
    }
}

