/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.filesystem.local;

import java.nio.file.FileSystems;
import java.util.Set;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.provider.FileInfo;
import org.eclipse.core.internal.filesystem.local.LocalFileHandler;
import org.eclipse.core.internal.filesystem.local.LocalFileNatives;
import org.eclipse.core.internal.filesystem.local.NativeHandler;
import org.eclipse.core.internal.filesystem.local.nio.DefaultHandler;
import org.eclipse.core.internal.filesystem.local.nio.DosHandler;
import org.eclipse.core.internal.filesystem.local.nio.PosixHandler;
import org.eclipse.core.internal.filesystem.local.unix.UnixFileHandler;
import org.eclipse.core.internal.filesystem.local.unix.UnixFileNatives;
import org.eclipse.core.runtime.Platform;

public class LocalFileNativesManager {
    public static final boolean PROPERTY_USE_NATIVE_DEFAULT = true;
    public static final String PROPERTY_USE_NATIVES = "eclipse.filesystem.useNatives";
    private static NativeHandler HANDLER;

    static {
        LocalFileNativesManager.reset();
    }

    public static void reset() {
        LocalFileNativesManager.setUsingNative(Boolean.parseBoolean(System.getProperty(PROPERTY_USE_NATIVES, String.valueOf(true))));
    }

    public static boolean setUsingNative(boolean useNatives) {
        boolean nativesAreUsed;
        boolean isWindowsOS = Platform.OS.isWindows();
        if (useNatives && !isWindowsOS && UnixFileNatives.isUsingNatives()) {
            HANDLER = new UnixFileHandler();
            nativesAreUsed = true;
        } else if (useNatives && isWindowsOS && LocalFileNatives.isUsingNatives()) {
            HANDLER = new LocalFileHandler();
            nativesAreUsed = true;
        } else {
            nativesAreUsed = false;
            Set<String> views = FileSystems.getDefault().supportedFileAttributeViews();
            HANDLER = views.contains("posix") ? new PosixHandler() : (views.contains("dos") ? new DosHandler() : new DefaultHandler());
        }
        return nativesAreUsed;
    }

    public static int getSupportedAttributes() {
        return HANDLER.getSupportedAttributes();
    }

    public static FileInfo fetchFileInfo(String fileName) {
        return HANDLER.fetchFileInfo(fileName);
    }

    public static boolean putFileInfo(String fileName, IFileInfo info, int options) {
        return HANDLER.putFileInfo(fileName, info, options);
    }
}

