/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.corext.template.java;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.eclipse.jdt.core.CompletionContext;
import org.eclipse.jdt.core.CompletionProposal;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IOpenable;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.internal.core.manipulation.util.Strings;
import org.eclipse.jdt.internal.corext.template.java.CompilationUnitContext;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.ls.core.internal.CompletionUtils;
import org.eclipse.jdt.ls.core.internal.JDTUtils;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.TextEditConverter;
import org.eclipse.jdt.ls.core.internal.contentassist.SnippetUtils;
import org.eclipse.jdt.ls.core.internal.contentassist.SortTextHelper;
import org.eclipse.jdt.ls.core.internal.corext.template.java.JavaPostfixContext;
import org.eclipse.jdt.ls.core.internal.corext.template.java.JavaPostfixContextType;
import org.eclipse.jdt.ls.core.internal.corext.template.java.PostfixCompletionProposal;
import org.eclipse.jdt.ls.core.internal.handlers.CompletionResponse;
import org.eclipse.jdt.ls.core.internal.handlers.CompletionResponses;
import org.eclipse.jdt.ls.core.internal.preferences.ClientPreferences;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateBuffer;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.CompletionItemDefaults;
import org.eclipse.lsp4j.CompletionItemKind;
import org.eclipse.lsp4j.CompletionItemLabelDetails;
import org.eclipse.lsp4j.Range;
import org.eclipse.text.edits.TextEdit;

public class PostfixTemplateEngine {
    private static String Switch_Name = "switch";
    private static String Switch_Default = "switch case statement";
    private static String NEW_RECORD_TEMPLATE_NAME = "new_record";
    private ASTNode currentNode;
    private ASTNode parentNode;
    private CompletionContext completionCtx;

    public void setASTNodes(ASTNode currentNode, ASTNode parentNode) {
        this.currentNode = currentNode;
        this.parentNode = parentNode;
    }

    public void setContext(CompletionContext context) {
        this.completionCtx = context;
    }

    public List<CompletionItem> complete(IDocument document, int offset, ICompilationUnit compilationUnit, CompletionItemDefaults completionItemDefaults) {
        ArrayList<CompletionItem> res = new ArrayList<CompletionItem>();
        JavaPostfixContextType type = (JavaPostfixContextType)JavaLanguageServerPlugin.getInstance().getTemplateContextRegistry().getContextType("postfix");
        JavaPostfixContext context = type.createContext(document, offset, 0, compilationUnit, this.currentNode, this.parentNode, this.completionCtx);
        int length = context.getEnd() - context.getStart();
        Range range = null;
        try {
            range = JDTUtils.toRange((IOpenable)compilationUnit, context.getStart(), length);
        }
        catch (JavaModelException e) {
            JavaLanguageServerPlugin.logException(e.getMessage(), e);
            return res;
        }
        Template[] templates = JavaLanguageServerPlugin.getInstance().getTemplateStore().getTemplates("postfix");
        Template[] availableTemplates = (Template[])Arrays.stream(templates).filter(context::canEvaluate).toArray(Template[]::new);
        boolean needsCheck = !this.isJava12OrHigherProject(compilationUnit);
        CompletionResponse response = new CompletionResponse();
        ArrayList<CompletionProposal> proposals = new ArrayList<CompletionProposal>();
        int i = 0;
        Template[] templateArray = availableTemplates;
        int n = availableTemplates.length;
        int n2 = 0;
        while (n2 < n) {
            Template template = templateArray[n2];
            if (this.canEvaluate((CompilationUnitContext)context, template, needsCheck)) {
                CompletionItem item = new CompletionItem();
                item.setLabel(template.getName());
                item.setKind(CompletionItemKind.Snippet);
                CompletionUtils.setInsertTextFormat(item, completionItemDefaults);
                CompletionUtils.setInsertTextMode(item, completionItemDefaults);
                String content = "";
                if (this.isCompletionLazyResolveTextEditEnabled()) {
                    content = SnippetUtils.templateToSnippet(template.getPattern());
                } else {
                    context.setActiveTemplateName(template.getName());
                    content = PostfixTemplateEngine.evaluateGenericTemplate(context, template);
                }
                this.setTextEdit(item, content, completionItemDefaults);
                if (!this.getClientPreferences().isResolveAdditionalTextEditsSupport()) {
                    PostfixTemplateEngine.setAdditionalTextEdit(item, compilationUnit, context, range, template);
                }
                if (this.isCompletionItemLabelDetailsSupport()) {
                    CompletionItemLabelDetails itemLabelDetails = new CompletionItemLabelDetails();
                    itemLabelDetails.setDescription(template.getDescription());
                    item.setLabelDetails(itemLabelDetails);
                }
                if (!this.getClientPreferences().isCompletionResolveDetailSupport()) {
                    item.setDetail(template.getDescription());
                }
                if (!this.getClientPreferences().isCompletionResolveDocumentSupport()) {
                    item.setDocumentation(SnippetUtils.beautifyDocument(content));
                }
                item.setSortText(SortTextHelper.convertRelevance(0));
                HashMap<String, String> data = new HashMap<String, String>(2);
                data.put("rid", String.valueOf(response.getId()));
                data.put("pid", String.valueOf(i++));
                item.setData(data);
                proposals.add(new PostfixCompletionProposal(template, context));
                res.add(item);
            }
            ++n2;
        }
        response.setProposals(proposals);
        response.setItems(res);
        response.setCommonData("uri", JDTUtils.toURI(compilationUnit));
        CompletionResponses.store(response);
        return res;
    }

    private void setTextEdit(CompletionItem item, String content, CompletionItemDefaults completionItemDefaults) {
        if (this.getClientPreferences().isCompletionListItemDefaultsSupport() && completionItemDefaults.getEditRange() != null) {
            item.setTextEditText(content);
        } else {
            item.setInsertText(content);
        }
    }

    public static void setAdditionalTextEdit(CompletionItem item, ICompilationUnit compilationUnit, JavaPostfixContext context, Range range, Template template) {
        ArrayList<org.eclipse.lsp4j.TextEdit> additionalEdits = new ArrayList<org.eclipse.lsp4j.TextEdit>();
        additionalEdits.add(new org.eclipse.lsp4j.TextEdit(range, ""));
        List<TextEdit> jdtTextEdits = context.getAdditionalTextEdits(template.getName());
        if (jdtTextEdits != null && !jdtTextEdits.isEmpty()) {
            for (TextEdit edit : jdtTextEdits) {
                TextEditConverter converter = new TextEditConverter(compilationUnit, edit);
                additionalEdits.addAll(converter.convert());
            }
        }
        item.setAdditionalTextEdits(additionalEdits);
    }

    private boolean isCompletionItemLabelDetailsSupport() {
        return JavaLanguageServerPlugin.getPreferencesManager() != null && JavaLanguageServerPlugin.getPreferencesManager().getClientPreferences().isCompletionItemLabelDetailsSupport();
    }

    private boolean isTemplateAllowed(Template template, CompilationUnitContext context) {
        if (Switch_Name.equals(template.getName())) {
            return Switch_Default.equals(template.getDescription());
        }
        if (NEW_RECORD_TEMPLATE_NAME.equals(template.getName()) && JavaModelUtil.is16OrHigher((IJavaProject)context.getJavaProject())) {
            return true;
        }
        return true;
    }

    private boolean canEvaluate(CompilationUnitContext context, Template template, boolean needsCheck) {
        if (!needsCheck) {
            return context.canEvaluate(template);
        }
        if (this.isTemplateAllowed(template, context)) {
            return context.canEvaluate(template);
        }
        return false;
    }

    private boolean isJava12OrHigherProject(ICompilationUnit compUnit) {
        if (compUnit != null) {
            IJavaProject javaProject = compUnit.getJavaProject();
            return JavaModelUtil.is12OrHigher((IJavaProject)javaProject);
        }
        return false;
    }

    public static String evaluateGenericTemplate(JavaPostfixContext postfixContext, Template template) {
        TemplateBuffer buffer = null;
        try {
            buffer = postfixContext.evaluate(template);
        }
        catch (Exception e) {
            JavaLanguageServerPlugin.logException(e.getMessage(), e);
            return null;
        }
        if (buffer == null) {
            return null;
        }
        String content = buffer.getString();
        if (Strings.containsOnlyWhitespaces((String)content)) {
            return null;
        }
        return content;
    }

    private ClientPreferences getClientPreferences() {
        return JavaLanguageServerPlugin.getPreferencesManager().getClientPreferences();
    }

    private boolean isCompletionLazyResolveTextEditEnabled() {
        return JavaLanguageServerPlugin.getPreferencesManager().getPreferences().isCompletionLazyResolveTextEditEnabled();
    }
}

