/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.managers;

import java.io.File;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.buildship.core.BuildConfiguration;
import org.eclipse.buildship.core.GradleBuild;
import org.eclipse.buildship.core.GradleCore;
import org.eclipse.buildship.core.internal.CorePlugin;
import org.eclipse.buildship.core.internal.DefaultGradleBuild;
import org.eclipse.buildship.core.internal.event.Event;
import org.eclipse.buildship.core.internal.preferences.PersistentModel;
import org.eclipse.buildship.core.internal.util.file.FileUtils;
import org.eclipse.buildship.core.internal.workspace.FetchStrategy;
import org.eclipse.buildship.core.internal.workspace.InternalGradleBuild;
import org.eclipse.buildship.core.internal.workspace.WorkbenchShutdownEvent;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jdt.apt.core.util.AptConfig;
import org.eclipse.jdt.apt.core.util.IFactoryPath;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.ProjectUtils;
import org.eclipse.jdt.ls.core.internal.ResourceUtils;
import org.eclipse.jdt.ls.core.internal.managers.GradlePreferenceChangeListener;
import org.eclipse.jdt.ls.core.internal.managers.GradleProjectImporter;
import org.eclipse.jdt.ls.core.internal.managers.GradleUtils;
import org.eclipse.jdt.ls.core.internal.managers.IBuildSupport;
import org.eclipse.jdt.ls.core.internal.managers.JavaApplicationLaunchConfiguration;
import org.eclipse.jdt.ls.core.internal.managers.ProjectsManager;
import org.eclipse.jdt.ls.core.internal.preferences.IPreferencesChangeListener;
import org.eclipse.jdt.ls.core.internal.preferences.PreferenceManager;
import org.gradle.tooling.CancellationTokenSource;
import org.gradle.tooling.GradleConnector;
import org.gradle.tooling.ModelBuilder;
import org.gradle.tooling.model.eclipse.EclipseProject;

public class GradleBuildSupport
implements IBuildSupport {
    public static final Pattern GRADLE_FILE_EXT = Pattern.compile("^.*\\.gradle(\\.kts)?$");
    public static final String GRADLE_PROPERTIES = "gradle.properties";
    public static final List<String> WATCH_FILE_PATTERNS = Arrays.asList("**/*.gradle", "**/*.gradle.kts", "**/gradle.properties");
    public static final String UNSUPPORTED_ON_GRADLE = "Unsupported operation. Please use build.gradle file to manage the source directories of gradle project.";
    private static IPreferencesChangeListener listener = new GradlePreferenceChangeListener();
    private static final String GENERATED_SOURCES_PATH = "bin/generated-sources/annotations";
    private static final String GENERATED_TEST_SOURCES_PATH = "bin/generated-test-sources/annotations";

    @Override
    public boolean applies(IProject project) {
        return ProjectUtils.isGradleProject(project);
    }

    @Override
    public void update(IProject project, boolean force, IProgressMonitor monitor) throws CoreException {
        if (!this.applies(project)) {
            return;
        }
        JavaLanguageServerPlugin.debugTrace("Starting Gradle update for " + project.getName());
        Optional build = GradleCore.getWorkspace().getBuild(project);
        if (build.isPresent()) {
            DefaultGradleBuild defaultGradleBuild;
            org.eclipse.buildship.core.internal.configuration.BuildConfiguration gradleConfig;
            boolean shouldUpdate;
            GradleBuild gradleBuild = (GradleBuild)build.get();
            boolean isRoot = this.isRoot(project, gradleBuild, monitor);
            if (force && isRoot) {
                String projectPath = project.getLocation().toFile().getAbsolutePath();
                BuildConfiguration buildConfiguration = GradleProjectImporter.getBuildConfiguration(Paths.get(projectPath, new String[0]));
                gradleBuild = GradleCore.getWorkspace().createBuild(buildConfiguration);
            }
            File buildFile = project.getFile("build.gradle").getLocation().toFile();
            File settingsFile = project.getFile("settings.gradle").getLocation().toFile();
            File buildKtsFile = project.getFile("build.gradle.kts").getLocation().toFile();
            File settingsKtsFile = project.getFile("settings.gradle.kts").getLocation().toFile();
            boolean bl = shouldUpdate = buildFile.exists() && JavaLanguageServerPlugin.getDigestStore().updateDigest(buildFile.toPath()) || settingsFile.exists() && JavaLanguageServerPlugin.getDigestStore().updateDigest(settingsFile.toPath()) || buildKtsFile.exists() && JavaLanguageServerPlugin.getDigestStore().updateDigest(buildKtsFile.toPath()) || settingsKtsFile.exists() && JavaLanguageServerPlugin.getDigestStore().updateDigest(settingsKtsFile.toPath());
            if (!(shouldUpdate |= isRoot) && force && gradleBuild instanceof DefaultGradleBuild && !(gradleConfig = (defaultGradleBuild = (DefaultGradleBuild)gradleBuild).getBuildConfig()).isAutoSync()) {
                shouldUpdate = true;
            }
            if (shouldUpdate) {
                gradleBuild.synchronize(monitor);
                GradleBuildSupport.syncAnnotationProcessingConfiguration(gradleBuild, monitor);
            }
        }
    }

    public static void syncAnnotationProcessingConfiguration(IProject project, IProgressMonitor monitor) {
        Optional build = GradleCore.getWorkspace().getBuild(project);
        if (build.isPresent()) {
            GradleBuildSupport.syncAnnotationProcessingConfiguration((GradleBuild)build.get(), monitor);
        }
    }

    public static void syncAnnotationProcessingConfiguration(GradleBuild gradleBuild, IProgressMonitor monitor) {
        PreferenceManager preferencesManager = JavaLanguageServerPlugin.getPreferencesManager();
        if (preferencesManager == null) {
            return;
        }
        if (!preferencesManager.getPreferences().isGradleAnnotationProcessingEnabled()) {
            return;
        }
        File initScript = GradleUtils.getGradleInitScript("/gradle/apt/init.gradle");
        if (initScript == null) {
            return;
        }
        Map model = null;
        try {
            model = (Map)gradleBuild.withConnection(connection -> (Map)((ModelBuilder)connection.model(Map.class).withArguments(new String[]{"--init-script", initScript.getAbsolutePath()})).get(), monitor);
        }
        catch (Exception e) {
            JavaLanguageServerPlugin.logException(e.getMessage(), e);
        }
        if (model == null) {
            return;
        }
        for (IProject project : ProjectUtils.getGradleProjects()) {
            Map apConfigurations;
            IJavaProject javaProject = JavaCore.create((IProject)project);
            if (javaProject == null || (apConfigurations = (Map)model.get(project.getLocation().toFile())) == null) continue;
            if (apConfigurations.isEmpty()) {
                GradleBuildSupport.disableApt(javaProject);
                continue;
            }
            Set<File> processors = GradleBuildSupport.getProcessors(apConfigurations);
            if (processors.isEmpty()) continue;
            AptConfig.setGenSrcDir((IJavaProject)javaProject, (String)GENERATED_SOURCES_PATH);
            AptConfig.setGenTestSrcDir((IJavaProject)javaProject, (String)GENERATED_TEST_SOURCES_PATH);
            if (!AptConfig.isEnabled((IJavaProject)javaProject)) {
                AptConfig.setEnabled((IJavaProject)javaProject, (boolean)true);
            }
            IFactoryPath factoryPath = AptConfig.getDefaultFactoryPath((IJavaProject)javaProject);
            for (File processor : processors) {
                factoryPath.addExternalJar(processor);
            }
            try {
                AptConfig.setFactoryPath((IJavaProject)javaProject, (IFactoryPath)factoryPath);
            }
            catch (CoreException e) {
                JavaLanguageServerPlugin.log(e);
            }
            List<Object> compilerArgs = GradleBuildSupport.getCompilerArgs(apConfigurations);
            Map<String, String> newOptions = GradleUtils.parseProcessorOptions(compilerArgs);
            Map currentOptions = AptConfig.getRawProcessorOptions((IJavaProject)javaProject);
            if (currentOptions.equals(newOptions)) continue;
            AptConfig.setProcessorOptions(newOptions, (IJavaProject)javaProject);
        }
    }

    private boolean isRoot(IProject project, GradleBuild gradleBuild, IProgressMonitor monitor) {
        if (gradleBuild instanceof InternalGradleBuild) {
            InternalGradleBuild internalGradleBuild = (InternalGradleBuild)gradleBuild;
            CancellationTokenSource tokenSource = GradleConnector.newCancellationTokenSource();
            Map eclipseProjects = internalGradleBuild.getModelProvider().fetchModels(EclipseProject.class, FetchStrategy.LOAD_IF_NOT_CACHED, tokenSource, monitor);
            File projectDirectory = project.getLocation().toFile();
            for (EclipseProject eclipseProject : eclipseProjects.values()) {
                File eclipseProjectDirectory = eclipseProject.getProjectDirectory();
                if (!eclipseProjectDirectory.equals(projectDirectory)) continue;
                return eclipseProject.getParent() == null;
            }
        }
        return false;
    }

    @Override
    public boolean isBuildFile(IResource resource) {
        if (resource != null && resource.getType() == 1 && this.isBuildLikeFileName(resource.getName()) && ProjectUtils.isGradleProject(resource.getProject())) {
            block4: {
                if (ProjectUtils.isJavaProject(resource.getProject())) break block4;
                return true;
            }
            try {
                IJavaProject javaProject = JavaCore.create((IProject)resource.getProject());
                IPath outputLocation = javaProject.getOutputLocation();
                return outputLocation == null || !outputLocation.isPrefixOf(resource.getFullPath());
            }
            catch (JavaModelException e) {
                JavaLanguageServerPlugin.logException(e.getMessage(), e);
            }
        }
        return false;
    }

    @Override
    public boolean isBuildLikeFileName(String fileName) {
        return GRADLE_FILE_EXT.matcher(fileName).matches() || fileName.equals(GRADLE_PROPERTIES);
    }

    public static void cleanGradleModels(IProgressMonitor monitor) {
        File projectPreferences = CorePlugin.getInstance().getStateLocation().append("project-preferences").toFile();
        if (projectPreferences.isDirectory()) {
            File[] projectFiles;
            File[] fileArray = projectFiles = projectPreferences.listFiles();
            int n = projectFiles.length;
            int n2 = 0;
            while (n2 < n) {
                File projectFile = fileArray[n2];
                String projectName = projectFile.getName();
                if (!ResourcesPlugin.getWorkspace().getRoot().getProject(projectName).exists()) {
                    FileUtils.deleteRecursively((File)projectFile);
                }
                ++n2;
            }
        }
    }

    @Override
    public boolean fileChanged(IResource resource, ProjectsManager.CHANGE_TYPE changeType, IProgressMonitor monitor) throws CoreException {
        if (resource == null || !this.applies(resource.getProject())) {
            return false;
        }
        return IBuildSupport.super.fileChanged(resource, changeType, monitor) || this.isBuildFile(resource);
    }

    @Override
    public boolean useDefaultVM(IProject project, IVMInstall defaultVM) {
        return GradleProjectImporter.useDefaultVM();
    }

    public static void saveModels() {
        CorePlugin.listenerRegistry().dispatch((Event)new WorkbenchShutdownEvent());
    }

    @Override
    public ILaunchConfiguration getLaunchConfiguration(IJavaProject javaProject, String scope) throws CoreException {
        return new JavaApplicationLaunchConfiguration(javaProject.getProject(), scope, "org.eclipse.buildship.core.classpathprovider");
    }

    @Override
    public List<String> getWatchPatterns() {
        return WATCH_FILE_PATTERNS;
    }

    @Override
    public void registerPreferencesChangeListener(PreferenceManager preferenceManager) throws CoreException {
        preferenceManager.addPreferencesChangeListener(listener);
    }

    @Override
    public void unregisterPreferencesChangeListener(PreferenceManager preferenceManager) throws CoreException {
        preferenceManager.removePreferencesChangeListener(listener);
    }

    @Override
    public String buildToolName() {
        return "Gradle";
    }

    @Override
    public String unsupportedOperationMessage() {
        return UNSUPPORTED_ON_GRADLE;
    }

    @Override
    public boolean hasSpecificDeleteProjectLogic() {
        return true;
    }

    @Override
    public void deleteInvalidProjects(Collection<IPath> rootPaths, ArrayList<IProject> deleteProjectCandates, IProgressMonitor monitor) {
        ArrayList<IProject> validGradleProjects = new ArrayList<IProject>();
        ArrayList<IProject> suspiciousGradleProjects = new ArrayList<IProject>();
        for (IProject project2 : deleteProjectCandates) {
            if (!this.applies(project2)) continue;
            if (ResourceUtils.isContainedIn(project2.getLocation(), rootPaths)) {
                validGradleProjects.add(project2);
                continue;
            }
            suspiciousGradleProjects.add(project2);
        }
        List<IProject> unrelatedProjects = this.findUnrelatedGradleProjects(suspiciousGradleProjects, validGradleProjects);
        unrelatedProjects.forEach(project -> {
            try {
                project.delete(false, true, monitor);
            }
            catch (CoreException e1) {
                JavaLanguageServerPlugin.logException(e1.getMessage(), e1);
            }
        });
    }

    private List<IProject> findUnrelatedGradleProjects(List<IProject> suspiciousProjects, List<IProject> validProjects) {
        suspiciousProjects.sort((p1, p2) -> p1.getLocation().toOSString().length() - p2.getLocation().toOSString().length());
        ArrayList<IProject> unrelatedCandidates = new ArrayList<IProject>();
        ArrayList validSubPaths = new ArrayList();
        for (IProject suspiciousProject : suspiciousProjects) {
            if (validSubPaths.contains(suspiciousProject.getFullPath().makeRelative())) continue;
            boolean isParentProject = false;
            Collection subpaths = null;
            PersistentModel model = CorePlugin.modelPersistence().loadModel(suspiciousProject);
            if (model.isPresent() && !(subpaths = model.getSubprojectPaths()).isEmpty()) {
                for (IProject validProject : validProjects) {
                    if (!subpaths.contains(validProject.getFullPath().makeRelative())) continue;
                    isParentProject = true;
                    break;
                }
            }
            if (isParentProject) {
                validSubPaths.addAll(subpaths);
                continue;
            }
            unrelatedCandidates.add(suspiciousProject);
        }
        ArrayList<IProject> result = new ArrayList<IProject>();
        for (IProject candidate : unrelatedCandidates) {
            if (validSubPaths.contains(candidate.getFullPath().makeRelative())) continue;
            result.add(candidate);
        }
        return result;
    }

    private static List<Object> getCompilerArgs(Map<String, Object> apConfigurations) {
        List l;
        Object object = apConfigurations.get("compilerArgs");
        return object instanceof List ? (l = (List)object) : List.of();
    }

    private static Set<File> getProcessors(Map<String, Object> apConfigurations) {
        Set set;
        Object object = apConfigurations.get("processors");
        return object instanceof Set ? (set = (Set)object) : Set.of();
    }

    private static void disableApt(IJavaProject javaProject) {
        if (AptConfig.isEnabled((IJavaProject)javaProject)) {
            AptConfig.setEnabled((IJavaProject)javaProject, (boolean)false);
        }
    }
}

