/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.internal.gradle.checksums;

import com.google.common.io.CharStreams;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.internal.gradle.checksums.WrapperValidator;

public class DownloadChecksumJob
extends Job {
    public static final String WRAPPER_VALIDATOR_JOBS = "WrapperValidatorJobs";
    private final BlockingQueue<String> queue = new LinkedBlockingQueue<String>();

    public DownloadChecksumJob() {
        super("Download Gradle Wrapper checksums");
    }

    protected IStatus run(IProgressMonitor monitor) {
        int totalWork = 2 * this.queue.size();
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)totalWork);
        while (!this.queue.isEmpty() && !monitor.isCanceled()) {
            HttpURLConnection connection;
            URL url;
            String urlStr = (String)this.queue.poll();
            try {
                url = new URI(urlStr).toURL();
            }
            catch (MalformedURLException | URISyntaxException e1) {
                JavaLanguageServerPlugin.logInfo("Invalid wrapper URL " + urlStr);
                continue;
            }
            subMonitor.setTaskName(url.toString());
            try {
                connection = (HttpURLConnection)url.openConnection();
                connection.setConnectTimeout(30000);
                connection.setReadTimeout(30000);
            }
            catch (IOException e) {
                JavaLanguageServerPlugin.logException(e.getMessage(), e);
                continue;
            }
            try {
                Throwable e = null;
                Object var8_12 = null;
                try {
                    AutoCloseable closer = () -> connection.disconnect();
                    try {
                        try (InputStreamReader reader = new InputStreamReader(connection.getInputStream(), StandardCharsets.UTF_8);){
                            String sha256 = CharStreams.toString((Readable)reader);
                            File sha256File = new File(WrapperValidator.getSha256CacheFile(), WrapperValidator.getFileName(urlStr));
                            this.write(sha256File, sha256);
                            WrapperValidator.allow(sha256);
                            subMonitor.worked(2);
                        }
                        if (closer == null) continue;
                    }
                    catch (Throwable throwable) {
                        if (e == null) {
                            e = throwable;
                        } else if (e != throwable) {
                            e.addSuppressed(throwable);
                        }
                        if (closer != null) {
                            closer.close();
                        }
                        throw e;
                    }
                    closer.close();
                }
                catch (Throwable throwable) {
                    if (e == null) {
                        e = throwable;
                    } else if (e != throwable) {
                        e.addSuppressed(throwable);
                    }
                    throw e;
                }
            }
            catch (Exception e) {
                JavaLanguageServerPlugin.logException("Cannot download Gradle sha256 checksum: " + url.toString(), e);
            }
        }
        subMonitor.done();
        return Status.OK_STATUS;
    }

    public void add(String urlStr) {
        this.queue.add(urlStr);
    }

    private void write(File sha256File, String sha256) {
        try {
            Files.write(Paths.get(sha256File.getAbsolutePath(), new String[0]), sha256.getBytes(), new OpenOption[0]);
        }
        catch (IOException e) {
            JavaLanguageServerPlugin.logException(e);
        }
    }

    public boolean belongsTo(Object family) {
        return WRAPPER_VALIDATOR_JOBS.equals(family);
    }

    public boolean isEmpty() {
        return this.queue.isEmpty();
    }
}

