/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.search;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.AnnotationTypeDeclaration;
import org.eclipse.jdt.core.dom.AnnotationTypeMemberDeclaration;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.ArrayInitializer;
import org.eclipse.jdt.core.dom.ArrayType;
import org.eclipse.jdt.core.dom.BooleanLiteral;
import org.eclipse.jdt.core.dom.CharacterLiteral;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.ConstructorInvocation;
import org.eclipse.jdt.core.dom.CreationReference;
import org.eclipse.jdt.core.dom.EnumConstantDeclaration;
import org.eclipse.jdt.core.dom.EnumDeclaration;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionMethodReference;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.IntersectionType;
import org.eclipse.jdt.core.dom.LambdaExpression;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.MethodRef;
import org.eclipse.jdt.core.dom.MethodReference;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NameQualifiedType;
import org.eclipse.jdt.core.dom.NullLiteral;
import org.eclipse.jdt.core.dom.NumberLiteral;
import org.eclipse.jdt.core.dom.PackageDeclaration;
import org.eclipse.jdt.core.dom.ParameterizedType;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.QualifiedType;
import org.eclipse.jdt.core.dom.RecordDeclaration;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.SuperConstructorInvocation;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.dom.SuperMethodReference;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.TypeLiteral;
import org.eclipse.jdt.core.dom.TypeMethodReference;
import org.eclipse.jdt.core.dom.TypeParameter;
import org.eclipse.jdt.core.dom.UnionType;
import org.eclipse.jdt.core.dom.VariableDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.internal.core.search.DOMASTNodeUtils;
import org.eclipse.jdt.internal.core.search.DOMPatternLocatorFactory;
import org.eclipse.jdt.internal.core.search.LocatorResponse;
import org.eclipse.jdt.internal.core.search.matching.DOMPatternLocator;
import org.eclipse.jdt.internal.core.search.matching.MatchLocator;
import org.eclipse.jdt.internal.core.search.matching.NodeSetWrapper;

class PatternLocatorVisitor
extends ASTVisitor {
    private final DOMPatternLocator domPatternLocator;
    private final NodeSetWrapper nodeSet;
    private MatchLocator locator;

    public PatternLocatorVisitor(MatchLocator locator, NodeSetWrapper nodeSet) {
        super(true);
        this.nodeSet = nodeSet;
        this.locator = locator;
        this.domPatternLocator = DOMPatternLocatorFactory.createWrapper(this.locator.patternLocator, locator.pattern);
        if (this.domPatternLocator != null) {
            this.domPatternLocator.initializePolymorphicSearch(locator);
        }
    }

    private <T extends ASTNode> boolean defaultVisitImplementation(T node, BiFunction<T, DOMPatternLocator, LocatorResponse> levelFunc) {
        this.defaultVisitImplementationWithFunc(node, levelFunc, DOMASTNodeUtils::getBinding);
        return true;
    }

    private <T extends ASTNode> LocatorResponse defaultVisitImplementationWithFunc(T node, BiFunction<T, DOMPatternLocator, LocatorResponse> levelFunc, Function<ASTNode, IBinding> bindingFunc) {
        boolean added;
        LocatorResponse resp = levelFunc.apply(node, this.domPatternLocator);
        boolean mustResolve = this.nodeSet.mustResolve() || this.locator.patternLocator.isMustResolve();
        boolean nodeReplaced = resp.replacementNodeFound();
        Object n2 = nodeReplaced ? resp.replacement() : node;
        T t = n2 = n2 == null ? node : n2;
        if (resp.level() == 2 && mustResolve) {
            LocatorResponse resp2 = this.domPatternLocator.resolveLevel((ASTNode)n2, bindingFunc.apply((ASTNode)n2), this.locator);
            n2 = resp2.replacementNodeFound() ? resp2.replacement() : n2;
            resp = new LocatorResponse(resp2.level(), resp.replacementNodeFound() || resp2.replacementNodeFound(), (ASTNode)n2, resp2.added(), resp2.canVisitChildren());
        }
        if (!(added = resp.added())) {
            this.nodeSet.addMatch((ASTNode)n2, resp.level());
        }
        return resp;
    }

    public boolean visit(AnnotationTypeDeclaration node) {
        return this.defaultVisitImplementation(node, (x, y) -> y.match((AbstractTypeDeclaration)node, this.nodeSet, this.locator));
    }

    public boolean visit(TypeParameter node) {
        return this.defaultVisitImplementation(node, (x, y) -> y.match(node, this.nodeSet, this.locator));
    }

    public boolean visit(MethodDeclaration node) {
        return this.defaultVisitImplementation(node, (x, y) -> y.match(node, this.nodeSet, this.locator));
    }

    public boolean visit(AnnotationTypeMemberDeclaration node) {
        return this.defaultVisitImplementation(node, (x, y) -> y.match(node, this.nodeSet, this.locator));
    }

    public boolean visit(MethodInvocation node) {
        return this.defaultVisitImplementation(node, (x, y) -> y.match(node, this.nodeSet, this.locator));
    }

    public boolean visit(MethodRef node) {
        return this.defaultVisitImplementation(node, (x, y) -> y.match(node, this.nodeSet, this.locator));
    }

    public boolean visit(ExpressionMethodReference node) {
        return this.defaultVisitImplementation(node, (x, y) -> y.match((MethodReference)node, this.nodeSet, this.locator));
    }

    public boolean visit(TypeMethodReference node) {
        return this.defaultVisitImplementation(node, (x, y) -> y.match((MethodReference)node, this.nodeSet, this.locator));
    }

    public boolean visit(SuperMethodReference node) {
        return this.defaultVisitImplementation(node, (x, y) -> y.match((MethodReference)node, this.nodeSet, this.locator));
    }

    public boolean visit(SuperMethodInvocation node) {
        return this.defaultVisitImplementation(node, (x, y) -> y.match((Expression)node, this.nodeSet, this.locator));
    }

    private boolean visitAbstractTypeDeclaration(AbstractTypeDeclaration node) {
        return this.defaultVisitImplementation(node, (x, y) -> y.match(node, this.nodeSet, this.locator));
    }

    public boolean visit(EnumDeclaration node) {
        return this.visitAbstractTypeDeclaration((AbstractTypeDeclaration)node);
    }

    public boolean visit(TypeDeclaration node) {
        return this.visitAbstractTypeDeclaration((AbstractTypeDeclaration)node);
    }

    public boolean visit(RecordDeclaration node) {
        return this.visitAbstractTypeDeclaration((AbstractTypeDeclaration)node);
    }

    public boolean visit(AnonymousClassDeclaration node) {
        return this.defaultVisitImplementation(node, (x, y) -> y.match((ASTNode)node, this.nodeSet, this.locator));
    }

    public boolean visit(LambdaExpression node) {
        return this.defaultVisitImplementation(node, (x, y) -> y.match(node, this.nodeSet, this.locator));
    }

    private boolean visitType(Type node) {
        LocatorResponse resp = this.defaultVisitImplementationWithFunc(node, (x, y) -> y.match(node, this.nodeSet, this.locator), DOMASTNodeUtils::getBinding);
        return resp.level() == 0 && resp.canVisitChildren();
    }

    public boolean visit(SimpleType type) {
        this.visitType((Type)type);
        Name n = type.getName();
        if (n instanceof QualifiedName) {
            QualifiedName qn = (QualifiedName)n;
            Name qualifier = qn.getQualifier();
            if (qualifier instanceof SimpleName) {
                SimpleName sn1 = (SimpleName)qualifier;
                sn1.accept((ASTVisitor)this);
            } else if (qualifier instanceof QualifiedName) {
                QualifiedName qn1 = (QualifiedName)qualifier;
                qn1.accept((ASTVisitor)this);
            }
        }
        for (Annotation ann : type.annotations()) {
            ann.accept((ASTVisitor)this);
        }
        return false;
    }

    public boolean visit(QualifiedType type) {
        boolean ret = this.visitType((Type)type);
        if (!ret) {
            this.visitAllDescendentTypeArguments((Type)type);
        }
        return ret;
    }

    public boolean visit(NameQualifiedType type) {
        boolean ret = this.visitType((Type)type);
        if (!ret) {
            this.visitAllDescendentTypeArguments((Type)type);
        }
        return ret;
    }

    public boolean visit(ParameterizedType node) {
        LocatorResponse resp = this.defaultVisitImplementationWithFunc(node, (x, y) -> y.match((Type)node, this.nodeSet, this.locator), DOMASTNodeUtils::getBinding);
        if (resp.level() == 0 && resp.canVisitChildren()) {
            return true;
        }
        this.visitAllDescendentTypeArguments((Type)node);
        return false;
    }

    private void visitAllDescendentTypeArguments(Type node) {
        node.accept(new ASTVisitor(){

            public boolean visit(ParameterizedType node) {
                PatternLocatorVisitor.this.visitTypeArgumentList(node.typeArguments());
                return true;
            }
        });
    }

    protected void visitTypeArgumentList(List typeArgs) {
        ArrayList args = new ArrayList(typeArgs);
        for (Object t : args) {
            ((Type)t).accept((ASTVisitor)this);
        }
    }

    public boolean visit(PrimitiveType node) {
        return this.visitType((Type)node);
    }

    public boolean visit(ArrayType node) {
        return this.visitType((Type)node);
    }

    public boolean visit(IntersectionType node) {
        return this.visitType((Type)node);
    }

    public boolean visit(UnionType node) {
        return this.visitType((Type)node);
    }

    public boolean visit(ClassInstanceCreation node) {
        return this.defaultVisitImplementation(node, (x, y) -> y.match((Expression)node, this.nodeSet, this.locator));
    }

    public boolean visit(CreationReference node) {
        return this.defaultVisitImplementation(node, (x, y) -> y.match((MethodReference)node, this.nodeSet, this.locator));
    }

    public boolean visit(ConstructorInvocation node) {
        return this.defaultVisitImplementation(node, (x, y) -> y.match((ASTNode)node, this.nodeSet, this.locator));
    }

    public boolean visit(SuperConstructorInvocation node) {
        return this.defaultVisitImplementation(node, (x, y) -> y.match((ASTNode)node, this.nodeSet, this.locator));
    }

    public boolean visit(SimpleName node) {
        StructuralPropertyDescriptor loc = node.getLocationInParent();
        if (loc == VariableDeclarationFragment.NAME_PROPERTY || loc == SingleVariableDeclaration.NAME_PROPERTY || loc == TypeDeclaration.NAME_PROPERTY || loc == EnumDeclaration.NAME_PROPERTY || loc == EnumConstantDeclaration.NAME_PROPERTY || loc == AnnotationTypeDeclaration.NAME_PROPERTY || loc == MethodDeclaration.NAME_PROPERTY) {
            return false;
        }
        LocatorResponse resp = this.defaultVisitImplementationWithFunc(node, (x, y) -> y.match((Name)node, this.nodeSet, this.locator), DOMASTNodeUtils::getBinding);
        return resp.level() == 0 && resp.canVisitChildren();
    }

    public boolean visit(VariableDeclarationFragment node) {
        return this.defaultVisitImplementation(node, (x, y) -> y.match((VariableDeclaration)node, this.nodeSet, this.locator));
    }

    public boolean visit(SingleVariableDeclaration node) {
        return this.defaultVisitImplementation(node, (x, y) -> y.match((VariableDeclaration)node, this.nodeSet, this.locator));
    }

    public boolean visit(EnumConstantDeclaration node) {
        LocatorResponse response = this.domPatternLocator.match((ASTNode)node, this.nodeSet, this.locator);
        boolean mustResolve = this.nodeSet.mustResolve() || this.locator.patternLocator.isMustResolve();
        int retLevel = response.level();
        if ((response.level() & 0xF) == 2 && mustResolve) {
            LocatorResponse l1 = this.domPatternLocator.resolveLevel((ASTNode)node, (IBinding)node.resolveVariable(), this.locator);
            LocatorResponse l2 = this.domPatternLocator.resolveLevel((ASTNode)node, (IBinding)node.resolveConstructorBinding(), this.locator);
            retLevel = Math.max(l1.level(), l2.level());
        }
        this.nodeSet.addMatch((ASTNode)node, retLevel);
        return true;
    }

    public boolean visit(QualifiedName node) {
        if (node.getLocationInParent() == SimpleType.NAME_PROPERTY) {
            return false;
        }
        LocatorResponse resp = this.defaultVisitImplementationWithFunc(node, (x, y) -> y.match((Name)node, this.nodeSet, this.locator), DOMASTNodeUtils::getBinding);
        return resp.level() == 0 && resp.canVisitChildren();
    }

    public boolean visit(ImportDeclaration node) {
        this.defaultVisitImplementation(node, (x, y) -> y.match((ASTNode)node, this.nodeSet, this.locator));
        return true;
    }

    public boolean visit(PackageDeclaration node) {
        this.defaultVisitImplementation(node, (x, y) -> y.match((ASTNode)node, this.nodeSet, this.locator));
        return true;
    }

    public boolean visit(MemberValuePair node) {
        this.defaultVisitImplementation(node, (x, y) -> y.match(node, this.nodeSet, this.locator));
        return true;
    }

    public boolean visit(NumberLiteral node) {
        this.defaultVisitImplementation(node, (x, y) -> y.match((Expression)node, this.nodeSet, this.locator));
        return true;
    }

    public boolean visit(StringLiteral node) {
        this.defaultVisitImplementation(node, (x, y) -> y.match((Expression)node, this.nodeSet, this.locator));
        return true;
    }

    public boolean visit(CharacterLiteral node) {
        this.defaultVisitImplementation(node, (x, y) -> y.match((Expression)node, this.nodeSet, this.locator));
        return true;
    }

    public boolean visit(BooleanLiteral node) {
        this.defaultVisitImplementation(node, (x, y) -> y.match((Expression)node, this.nodeSet, this.locator));
        return true;
    }

    public boolean visit(ArrayInitializer node) {
        this.defaultVisitImplementation(node, (x, y) -> y.match((Expression)node, this.nodeSet, this.locator));
        return true;
    }

    public boolean visit(TypeLiteral node) {
        this.defaultVisitImplementation(node, (x, y) -> y.match((Expression)node, this.nodeSet, this.locator));
        return true;
    }

    public boolean visit(NullLiteral node) {
        this.defaultVisitImplementation(node, (x, y) -> y.match((Expression)node, this.nodeSet, this.locator));
        return true;
    }
}

