/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.contentassist;

import java.util.Arrays;
import java.util.List;
import org.eclipse.jdt.core.CompletionProposal;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ls.core.internal.preferences.Preferences;

public class CompletionProposalUtils {
    private static final char SEMICOLON = ';';

    private CompletionProposalUtils() {
    }

    public static boolean isImportCompletion(CompletionProposal proposal) {
        char[] completion = proposal.getCompletion();
        if (completion.length == 0) {
            return false;
        }
        char last = completion[completion.length - 1];
        return last == ';' || last == '.';
    }

    public static CompletionProposal getRequiredTypeProposal(CompletionProposal proposal) {
        if (proposal.getKind() != 26 && proposal.getKind() != 27 && proposal.getKind() != 1) {
            return null;
        }
        CompletionProposal requiredProposal = null;
        CompletionProposal[] requiredProposals = proposal.getRequiredProposals();
        if (requiredProposals != null) {
            requiredProposal = Arrays.stream(requiredProposals).filter(p -> p.getKind() == 9).findFirst().orElse(null);
        }
        return requiredProposal;
    }

    public static void addStaticImportsAsFavoriteImports(ICompilationUnit unit) {
        try {
            List<String> staticImports = Arrays.stream(unit.getImports()).filter(t -> {
                try {
                    return Flags.isStatic((int)t.getFlags());
                }
                catch (JavaModelException e) {
                    return false;
                }
            }).map(t -> t.getElementName().replaceFirst("\\.[^\\.]+$", ".*")).toList();
            Preferences.DISCOVERED_STATIC_IMPORTS.addAll(staticImports);
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
    }
}

