/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.languageconfiguration.internal.folding;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.reconciler.DirtyRegion;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.projection.ProjectionAnnotation;
import org.eclipse.jface.text.source.projection.ProjectionAnnotationModel;
import org.eclipse.tm4e.core.internal.utils.MoreCollections;
import org.eclipse.tm4e.languageconfiguration.LanguageConfigurationPlugin;
import org.eclipse.tm4e.languageconfiguration.internal.folding.AbstractFoldingStrategy;
import org.eclipse.tm4e.languageconfiguration.internal.folding.FoldingSupport;
import org.eclipse.tm4e.languageconfiguration.internal.model.FoldingRules;
import org.eclipse.tm4e.ui.internal.model.DocumentHelper;
import org.eclipse.tm4e.ui.internal.utils.ContentTypeHelper;
import org.eclipse.tm4e.ui.internal.utils.ContentTypeInfo;

public final class TMFoldingStrategy
extends AbstractFoldingStrategy {
    private @Nullable ContentTypeInfo contentTypeInfo;

    @Override
    public void reconcile(DirtyRegion dirtyRegion, @Nullable IRegion subRegion) {
        IDocument document = this.document;
        ProjectionAnnotationModel annoModel = this.projectionAnnotationModel;
        ContentTypeInfo contentTypeInfo = this.contentTypeInfo;
        if (document == null || annoModel == null || contentTypeInfo == null) {
            return;
        }
        FoldingRules folding = FoldingSupport.getFoldingRules(contentTypeInfo);
        if (folding == null) {
            return;
        }
        try {
            boolean startLineIndex = false;
            int endLineIndexExclusive = document.getNumberOfLines();
            ArrayList<FoldingRange> foldingRanges = new ArrayList<FoldingRange>();
            ArrayList<Integer> openRanges = new ArrayList<Integer>();
            int lineIndex = 0;
            while (lineIndex < endLineIndexExclusive) {
                if (document != this.document) {
                    return;
                }
                String lineText = DocumentHelper.getLineText((IDocument)document, (int)lineIndex, (boolean)false);
                if (folding.markers.start.matchesPartially(lineText)) {
                    openRanges.add(lineIndex);
                } else if (folding.markers.end.matchesPartially(lineText) && !openRanges.isEmpty()) {
                    foldingRanges.add(new FoldingRange((Integer)MoreCollections.removeLastElement(openRanges), lineIndex));
                }
                ++lineIndex;
            }
            foldingRanges.removeIf(r -> r.endLineIndex - r.startLineIndex == 0);
            HashMap<TMFoldingAnno, Position> additions = new HashMap<TMFoldingAnno, Position>();
            ArrayList<TMFoldingAnno> deletions = new ArrayList<TMFoldingAnno>();
            HashSet newRanges = new HashSet(foldingRanges);
            int scanOffset = document.getLineOffset(0);
            int scanLength = document.getLength() - scanOffset;
            Iterator it = annoModel.getAnnotationIterator(scanOffset, scanLength, true, true);
            while (it.hasNext()) {
                if (document != this.document) {
                    return;
                }
                Annotation annotation = (Annotation)it.next();
                if (!(annotation instanceof TMFoldingAnno)) continue;
                TMFoldingAnno anno = (TMFoldingAnno)annotation;
                Position pos = annoModel.getPosition((Annotation)anno);
                if (pos == null || pos.getLength() == 0) {
                    deletions.add(anno);
                    continue;
                }
                try {
                    int annStartLineIndex = document.getLineOfOffset(pos.getOffset());
                    int annEndLineIndex = document.getLineOfOffset(pos.getOffset() + pos.getLength() - 1);
                    FoldingRange existing = new FoldingRange(annStartLineIndex, annEndLineIndex);
                    if (newRanges.remove(existing)) continue;
                    deletions.add(anno);
                }
                catch (BadLocationException ex) {
                    deletions.add(anno);
                }
            }
            for (FoldingRange range : newRanges) {
                try {
                    int startOffset = document.getLineOffset(range.startLineIndex);
                    int endOffset = document.getLineOffset(range.endLineIndex) + document.getLineLength(range.endLineIndex);
                    additions.put(new TMFoldingAnno(), new Position(startOffset, endOffset - startOffset));
                }
                catch (BadLocationException ex) {
                    LanguageConfigurationPlugin.logError(ex);
                }
            }
            if (document != this.document) {
                return;
            }
            this.modifyAnnotations(deletions, additions, List.of());
        }
        catch (BadLocationException ex) {
            LanguageConfigurationPlugin.logError(ex);
        }
    }

    @Override
    public void setDocument(@Nullable IDocument doc) {
        super.setDocument(doc);
        this.contentTypeInfo = doc == null ? null : ContentTypeHelper.findContentTypes((IDocument)doc);
    }

    private record FoldingRange(int startLineIndex, int endLineIndex) {
    }

    private static final class TMFoldingAnno
    extends ProjectionAnnotation {
        TMFoldingAnno() {
            super(false);
        }
    }
}

