/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.trace4cps.analysis.stl.impl;

import java.util.Arrays;
import java.util.List;
import org.eclipse.trace4cps.analysis.mtl.MtlFormula;
import org.eclipse.trace4cps.analysis.stl.StlFormula;
import org.eclipse.trace4cps.analysis.stl.impl.AbstractStlFormula;
import org.eclipse.trace4cps.analysis.stl.impl.STLUtil;
import org.eclipse.trace4cps.core.IPsop;

public class StlBinBool
extends AbstractStlFormula {
    private final StlFormula left;
    private final StlFormula right;
    private final BinOp bop;

    public StlBinBool(StlFormula left, BinOp bop, StlFormula right) {
        this.left = left;
        this.right = right;
        this.bop = bop;
    }

    @Override
    public List<MtlFormula> getChildren() {
        return Arrays.asList(this.left, this.right);
    }

    @Override
    protected IPsop computeSignal() {
        switch (this.bop) {
            case AND: {
                return STLUtil.signalAnd(this.left.getSignal(), this.right.getSignal());
            }
            case OR: {
                return STLUtil.signalOr(this.left.getSignal(), this.right.getSignal());
            }
            case IMPLY: {
                return STLUtil.signalImply(this.left.getSignal(), this.right.getSignal());
            }
        }
        throw new IllegalStateException();
    }

    public StlFormula getLeft() {
        return this.left;
    }

    public StlFormula getRight() {
        return this.right;
    }

    public String toString() {
        return "(" + this.left + " " + (Object)((Object)this.bop) + " " + this.right + ")";
    }

    public static enum BinOp {
        AND,
        OR,
        IMPLY;

    }
}

