/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.trace4cps.analysis.timing;

import java.util.List;
import org.eclipse.trace4cps.analysis.timing.StatisticsManager;

public class NormalStatistics {
    private final double mean;
    private final double stddev;

    public NormalStatistics(StatisticsManager mgr) {
        double sum = 0.0;
        double powSum = 0.0;
        List<Double> timings = mgr.getSamples();
        for (double d : timings) {
            sum += d;
        }
        this.mean = sum / (double)timings.size();
        for (double d : timings) {
            powSum += Math.pow(d - this.mean, 2.0);
        }
        this.stddev = Math.sqrt(powSum / (double)timings.size());
    }

    public double getMean() {
        return this.mean;
    }

    public double getSd() {
        return this.stddev;
    }
}

