/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.analysis.profiling.ui.flamegraph;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.tracecompass.internal.analysis.profiling.core.callgraph.AggregatedCalledFunction;
import org.eclipse.tracecompass.internal.analysis.profiling.core.callgraph.ThreadNode;
import org.eclipse.tracecompass.internal.analysis.profiling.ui.flamegraph.FlamegraphDepthEntry;
import org.eclipse.tracecompass.internal.analysis.profiling.ui.flamegraph.FlamegraphEvent;
import org.eclipse.tracecompass.internal.analysis.profiling.ui.flamegraph.SortOption;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.ITimeGraphContentProvider;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeGraphEntry;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.TimeGraphEntry;

public class FlameGraphContentProvider
implements ITimeGraphContentProvider {
    private Collection<?> fCurrentInput = null;
    private final List<FlamegraphDepthEntry> fFlameGraphEntries = new ArrayList<FlamegraphDepthEntry>();
    private SortOption fSortOption = SortOption.BY_NAME;
    private @NonNull Comparator<FlamegraphDepthEntry> fThreadComparator = Objects.requireNonNull(Comparator.comparing(TimeGraphEntry::getName));

    public boolean hasChildren(Object element) {
        if (element instanceof FlamegraphDepthEntry) {
            return ((FlamegraphDepthEntry)((Object)element)).hasChildren();
        }
        return false;
    }

    public ITimeGraphEntry[] getElements(Object inputElement) {
        if (!Objects.equals(this.fCurrentInput, inputElement)) {
            this.fFlameGraphEntries.clear();
            if (inputElement instanceof Collection) {
                Collection threadNodes = (Collection)inputElement;
                for (ThreadNode object : Iterables.filter((Iterable)threadNodes, ThreadNode.class)) {
                    this.buildChildrenEntries(object);
                }
                this.fCurrentInput = threadNodes;
            } else {
                return new ITimeGraphEntry[0];
            }
        }
        this.fFlameGraphEntries.sort(this.fThreadComparator);
        return this.fFlameGraphEntries.toArray(new ITimeGraphEntry[this.fFlameGraphEntries.size()]);
    }

    private void buildChildrenEntries(ThreadNode threadNode) {
        FlamegraphDepthEntry threadEntry = new FlamegraphDepthEntry(threadNode.getSymbol().toString(), 0L, 0L, this.fFlameGraphEntries.size(), threadNode.getId());
        for (AggregatedCalledFunction child : FlameGraphContentProvider.getSortedChildren((AggregatedCalledFunction)threadNode)) {
            FlameGraphContentProvider.addEntries(threadEntry, child);
        }
        this.fFlameGraphEntries.add(threadEntry);
    }

    private static void addEntries(FlamegraphDepthEntry threadEntry, AggregatedCalledFunction function) {
        TimeGraphEntry depthEntry;
        int depth = function.getDepth();
        if (threadEntry.getChildren().size() <= depth) {
            depthEntry = new FlamegraphDepthEntry(String.valueOf(depth), 0L, 0L, depth, depth);
            threadEntry.addChild(depthEntry);
        } else {
            depthEntry = (TimeGraphEntry)threadEntry.getChildren().get(depth);
        }
        depthEntry.addEvent((ITimeEvent)new FlamegraphEvent((ITimeGraphEntry)depthEntry, threadEntry.getEndTime(), function));
        for (AggregatedCalledFunction node : FlameGraphContentProvider.getSortedChildren(function)) {
            FlameGraphContentProvider.addEntries(threadEntry, node);
        }
        threadEntry.updateEndTime(depthEntry.getEndTime());
    }

    private static Iterable<@NonNull AggregatedCalledFunction> getSortedChildren(AggregatedCalledFunction function) {
        ArrayList<@NonNull AggregatedCalledFunction> children = new ArrayList<AggregatedCalledFunction>(function.getChildren());
        children.sort(Comparator.comparingLong(AggregatedCalledFunction::getDuration));
        return children;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public ITimeGraphEntry[] getChildren(Object parentElement) {
        if (parentElement instanceof FlamegraphDepthEntry) {
            @NonNull List children = ((FlamegraphDepthEntry)((Object)parentElement)).getChildren();
            return (ITimeGraphEntry[])children.toArray(new TimeGraphEntry[children.size()]);
        }
        return new ITimeGraphEntry[0];
    }

    public ITimeGraphEntry getParent(Object element) {
        if (element instanceof FlamegraphDepthEntry) {
            return ((FlamegraphDepthEntry)((Object)element)).getParent();
        }
        return null;
    }

    public void dispose() {
        this.fFlameGraphEntries.clear();
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public SortOption getSortOption() {
        return this.fSortOption;
    }

    public void setSortOption(SortOption sortOption) {
        this.fSortOption = sortOption;
        switch (sortOption) {
            case BY_NAME: {
                this.fThreadComparator = Objects.requireNonNull(Comparator.comparing(TimeGraphEntry::getName));
                break;
            }
            case BY_NAME_REV: {
                this.fThreadComparator = Objects.requireNonNull(Comparator.comparing(TimeGraphEntry::getName, Comparator.reverseOrder()));
                break;
            }
            case BY_ID: {
                this.fThreadComparator = Objects.requireNonNull(Comparator.comparingLong(FlamegraphDepthEntry::getId));
                break;
            }
            case BY_ID_REV: {
                this.fThreadComparator = Objects.requireNonNull(Comparator.comparing(FlamegraphDepthEntry::getId, Comparator.reverseOrder()));
                break;
            }
        }
        this.fFlameGraphEntries.sort(this.fThreadComparator);
    }
}

