/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtchart.internal.axis;

import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swtchart.Chart;
import org.eclipse.swtchart.IAxis;
import org.eclipse.swtchart.internal.Title;
import org.eclipse.swtchart.internal.axis.Axis;
import org.eclipse.swtchart.internal.axis.Messages;

public class AxisTitle
extends Title {
    private static final String DEFAULT_TEXT_FOR_XAXIS = Messages.getString("X_AXIS");
    private static final String DEFAULT_TEXT_FOR_YAXIS = Messages.getString("Y_AXIS");
    private static final int DEFAULT_FONT_SIZE = 11;
    private final Font defaultFont;
    private final Axis axis;
    private final IAxis.Direction direction;

    public AxisTitle(Chart chart, int style, Axis axis, IAxis.Direction direction) {
        super(chart);
        this.axis = axis;
        this.direction = direction;
        this.defaultFont = new Font((Device)Display.getDefault(), "Tahoma", 11, 1);
        this.setFont(this.defaultFont);
        this.setText(this.getDefaultText());
    }

    @Override
    protected String getDefaultText() {
        if (this.direction == IAxis.Direction.X) {
            return DEFAULT_TEXT_FOR_XAXIS;
        }
        return DEFAULT_TEXT_FOR_YAXIS;
    }

    @Override
    protected boolean isHorizontal() {
        return this.axis.isHorizontalAxis();
    }

    @Override
    public void dispose() {
        super.dispose();
        if (!this.defaultFont.isDisposed()) {
            this.defaultFont.dispose();
        }
    }
}

