/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.index;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.SequencedCollection;
import java.util.regex.Pattern;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ILinkage;
import org.eclipse.cdt.core.dom.IName;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPNamespace;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPUsingDeclaration;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.index.IIndexBinding;
import org.eclipse.cdt.core.index.IIndexFile;
import org.eclipse.cdt.core.index.IIndexFileLocation;
import org.eclipse.cdt.core.index.IIndexFileSet;
import org.eclipse.cdt.core.index.IIndexInclude;
import org.eclipse.cdt.core.index.IIndexMacro;
import org.eclipse.cdt.core.index.IIndexName;
import org.eclipse.cdt.core.index.IndexFilter;
import org.eclipse.cdt.core.parser.ISignificantMacros;
import org.eclipse.cdt.internal.core.dom.Linkage;
import org.eclipse.cdt.internal.core.index.FileContentKey;
import org.eclipse.cdt.internal.core.index.IIndexFragment;
import org.eclipse.cdt.internal.core.index.IIndexFragmentBinding;
import org.eclipse.cdt.internal.core.index.IIndexFragmentFile;
import org.eclipse.cdt.internal.core.index.IIndexFragmentInclude;
import org.eclipse.cdt.internal.core.index.IIndexFragmentName;
import org.eclipse.cdt.internal.core.index.IIndexScope;
import org.eclipse.cdt.internal.core.index.IWritableIndexFragment;
import org.eclipse.cdt.internal.core.index.IndexFileSet;
import org.eclipse.cdt.internal.core.index.Messages;
import org.eclipse.cdt.internal.core.index.composite.CompositingNotImplementedError;
import org.eclipse.cdt.internal.core.index.composite.ICompositesFactory;
import org.eclipse.cdt.internal.core.index.composite.c.CCompositesFactory;
import org.eclipse.cdt.internal.core.index.composite.cpp.CPPCompositesFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class CIndex
implements IIndex {
    private static final boolean SPECIALCASE_SINGLES = true;
    private final IIndexFragment[] fFragments;
    private int fReadLock;
    private ICompositesFactory cppCF;
    private ICompositesFactory cCF;
    private ICompositesFactory fCF;

    public CIndex(IIndexFragment[] fragments) {
        this.fFragments = fragments;
    }

    @Override
    public IIndexBinding findBinding(IName name) throws CoreException {
        if (name instanceof IIndexFragmentName) {
            return this.adaptBinding(((IIndexFragmentName)name).getBinding());
        }
        if (name instanceof IASTName) {
            if (this.fFragments.length == 1) {
                return this.fFragments[0].findBinding((IASTName)name);
            }
            IIndexFragment[] iIndexFragmentArray = this.fFragments;
            int n = this.fFragments.length;
            int n2 = 0;
            while (n2 < n) {
                IIndexFragment fragment = iIndexFragmentArray[n2];
                IIndexFragmentBinding binding = fragment.findBinding((IASTName)name);
                if (binding != null) {
                    return this.getCompositesFactory(binding.getLinkage().getLinkageID()).getCompositeBinding(binding);
                }
                ++n2;
            }
        }
        return null;
    }

    @Override
    public IIndexBinding[] findBindings(Pattern pattern, boolean isFullyQualified, IndexFilter filter, IProgressMonitor monitor) throws CoreException {
        return this.findBindings(new Pattern[]{pattern}, isFullyQualified, filter, monitor);
    }

    @Override
    public IIndexBinding[] findBindings(Pattern[] patterns, boolean isFullyQualified, IndexFilter filter, IProgressMonitor monitor) throws CoreException {
        ILinkage[] linkages;
        if (this.fFragments.length == 1) {
            return this.fFragments[0].findBindings(patterns, isFullyQualified, filter, monitor);
        }
        ArrayList<IIndexBinding[]> result = new ArrayList<IIndexBinding[]>();
        ILinkage[] iLinkageArray = linkages = Linkage.getIndexerLinkages();
        int n = linkages.length;
        int n2 = 0;
        while (n2 < n) {
            ILinkage linkage = iLinkageArray[n2];
            if (filter.acceptLinkage(linkage)) {
                IIndexFragmentBinding[][] fragmentBindings = new IIndexFragmentBinding[this.fFragments.length][];
                int i = 0;
                while (i < this.fFragments.length) {
                    try {
                        IIndexFragmentBinding[] part = this.fFragments[i].findBindings(patterns, isFullyQualified, this.retargetFilter(linkage, filter), monitor);
                        fragmentBindings[i] = new IIndexFragmentBinding[part.length];
                        System.arraycopy(part, 0, fragmentBindings[i], 0, part.length);
                    }
                    catch (CoreException e) {
                        CCorePlugin.log(e);
                        fragmentBindings[i] = IIndexFragmentBinding.EMPTY_INDEX_BINDING_ARRAY;
                    }
                    ++i;
                }
                ICompositesFactory factory = this.getCompositesFactory(linkage.getLinkageID());
                result.add(factory.getCompositeBindings(fragmentBindings));
            }
            ++n2;
        }
        return this.flatten(result);
    }

    @Override
    public IIndexBinding[] findMacroContainers(Pattern pattern, IndexFilter filter, IProgressMonitor monitor) throws CoreException {
        ILinkage[] linkages;
        if (this.fFragments.length == 1) {
            return this.fFragments[0].findMacroContainers(pattern, filter, monitor);
        }
        ArrayList<IIndexBinding[]> result = new ArrayList<IIndexBinding[]>();
        ILinkage[] iLinkageArray = linkages = Linkage.getIndexerLinkages();
        int n = linkages.length;
        int n2 = 0;
        while (n2 < n) {
            ILinkage linkage = iLinkageArray[n2];
            if (filter.acceptLinkage(linkage)) {
                IIndexFragmentBinding[][] fragmentBindings = new IIndexFragmentBinding[this.fFragments.length][];
                int i = 0;
                while (i < this.fFragments.length) {
                    try {
                        IIndexFragmentBinding[] part = this.fFragments[i].findMacroContainers(pattern, this.retargetFilter(linkage, filter), monitor);
                        fragmentBindings[i] = new IIndexFragmentBinding[part.length];
                        System.arraycopy(part, 0, fragmentBindings[i], 0, part.length);
                    }
                    catch (CoreException e) {
                        CCorePlugin.log(e);
                        fragmentBindings[i] = IIndexFragmentBinding.EMPTY_INDEX_BINDING_ARRAY;
                    }
                    ++i;
                }
                ICompositesFactory factory = this.getCompositesFactory(linkage.getLinkageID());
                result.add(factory.getCompositeBindings(fragmentBindings));
            }
            ++n2;
        }
        return this.flatten(result);
    }

    @Override
    public IIndexName[] findNames(IBinding binding, int flags) throws CoreException {
        IIndexFragmentName name;
        int n;
        int n2;
        IIndexFragmentName[] iIndexFragmentNameArray;
        IIndexFragmentName[] names;
        IIndexFragment fragment;
        ArrayList<IIndexFragmentName> result = new ArrayList<IIndexFragmentName>();
        if (binding instanceof ICPPUsingDeclaration) {
            IBinding[] bindings = ((ICPPUsingDeclaration)binding).getDelegates();
            if (bindings == null || bindings.length == 0) {
                return IIndexName.EMPTY_ARRAY;
            }
            if (bindings.length > 1) {
                ArrayList<IIndexName> multi = new ArrayList<IIndexName>();
                IBinding[] iBindingArray = bindings;
                int n3 = bindings.length;
                int n4 = 0;
                while (n4 < n3) {
                    IBinding b = iBindingArray[n4];
                    multi.addAll(Arrays.asList(this.findNames(b, flags)));
                    ++n4;
                }
                return multi.toArray(new IIndexName[multi.size()]);
            }
            binding = bindings[0];
        }
        HashSet<NameKey> encounteredNames = new HashSet<NameKey>();
        IIndexFragment[] iIndexFragmentArray = this.fFragments;
        int n5 = this.fFragments.length;
        int n6 = 0;
        while (n6 < n5) {
            fragment = iIndexFragmentArray[n6];
            if (fragment instanceof IWritableIndexFragment) {
                iIndexFragmentNameArray = names = fragment.findNames(binding, flags);
                n2 = names.length;
                n = 0;
                while (n < n2) {
                    name = iIndexFragmentNameArray[n];
                    if (encounteredNames.add(new NameKey(name, true))) {
                        result.add(name);
                    }
                    ++n;
                }
            }
            ++n6;
        }
        iIndexFragmentArray = this.fFragments;
        n5 = this.fFragments.length;
        n6 = 0;
        while (n6 < n5) {
            fragment = iIndexFragmentArray[n6];
            if (!(fragment instanceof IWritableIndexFragment)) {
                iIndexFragmentNameArray = names = fragment.findNames(binding, flags);
                n2 = names.length;
                n = 0;
                while (n < n2) {
                    name = iIndexFragmentNameArray[n];
                    if (encounteredNames.add(new NameKey(name, false))) {
                        result.add(name);
                    }
                    ++n;
                }
            }
            ++n6;
        }
        return result.toArray(new IIndexName[result.size()]);
    }

    @Override
    public IIndexName[] findDeclarations(IBinding binding) throws CoreException {
        return this.findNames(binding, 3);
    }

    @Override
    public IIndexName[] findDefinitions(IBinding binding) throws CoreException {
        return this.findNames(binding, 2);
    }

    @Override
    public IIndexName[] findReferences(IBinding binding) throws CoreException {
        return this.findNames(binding, 4);
    }

    @Override
    @Deprecated
    public IIndexFile getFile(int linkageID, IIndexFileLocation location) throws CoreException {
        IIndexFragment[] iIndexFragmentArray = this.fFragments;
        int n = this.fFragments.length;
        int n2 = 0;
        while (n2 < n) {
            IIndexFragment fragment = iIndexFragmentArray[n2];
            IIndexFragmentFile candidate = fragment.getFile(linkageID, location);
            if (candidate != null && candidate.hasContent()) {
                return candidate;
            }
            ++n2;
        }
        return null;
    }

    @Override
    public IIndexFile getFile(int linkageID, IIndexFileLocation location, ISignificantMacros significantMacros) throws CoreException {
        IIndexFragment[] iIndexFragmentArray = this.fFragments;
        int n = this.fFragments.length;
        int n2 = 0;
        while (n2 < n) {
            IIndexFragment fragment = iIndexFragmentArray[n2];
            IIndexFragmentFile candidate = fragment.getFile(linkageID, location, significantMacros);
            if (candidate != null && candidate.hasContent()) {
                return candidate;
            }
            ++n2;
        }
        return null;
    }

    @Override
    public IIndexFile[] getFiles(int linkageID, IIndexFileLocation location) throws CoreException {
        if (location == null) {
            return IIndexFile.EMPTY_FILE_ARRAY;
        }
        HashSet<ISignificantMacros> handled = new HashSet<ISignificantMacros>();
        ArrayList<IIndexFragmentFile> result = new ArrayList<IIndexFragmentFile>();
        IIndexFragment[] iIndexFragmentArray = this.fFragments;
        int n = this.fFragments.length;
        int n2 = 0;
        while (n2 < n) {
            IIndexFragmentFile[] candidates;
            IIndexFragment fragment = iIndexFragmentArray[n2];
            IIndexFragmentFile[] iIndexFragmentFileArray = candidates = fragment.getFiles(linkageID, location);
            int n3 = candidates.length;
            int n4 = 0;
            while (n4 < n3) {
                ISignificantMacros macroKey;
                IIndexFragmentFile candidate = iIndexFragmentFileArray[n4];
                if (candidate.hasContent() && handled.add(macroKey = candidate.getSignificantMacros())) {
                    result.add(candidate);
                }
                ++n4;
            }
            ++n2;
        }
        if (result.isEmpty()) {
            return IIndexFile.EMPTY_FILE_ARRAY;
        }
        return result.toArray(new IIndexFile[result.size()]);
    }

    @Override
    public IIndexFile[] getFiles(IIndexFileLocation location) throws CoreException {
        if (location == null) {
            return IIndexFile.EMPTY_FILE_ARRAY;
        }
        HashSet<FileContentKey> keys = new HashSet<FileContentKey>();
        ArrayList<IIndexFragmentFile> result = new ArrayList<IIndexFragmentFile>();
        IIndexFragment[] iIndexFragmentArray = this.fFragments;
        int n = this.fFragments.length;
        int n2 = 0;
        while (n2 < n) {
            IIndexFragmentFile[] candidates;
            IIndexFragment fragment = iIndexFragmentArray[n2];
            IIndexFragmentFile[] iIndexFragmentFileArray = candidates = fragment.getFiles(location);
            int n3 = candidates.length;
            int n4 = 0;
            while (n4 < n3) {
                IIndexFragmentFile candidate = iIndexFragmentFileArray[n4];
                if (candidate.hasContent() && keys.add(new FileContentKey(candidate.getLinkageID(), candidate.getLocation(), candidate.getSignificantMacros()))) {
                    result.add(candidate);
                }
                ++n4;
            }
            ++n2;
        }
        if (result.isEmpty()) {
            return IIndexFile.EMPTY_FILE_ARRAY;
        }
        return result.toArray(new IIndexFile[result.size()]);
    }

    @Override
    public IIndexFile resolveInclude(IIndexInclude include) throws CoreException {
        IIndexFragmentInclude fragmentInclude = (IIndexFragmentInclude)include;
        IIndexFragmentFile result = fragmentInclude.getIncludes();
        if (result == null) {
            return null;
        }
        if (result.hasContent()) {
            return result;
        }
        return this.getFile(result.getLinkageID(), result.getLocation(), result.getSignificantMacros());
    }

    @Override
    public IIndexInclude[] findIncludedBy(IIndexFile file) throws CoreException {
        return this.findIncludedBy(file, 0);
    }

    @Override
    public IIndexInclude[] findIncludedBy(IIndexFile file, int depth) throws CoreException {
        ArrayList<IIndexFragmentInclude> result = new ArrayList<IIndexFragmentInclude>();
        SequencedCollection<IIndexFile> in = Collections.singletonList(file);
        HashSet<FileContentKey> handled = new HashSet<FileContentKey>();
        while (true) {
            ArrayDeque<IIndexFile> nextLevel = depth != 0 ? new ArrayDeque<IIndexFile>() : null;
            for (IIndexFile indexFile : in) {
                IIndexFragmentFile file1 = (IIndexFragmentFile)indexFile;
                IIndexFragment[] iIndexFragmentArray = this.fFragments;
                int n = this.fFragments.length;
                int n2 = 0;
                while (n2 < n) {
                    IIndexFragmentInclude[] includedBy;
                    IIndexFragment fragment = iIndexFragmentArray[n2];
                    IIndexFragmentInclude[] iIndexFragmentIncludeArray = includedBy = fragment.findIncludedBy(file1);
                    int n3 = includedBy.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IIndexFragmentInclude include = iIndexFragmentIncludeArray[n4];
                        IIndexFile includer = include.getIncludedBy();
                        FileContentKey key = new FileContentKey(file.getLinkageID(), includer.getLocation(), includer.getSignificantMacros());
                        if (handled.add(key)) {
                            result.add(include);
                            if (nextLevel != null) {
                                nextLevel.add(includer);
                            }
                        }
                        ++n4;
                    }
                    ++n2;
                }
            }
            if (nextLevel == null || nextLevel.isEmpty()) break;
            if (depth > 0) {
                --depth;
            }
            in = nextLevel;
        }
        return result.toArray(new IIndexInclude[result.size()]);
    }

    @Override
    public IIndexInclude[] findIncludes(IIndexFile file) throws CoreException {
        return this.findIncludes(file, 0);
    }

    @Override
    public IIndexInclude[] findIncludes(IIndexFile file, int depth) throws CoreException {
        ArrayList<IIndexInclude> result = new ArrayList<IIndexInclude>();
        SequencedCollection<IIndexFile> in = Collections.singletonList(file);
        HashSet<Object> handled = new HashSet<Object>();
        while (true) {
            ArrayDeque<IIndexFile> nextLevel = depth != 0 ? new ArrayDeque<IIndexFile>() : null;
            for (IIndexFile indexFile : in) {
                IIndexInclude[] includes;
                IIndexFragmentFile file1 = (IIndexFragmentFile)indexFile;
                IIndexInclude[] iIndexIncludeArray = includes = file1.getIncludes();
                int n = includes.length;
                int n2 = 0;
                while (n2 < n) {
                    Object key;
                    IIndexInclude include = iIndexIncludeArray[n2];
                    IIndexFileLocation target = include.getIncludesLocation();
                    Object object = key = target != null ? target : include.getFullName();
                    if (handled.add(key)) {
                        IIndexFile includedByFile;
                        result.add(include);
                        if (nextLevel != null && (includedByFile = this.resolveInclude(include)) != null) {
                            nextLevel.add(includedByFile);
                        }
                    }
                    ++n2;
                }
            }
            if (nextLevel == null || nextLevel.isEmpty()) break;
            if (depth > 0) {
                --depth;
            }
            in = nextLevel;
        }
        return result.toArray(new IIndexInclude[result.size()]);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public synchronized void acquireReadLock() throws InterruptedException {
        block6: {
            if (++this.fReadLock == 1) {
                i = 0;
                try {
                    i = 0;
                    while (i < this.fFragments.length) {
                        this.fFragments[i].acquireReadLock();
                        ++i;
                    }
                }
                finally {
                    if (i >= this.fFragments.length) break block6;
                    --this.fReadLock;
                    ** while (--i >= 0)
                }
lbl-1000:
                // 1 sources

                {
                    this.fFragments[i].releaseReadLock();
                    continue;
                }
            }
        }
    }

    @Override
    public synchronized void releaseReadLock() {
        if (--this.fReadLock == 0) {
            IIndexFragment[] iIndexFragmentArray = this.fFragments;
            int n = this.fFragments.length;
            int n2 = 0;
            while (n2 < n) {
                IIndexFragment fragment = iIndexFragmentArray[n2];
                fragment.releaseReadLock();
                ++n2;
            }
        }
    }

    protected synchronized int getReadLockCount() {
        return this.fReadLock;
    }

    @Override
    public boolean hasWaitingReaders() {
        IIndexFragment[] iIndexFragmentArray = this.fFragments;
        int n = this.fFragments.length;
        int n2 = 0;
        while (n2 < n) {
            IIndexFragment fragment = iIndexFragmentArray[n2];
            if (fragment.hasWaitingReaders()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public long getLastWriteAccess() {
        long result = 0L;
        IIndexFragment[] iIndexFragmentArray = this.fFragments;
        int n = this.fFragments.length;
        int n2 = 0;
        while (n2 < n) {
            IIndexFragment fragment = iIndexFragmentArray[n2];
            result = Math.max(result, fragment.getLastWriteAccess());
            ++n2;
        }
        return result;
    }

    @Override
    public IIndexBinding[] findBindings(char[][] names, IndexFilter filter, IProgressMonitor monitor) throws CoreException {
        if (this.fFragments.length == 1) {
            try {
                return this.fFragments[0].findBindings(names, filter, monitor);
            }
            catch (CoreException e) {
                CCorePlugin.log(e);
                return IIndexFragmentBinding.EMPTY_INDEX_BINDING_ARRAY;
            }
        }
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        ArrayList<IIndexBinding[]> result = new ArrayList<IIndexBinding[]>();
        ILinkage[] linkages = Linkage.getIndexerLinkages();
        SubMonitor loopMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.CIndex_FindBindingsTask_label, (int)(this.fFragments.length * linkages.length));
        ILinkage[] iLinkageArray = linkages;
        int n = linkages.length;
        int n2 = 0;
        while (n2 < n) {
            ILinkage linkage = iLinkageArray[n2];
            if (filter.acceptLinkage(linkage)) {
                IIndexFragmentBinding[][] fragmentBindings = new IIndexFragmentBinding[this.fFragments.length][];
                int i = 0;
                while (i < this.fFragments.length) {
                    try {
                        IIndexFragmentBinding[] part = this.fFragments[i].findBindings(names, this.retargetFilter(linkage, filter), (IProgressMonitor)loopMonitor.newChild(1));
                        fragmentBindings[i] = new IIndexFragmentBinding[part.length];
                        System.arraycopy(part, 0, fragmentBindings[i], 0, part.length);
                    }
                    catch (CoreException e) {
                        CCorePlugin.log(e);
                        fragmentBindings[i] = IIndexFragmentBinding.EMPTY_INDEX_BINDING_ARRAY;
                    }
                    ++i;
                }
                ICompositesFactory factory = this.getCompositesFactory(linkage.getLinkageID());
                result.add(factory.getCompositeBindings(fragmentBindings));
            }
            ++n2;
        }
        monitor.done();
        return this.flatten(result);
    }

    @Override
    public IIndexBinding adaptBinding(IBinding binding) {
        try {
            if (this.fFragments.length == 1) {
                return this.fFragments[0].adaptBinding(binding);
            }
            IIndexFragment[] iIndexFragmentArray = this.fFragments;
            int n = this.fFragments.length;
            int n2 = 0;
            while (n2 < n) {
                IIndexFragment fragment = iIndexFragmentArray[n2];
                IIndexFragmentBinding adaptedBinding = fragment.adaptBinding(binding);
                if (adaptedBinding != null) {
                    return this.getCompositesFactory(binding.getLinkage().getLinkageID()).getCompositeBinding(adaptedBinding);
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
        }
        return null;
    }

    @Override
    public IIndexBinding[] findBindings(char[] name, IndexFilter filter, IProgressMonitor monitor) throws CoreException {
        return this.findBindings(name, true, filter, monitor);
    }

    private IIndexBinding[] flatten(List<IIndexBinding[]> bindingArrays) {
        int size = 0;
        int i = 0;
        while (i < bindingArrays.size()) {
            size += bindingArrays.get(i).length;
            ++i;
        }
        IIndexBinding[] result = new IIndexBinding[size];
        int offset = 0;
        int i2 = 0;
        while (i2 < bindingArrays.size()) {
            IBinding[] src = bindingArrays.get(i2);
            System.arraycopy(src, 0, result, offset, src.length);
            offset += src.length;
            ++i2;
        }
        return result;
    }

    public IIndexFragment[] getFragments() {
        return this.fFragments;
    }

    public IIndexFragmentBinding[] findEquivalentBindings(IBinding binding) throws CoreException {
        ArrayList<IIndexFragmentBinding> result = new ArrayList<IIndexFragmentBinding>();
        IIndexFragment[] iIndexFragmentArray = this.fFragments;
        int n = this.fFragments.length;
        int n2 = 0;
        while (n2 < n) {
            IIndexFragment fragment = iIndexFragmentArray[n2];
            IIndexFragmentBinding adapted = fragment.adaptBinding(binding);
            if (adapted != null) {
                result.add(adapted);
            }
            ++n2;
        }
        return result.toArray(new IIndexFragmentBinding[result.size()]);
    }

    private ICompositesFactory getCompositesFactory(int linkageID) {
        switch (linkageID) {
            case 1: {
                if (this.cppCF == null) {
                    this.cppCF = new CPPCompositesFactory(this);
                }
                return this.cppCF;
            }
            case 2: {
                if (this.cCF == null) {
                    this.cCF = new CCompositesFactory(this);
                }
                return this.cCF;
            }
            case 3: {
                if (this.fCF == null) {
                    this.fCF = new CCompositesFactory(this);
                }
                return this.fCF;
            }
        }
        throw new CompositingNotImplementedError("Compositing not implemented for linkage ID " + linkageID);
    }

    private IndexFilter retargetFilter(final ILinkage linkage, final IndexFilter filter) {
        return new IndexFilter(){

            @Override
            public boolean acceptBinding(IBinding binding) throws CoreException {
                return filter.acceptBinding(binding);
            }

            @Override
            public boolean acceptLinkage(ILinkage other) {
                return linkage.getLinkageID() == other.getLinkageID();
            }
        };
    }

    @Override
    public IIndexBinding[] findBindingsForPrefix(char[] prefix, boolean filescope, IndexFilter filter, IProgressMonitor monitor) throws CoreException {
        ILinkage[] linkages;
        if (this.fFragments.length == 1) {
            return this.fFragments[0].findBindingsForPrefix(prefix, filescope, filter, monitor);
        }
        ArrayList<IIndexBinding[]> result = new ArrayList<IIndexBinding[]>();
        ILinkage[] iLinkageArray = linkages = Linkage.getIndexerLinkages();
        int n = linkages.length;
        int n2 = 0;
        while (n2 < n) {
            ILinkage linkage = iLinkageArray[n2];
            if (filter.acceptLinkage(linkage)) {
                IIndexFragmentBinding[][] fragmentBindings = new IIndexFragmentBinding[this.fFragments.length][];
                int i = 0;
                while (i < this.fFragments.length) {
                    try {
                        IIndexFragmentBinding[] part = this.fFragments[i].findBindingsForPrefix(prefix, filescope, this.retargetFilter(linkage, filter), monitor);
                        fragmentBindings[i] = new IIndexFragmentBinding[part.length];
                        System.arraycopy(part, 0, fragmentBindings[i], 0, part.length);
                    }
                    catch (CoreException e) {
                        CCorePlugin.log(e);
                        fragmentBindings[i] = IIndexFragmentBinding.EMPTY_INDEX_BINDING_ARRAY;
                    }
                    ++i;
                }
                ICompositesFactory factory = this.getCompositesFactory(linkage.getLinkageID());
                result.add(factory.getCompositeBindings(fragmentBindings));
            }
            ++n2;
        }
        return this.flatten(result);
    }

    @Override
    public IIndexBinding[] findBindingsForContentAssist(char[] prefix, boolean filescope, IndexFilter filter, IProgressMonitor monitor) throws CoreException {
        ILinkage[] linkages;
        if (this.fFragments.length == 1) {
            return this.fFragments[0].findBindingsForContentAssist(prefix, filescope, filter, monitor);
        }
        ArrayList<IIndexBinding[]> result = new ArrayList<IIndexBinding[]>();
        ILinkage[] iLinkageArray = linkages = Linkage.getIndexerLinkages();
        int n = linkages.length;
        int n2 = 0;
        while (n2 < n) {
            ILinkage linkage = iLinkageArray[n2];
            if (filter.acceptLinkage(linkage)) {
                IIndexFragmentBinding[][] fragmentBindings = new IIndexFragmentBinding[this.fFragments.length][];
                int i = 0;
                while (i < this.fFragments.length) {
                    try {
                        IIndexFragmentBinding[] part = this.fFragments[i].findBindingsForContentAssist(prefix, filescope, this.retargetFilter(linkage, filter), monitor);
                        fragmentBindings[i] = new IIndexFragmentBinding[part.length];
                        System.arraycopy(part, 0, fragmentBindings[i], 0, part.length);
                    }
                    catch (CoreException e) {
                        CCorePlugin.log(e);
                        fragmentBindings[i] = IIndexFragmentBinding.EMPTY_INDEX_BINDING_ARRAY;
                    }
                    ++i;
                }
                ICompositesFactory factory = this.getCompositesFactory(linkage.getLinkageID());
                result.add(factory.getCompositeBindings(fragmentBindings));
            }
            ++n2;
        }
        return this.flatten(result);
    }

    @Override
    public IIndexBinding[] findBindings(char[] name, boolean filescope, IndexFilter filter, IProgressMonitor monitor) throws CoreException {
        ILinkage[] linkages;
        if (this.fFragments.length == 1) {
            return this.fFragments[0].findBindings(name, filescope, filter, monitor);
        }
        ArrayList<IIndexBinding[]> result = new ArrayList<IIndexBinding[]>();
        ILinkage[] iLinkageArray = linkages = Linkage.getIndexerLinkages();
        int n = linkages.length;
        int n2 = 0;
        while (n2 < n) {
            ILinkage linkage = iLinkageArray[n2];
            if (filter.acceptLinkage(linkage)) {
                IIndexFragmentBinding[][] fragmentBindings = new IIndexFragmentBinding[this.fFragments.length][];
                int i = 0;
                while (i < this.fFragments.length) {
                    try {
                        IIndexFragmentBinding[] part = this.fFragments[i].findBindings(name, filescope, this.retargetFilter(linkage, filter), monitor);
                        fragmentBindings[i] = new IIndexFragmentBinding[part.length];
                        System.arraycopy(part, 0, fragmentBindings[i], 0, part.length);
                    }
                    catch (CoreException e) {
                        CCorePlugin.log(e);
                        fragmentBindings[i] = IIndexFragmentBinding.EMPTY_INDEX_BINDING_ARRAY;
                    }
                    ++i;
                }
                ICompositesFactory factory = this.getCompositesFactory(linkage.getLinkageID());
                result.add(factory.getCompositeBindings(fragmentBindings));
            }
            ++n2;
        }
        return this.flatten(result);
    }

    @Override
    public IIndexMacro[] findMacros(char[] name, IndexFilter filter, IProgressMonitor monitor) throws CoreException {
        return this.findMacros(name, false, true, filter, monitor);
    }

    @Override
    public IIndexMacro[] findMacrosForPrefix(char[] name, IndexFilter filter, IProgressMonitor monitor) throws CoreException {
        return this.findMacros(name, true, false, filter, monitor);
    }

    private IIndexMacro[] findMacros(char[] name, boolean isPrefix, boolean caseSensitive, IndexFilter filter, IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        ArrayList<IIndexMacro> result = new ArrayList<IIndexMacro>();
        HashSet<IIndexFileLocation> handledIFLs = new HashSet<IIndexFileLocation>();
        SubMonitor loopMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.CIndex_FindBindingsTask_label, (int)this.fFragments.length);
        IIndexFragment[] iIndexFragmentArray = this.fFragments;
        int n = this.fFragments.length;
        int n2 = 0;
        while (n2 < n) {
            IIndexFragment fragment = iIndexFragmentArray[n2];
            HashSet<IIndexFile> allowedFiles = new HashSet<IIndexFile>();
            try {
                IIndexMacro[] macros;
                IIndexMacro[] iIndexMacroArray = macros = fragment.findMacros(name, isPrefix, caseSensitive, filter, (IProgressMonitor)loopMonitor.newChild(1));
                int n3 = macros.length;
                int n4 = 0;
                while (n4 < n3) {
                    block9: {
                        IIndexMacro indexMacro;
                        block8: {
                            indexMacro = iIndexMacroArray[n4];
                            IIndexFile file = indexMacro.getFile();
                            if (allowedFiles.contains(file)) break block8;
                            if (!handledIFLs.add(file.getLocation())) break block9;
                            allowedFiles.add(file);
                        }
                        result.add(indexMacro);
                    }
                    ++n4;
                }
            }
            catch (CoreException e) {
                CCorePlugin.log(e);
            }
            ++n2;
        }
        monitor.done();
        return result.toArray(new IIndexMacro[result.size()]);
    }

    public long getCacheHits() {
        long result = 0L;
        IIndexFragment[] iIndexFragmentArray = this.fFragments;
        int n = this.fFragments.length;
        int n2 = 0;
        while (n2 < n) {
            IIndexFragment fragment = iIndexFragmentArray[n2];
            result += fragment.getCacheHits();
            ++n2;
        }
        return result;
    }

    public long getCacheMisses() {
        long result = 0L;
        IIndexFragment[] iIndexFragmentArray = this.fFragments;
        int n = this.fFragments.length;
        int n2 = 0;
        while (n2 < n) {
            IIndexFragment fragment = iIndexFragmentArray[n2];
            result += fragment.getCacheMisses();
            ++n2;
        }
        return result;
    }

    public void resetCacheCounters() {
        IIndexFragment[] iIndexFragmentArray = this.fFragments;
        int n = this.fFragments.length;
        int n2 = 0;
        while (n2 < n) {
            IIndexFragment fragment = iIndexFragmentArray[n2];
            fragment.resetCacheCounters();
            ++n2;
        }
    }

    protected void clearResultCache() {
        IIndexFragment[] iIndexFragmentArray = this.fFragments;
        int n = this.fFragments.length;
        int n2 = 0;
        while (n2 < n) {
            IIndexFragment frag = iIndexFragmentArray[n2];
            frag.clearResultCache();
            ++n2;
        }
    }

    @Override
    public IIndexFileSet createFileSet() {
        return new IndexFileSet();
    }

    @Override
    public IIndexFile[] getAllFiles() throws CoreException {
        HashMap<IIndexFileLocation, IIndexFragmentFile> result = new HashMap<IIndexFileLocation, IIndexFragmentFile>();
        IIndexFragment[] iIndexFragmentArray = this.fFragments;
        int n = this.fFragments.length;
        int n2 = 0;
        while (n2 < n) {
            IIndexFragment fragment = iIndexFragmentArray[n2];
            IIndexFragmentFile[] iIndexFragmentFileArray = fragment.getAllFiles();
            int n3 = iIndexFragmentFileArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IIndexFragmentFile file = iIndexFragmentFileArray[n4];
                if (file.hasContent()) {
                    result.put(file.getLocation(), file);
                }
                ++n4;
            }
            ++n2;
        }
        return result.values().toArray(new IIndexFile[result.size()]);
    }

    @Override
    public IIndexFile[] getDefectiveFiles() throws CoreException {
        HashMap<IIndexFileLocation, IIndexFragmentFile> result = new HashMap<IIndexFileLocation, IIndexFragmentFile>();
        IIndexFragment[] iIndexFragmentArray = this.fFragments;
        int n = this.fFragments.length;
        int n2 = 0;
        while (n2 < n) {
            IIndexFragment fragment = iIndexFragmentArray[n2];
            IIndexFragmentFile[] iIndexFragmentFileArray = fragment.getDefectiveFiles();
            int n3 = iIndexFragmentFileArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IIndexFragmentFile file = iIndexFragmentFileArray[n4];
                if (file.hasContent()) {
                    result.put(file.getLocation(), file);
                }
                ++n4;
            }
            ++n2;
        }
        return result.values().toArray(new IIndexFile[result.size()]);
    }

    @Override
    public IIndexFile[] getFilesWithUnresolvedIncludes() throws CoreException {
        HashMap<IIndexFileLocation, IIndexFragmentFile> result = new HashMap<IIndexFileLocation, IIndexFragmentFile>();
        IIndexFragment[] iIndexFragmentArray = this.fFragments;
        int n = this.fFragments.length;
        int n2 = 0;
        while (n2 < n) {
            IIndexFragment fragment = iIndexFragmentArray[n2];
            IIndexFragmentFile[] iIndexFragmentFileArray = fragment.getFilesWithUnresolvedIncludes();
            int n3 = iIndexFragmentFileArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IIndexFragmentFile file = iIndexFragmentFileArray[n4];
                if (file.hasContent()) {
                    result.put(file.getLocation(), file);
                }
                ++n4;
            }
            ++n2;
        }
        return result.values().toArray(new IIndexFile[result.size()]);
    }

    public IIndexScope[] getInlineNamespaces() throws CoreException {
        if (this.fFragments.length == 1) {
            return this.fFragments[0].getInlineNamespaces();
        }
        IIndexFragmentBinding[][] preresult = new IIndexFragmentBinding[this.fFragments.length][];
        int i = 0;
        while (i < this.fFragments.length) {
            IIndexScope[] raw = this.fFragments[i].getInlineNamespaces();
            preresult[i] = new IIndexFragmentBinding[raw.length];
            IIndexFragmentBinding[] arr = preresult[i];
            int j = 0;
            while (j < raw.length) {
                arr[j] = (IIndexFragmentBinding)raw[j].getScopeBinding();
                ++j;
            }
            ++i;
        }
        IIndexBinding[] compBinding = this.getCompositesFactory(1).getCompositeBindings(preresult);
        IIndexScope[] result = new IIndexScope[compBinding.length];
        int i2 = 0;
        while (i2 < result.length) {
            result[i2] = (IIndexScope)((Object)((ICPPNamespace)((Object)compBinding[i2])).getNamespaceScope());
            ++i2;
        }
        return result;
    }

    @Override
    public boolean isFullyInitialized() {
        IIndexFragment[] iIndexFragmentArray = this.fFragments;
        int n = this.fFragments.length;
        int n2 = 0;
        while (n2 < n) {
            IIndexFragment fragment = iIndexFragmentArray[n2];
            if (!fragment.isFullyInitialized()) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private static final class NameKey {
        private final IIndexFileLocation location;
        private final int linkageID;
        private final int offset;
        private final boolean inWritableFragment;

        NameKey(IIndexFragmentName name, boolean writable) throws CoreException {
            IIndexFile file = name.getFile();
            this.location = file.getLocation();
            this.linkageID = file.getLinkageID();
            this.offset = name.getNodeOffset();
            this.inWritableFragment = writable;
        }

        public int hashCode() {
            return this.location.hashCode() * 31 + this.linkageID;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            NameKey other = (NameKey)obj;
            if (this.inWritableFragment == other.inWritableFragment && this.offset != other.offset) {
                return false;
            }
            if (this.linkageID != other.linkageID) {
                return false;
            }
            return this.location.equals(other.location);
        }
    }
}

