/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTInitializer;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IArrayType;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.IValue;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTQualifiedName;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTStructuredBindingDeclaration;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTVisibilityLabel;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPVariable;
import org.eclipse.cdt.core.parser.util.CharArrayUtils;
import org.eclipse.cdt.internal.core.dom.parser.ASTInternal;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPInternalVariable;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPVisitor;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.SemanticUtil;

public class VariableHelpers {
    public static boolean hasStorageClass(IASTName name, IASTNode[] declarations, int storage) {
        int i = -1;
        do {
            IASTDeclSpecifier declSpec;
            if (name == null) continue;
            IASTNode parent = name.getParent();
            while (!(parent instanceof IASTDeclaration)) {
                parent = parent.getParent();
            }
            if (!(parent instanceof IASTSimpleDeclaration) || (declSpec = ((IASTSimpleDeclaration)parent).getDeclSpecifier()).getStorageClass() != storage) continue;
            return true;
        } while (declarations != null && ++i < declarations.length && (name = (IASTName)declarations[i]) != null);
        return false;
    }

    public static boolean isConstexpr(IASTName definition) {
        ICPPASTDeclSpecifier declSpec;
        if (definition == null) {
            return false;
        }
        IASTNode parent = definition.getParent();
        while (!(parent instanceof IASTDeclaration)) {
            parent = parent.getParent();
        }
        if (parent instanceof IASTSimpleDeclaration && (declSpec = (ICPPASTDeclSpecifier)((IASTSimpleDeclaration)parent).getDeclSpecifier()) != null) {
            return declSpec.isConstexpr();
        }
        return false;
    }

    public static IType createType(ICPPVariable variable, IASTName definition, IASTName[] declarations, boolean allDeclarationsResolved) {
        boolean doneWithDefinition = false;
        IArrayType firstCandidate = null;
        int length = declarations == null ? 0 : declarations.length;
        int i = 0;
        while (i <= length) {
            IASTName n;
            if (!(definition == null || doneWithDefinition || i != length && ((ASTNode)((Object)definition)).getOffset() >= ((ASTNode)((Object)declarations[i])).getOffset())) {
                n = definition;
                doneWithDefinition = true;
                --i;
            } else {
                if (i >= length) break;
                n = declarations[i];
            }
            if (n != null) {
                while (n.getParent() instanceof IASTName) {
                    n = (IASTName)n.getParent();
                }
                IASTNode node = n.getParent();
                if (node instanceof IASTDeclarator) {
                    IType t = CPPVisitor.createType((IASTDeclarator)node);
                    if (!(t instanceof IArrayType) || ((IArrayType)t).hasSize()) {
                        return t;
                    }
                    if (firstCandidate == null) {
                        firstCandidate = (IArrayType)t;
                    }
                } else if (node instanceof ICPPASTStructuredBindingDeclaration) {
                    ICPPASTStructuredBindingDeclaration parent = (ICPPASTStructuredBindingDeclaration)node;
                    return CPPVisitor.createType(parent, n);
                }
            }
            ++i;
        }
        if (!allDeclarationsResolved) {
            VariableHelpers.resolveAllDeclarations(variable, definition, declarations);
            return variable.getType();
        }
        return firstCandidate;
    }

    private static void resolveAllDeclarations(ICPPVariable variable, IASTName definition, IASTName[] declarations) {
        int length = declarations == null ? 0 : declarations.length;
        int i = -1;
        while (i < length) {
            IASTTranslationUnit tu;
            IASTName n;
            IASTName iASTName = n = i == -1 ? definition : declarations[i];
            if (n != null && (tu = n.getTranslationUnit()) != null) {
                CPPVisitor.getDeclarations(tu, variable);
                return;
            }
            ++i;
        }
    }

    public static IValue getInitialValue(IASTName definition, IASTName[] declarations, IType type) {
        IValue val;
        if (definition != null && (val = VariableHelpers.getInitialValue(definition, type)) != null) {
            return val;
        }
        if (declarations != null) {
            IASTName[] iASTNameArray = declarations;
            int n = declarations.length;
            int n2 = 0;
            while (n2 < n) {
                IASTName decl = iASTNameArray[n2];
                if (decl == null) break;
                IValue val2 = VariableHelpers.getInitialValue(decl, type);
                if (val2 != null) {
                    return val2;
                }
                ++n2;
            }
        }
        return null;
    }

    private static IValue getInitialValue(IASTName name, IType type) {
        IASTInitializer init;
        IASTDeclarator dtor = VariableHelpers.findDeclarator(name);
        if (dtor != null && (init = dtor.getInitializer()) != null) {
            return SemanticUtil.getValueOfInitializer(init, type);
        }
        return null;
    }

    public static IASTDeclarator findDeclarator(IASTName name) {
        IASTNode node = name.getParent();
        if (node instanceof ICPPASTQualifiedName) {
            node = node.getParent();
        }
        if (!(node instanceof IASTDeclarator)) {
            return null;
        }
        IASTDeclarator dtor = (IASTDeclarator)node;
        while (dtor.getParent() instanceof IASTDeclarator) {
            dtor = (IASTDeclarator)dtor.getParent();
        }
        return dtor;
    }

    public static int getVisibility(ICPPInternalVariable field) {
        ICPPASTVisibilityLabel vis = null;
        IASTDeclaration decl = VariableHelpers.getPrimaryDeclaration(field);
        if (decl != null) {
            IASTDeclaration[] members;
            IASTCompositeTypeSpecifier cls = (IASTCompositeTypeSpecifier)decl.getParent();
            IASTDeclaration[] iASTDeclarationArray = members = cls.getMembers();
            int n = members.length;
            int n2 = 0;
            while (n2 < n) {
                IASTDeclaration member = iASTDeclarationArray[n2];
                if (member == decl) break;
                if (member instanceof ICPPASTVisibilityLabel) {
                    vis = (ICPPASTVisibilityLabel)member;
                }
                ++n2;
            }
            if (vis != null) {
                return vis.getVisibility();
            }
            if (cls.getKey() == 3) {
                return 3;
            }
        }
        return 1;
    }

    private static IASTDeclaration getPrimaryDeclaration(ICPPInternalVariable field) {
        IASTDeclaration[] members;
        IASTDeclaration decl = VariableHelpers.findDeclaration(field.getDefinition());
        if (decl != null) {
            return decl;
        }
        IASTName[] declarations = (IASTName[])field.getDeclarations();
        if (declarations != null) {
            IASTName[] iASTNameArray = declarations;
            int n = declarations.length;
            int n2 = 0;
            while (n2 < n) {
                IASTName name = iASTNameArray[n2];
                decl = VariableHelpers.findDeclaration(name);
                if (decl != null) {
                    return decl;
                }
                ++n2;
            }
        }
        char[] myName = field.getNameCharArray();
        ICPPClassScope scope = VariableHelpers.findClassScope(field);
        ICPPASTCompositeTypeSpecifier compSpec = (ICPPASTCompositeTypeSpecifier)ASTInternal.getPhysicalNodeOfScope(scope);
        IASTDeclaration[] iASTDeclarationArray = members = compSpec.getMembers();
        int n = members.length;
        int n3 = 0;
        while (n3 < n) {
            IASTDeclaration member = iASTDeclarationArray[n3];
            if (member instanceof IASTSimpleDeclaration) {
                IASTDeclarator[] dtors;
                IASTDeclarator[] iASTDeclaratorArray = dtors = ((IASTSimpleDeclaration)member).getDeclarators();
                int n4 = dtors.length;
                int n5 = 0;
                while (n5 < n4) {
                    IASTDeclarator dtor = iASTDeclaratorArray[n5];
                    IASTName name = dtor.getName();
                    if (CharArrayUtils.equals(name.getLookupKey(), myName) && name.resolveBinding() == field) {
                        return member;
                    }
                    ++n5;
                }
            }
            ++n3;
        }
        return null;
    }

    private static ICPPClassScope findClassScope(ICPPInternalVariable v) {
        IScope scope;
        try {
            scope = v.getScope();
        }
        catch (DOMException e) {
            scope = null;
        }
        while (scope != null) {
            if (scope instanceof ICPPClassScope) {
                return (ICPPClassScope)scope;
            }
            try {
                scope = scope.getParent();
            }
            catch (DOMException e) {
                return null;
            }
        }
        return null;
    }

    private static IASTDeclaration findDeclaration(IASTNode node) {
        while (node != null && !(node instanceof IASTDeclaration)) {
            node = node.getParent();
        }
        if (node != null && node.getParent() instanceof ICPPASTCompositeTypeSpecifier) {
            return (IASTDeclaration)node;
        }
        return null;
    }
}

