/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.cdtvariables;

import java.util.ArrayList;
import org.eclipse.cdt.core.cdtvariables.CdtVariable;
import org.eclipse.cdt.core.settings.model.ICStorageElement;
import org.eclipse.cdt.utils.cdtvariables.CdtVariableResolver;

public class StorableCdtVariable
extends CdtVariable {
    public static final String STRING_MACRO_ELEMENT_NAME = "stringMacro";
    public static final String STRINGLIST_MACRO_ELEMENT_NAME = "stringListMacro";
    public static final String NAME = "name";
    public static final String VALUE = "value";
    public static final String TYPE = "type";
    public static final String VALUE_ELEMENT_NAME = "value";
    public static final String VALUE_ELEMENT_VALUE = "name";
    public static final String TYPE_TEXT = "VALUE_TEXT";
    public static final String TYPE_TEXT_LIST = "VALUE_TEXT_LIST";
    public static final String TYPE_PATH_FILE = "VALUE_PATH_FILE";
    public static final String TYPE_PATH_FILE_LIST = "VALUE_PATH_FILE_LIST";
    public static final String TYPE_PATH_DIR = "VALUE_PATH_DIR";
    public static final String TYPE_PATH_DIR_LIST = "VALUE_PATH_DIR_LIST";
    public static final String TYPE_PATH_ANY = "VALUE_PATH_ANY";
    public static final String TYPE_PATH_ANY_LIST = "VALUE_PATH_ANY_LIST";

    public StorableCdtVariable(String name, int type, String value) {
        super(name, type, value);
    }

    public StorableCdtVariable(String name, int type, String[] value) {
        super(name, type, value);
    }

    public StorableCdtVariable(ICStorageElement element) {
        this.load(element);
    }

    private void load(ICStorageElement element) {
        this.fName = element.getAttribute("name");
        this.fType = this.typeStringToInt(element.getAttribute(TYPE));
        if (!CdtVariableResolver.isStringListVariable(this.fType)) {
            this.fStringValue = element.getAttribute("value");
        } else {
            ICStorageElement[] nodeList = element.getChildren();
            ArrayList<String> values = new ArrayList<String>();
            int i = 0;
            while (i < nodeList.length) {
                ICStorageElement node = nodeList[i];
                if (node.getName().equals("value")) {
                    values.add(node.getAttribute("name"));
                }
                ++i;
            }
            this.fStringListValue = values.toArray(new String[values.size()]);
        }
    }

    private int typeStringToInt(String typeString) {
        int type = TYPE_TEXT_LIST.equals(typeString) ? 2 : (TYPE_PATH_FILE.equals(typeString) ? 3 : (TYPE_PATH_FILE_LIST.equals(typeString) ? 4 : (TYPE_PATH_DIR.equals(typeString) ? 5 : (TYPE_PATH_DIR_LIST.equals(typeString) ? 6 : (TYPE_PATH_ANY.equals(typeString) ? 7 : (TYPE_PATH_ANY_LIST.equals(typeString) ? 8 : 1))))));
        return type;
    }

    private String typeIntToString(int type) {
        return switch (type) {
            case 2 -> TYPE_TEXT_LIST;
            case 3 -> TYPE_PATH_FILE;
            case 4 -> TYPE_PATH_FILE_LIST;
            case 5 -> TYPE_PATH_DIR;
            case 6 -> TYPE_PATH_DIR_LIST;
            case 7 -> TYPE_PATH_ANY;
            case 8 -> TYPE_PATH_ANY_LIST;
            default -> TYPE_TEXT;
        };
    }

    public void serialize(ICStorageElement element) {
        if (this.fName != null) {
            element.setAttribute("name", this.fName);
        }
        element.setAttribute(TYPE, this.typeIntToString(this.fType));
        if (!CdtVariableResolver.isStringListVariable(this.fType)) {
            if (this.fStringValue != null) {
                element.setAttribute("value", this.fStringValue);
            }
        } else if (this.fStringListValue != null && this.fStringListValue.length > 0) {
            int i = 0;
            while (i < this.fStringListValue.length) {
                ICStorageElement valEl = element.createChild("value");
                if (this.fStringListValue[i] != null) {
                    valEl.setAttribute("name", this.fStringListValue[i]);
                }
                ++i;
            }
        }
    }
}

