/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.model.filters;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.tmf.core.model.filters.IMultipleSelectionQueryFilter;
import org.eclipse.tracecompass.tmf.core.model.filters.TimeQueryFilter;

public class SelectionTimeQueryFilter
extends TimeQueryFilter
implements IMultipleSelectionQueryFilter<Collection<Long>> {
    private final Collection<Long> fItems;

    public SelectionTimeQueryFilter(long start, long end, int n, Collection<Long> items) {
        super(start, end, n);
        this.fItems = ImmutableList.copyOf(items);
    }

    public SelectionTimeQueryFilter(List<Long> times, Collection<Long> items) {
        super(times);
        this.fItems = ImmutableList.copyOf(items);
    }

    @Override
    public Collection<Long> getSelectedItems() {
        return this.fItems;
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        SelectionTimeQueryFilter other = (SelectionTimeQueryFilter)obj;
        return this.fItems.equals(other.getSelectedItems());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.fItems);
    }
}

