/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.viewers.xychart;

import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swtchart.ICustomPaintListener;
import org.eclipse.tracecompass.tmf.ui.viewers.xychart.IAxis;
import org.eclipse.tracecompass.tmf.ui.viewers.xychart.ITmfChartTimeProvider;
import org.eclipse.tracecompass.tmf.ui.viewers.xychart.TmfBaseProvider;
import org.eclipse.tracecompass.tmf.ui.viewers.xychart.TmfXYChartViewer;

public class TmfMouseDragZoomProvider
extends TmfBaseProvider
implements MouseListener,
MouseMoveListener,
ICustomPaintListener {
    private long fStartTime;
    private long fEndTime;
    private boolean fIsUpdate;
    private final Cursor fZoomCursor = Display.getDefault().getSystemCursor(9);

    public TmfMouseDragZoomProvider(ITmfChartTimeProvider tmfChartViewer) {
        super(tmfChartViewer);
    }

    @Override
    public void refresh() {
    }

    public void mouseDoubleClick(MouseEvent e) {
    }

    public void mouseDown(MouseEvent e) {
        if (this.getChartViewer().getWindowDuration() != 0L && e.button == 3) {
            IAxis xAxis = this.getXAxis();
            this.fEndTime = this.fStartTime = this.limitXDataCoordinate(xAxis.getDataCoordinate(e.x));
            this.fIsUpdate = true;
            this.getChartViewer().getControl().setCursor(this.fZoomCursor);
        }
    }

    public void mouseUp(MouseEvent e) {
        if (this.fIsUpdate && this.fStartTime != this.fEndTime) {
            if (this.fStartTime > this.fEndTime) {
                long tmp = this.fStartTime;
                this.fStartTime = this.fEndTime;
                this.fEndTime = tmp;
            }
            ITmfChartTimeProvider viewer = this.getChartViewer();
            viewer.updateWindow(this.fStartTime + viewer.getTimeOffset(), this.fEndTime + viewer.getTimeOffset());
        }
        if (this.fIsUpdate) {
            this.getChartViewer().getControl().redraw();
        }
        this.fIsUpdate = false;
        this.getChartViewer().getControl().setCursor(null);
    }

    public void mouseMove(MouseEvent e) {
        if (this.fIsUpdate) {
            IAxis xAxis = this.getXAxis();
            this.fEndTime = this.limitXDataCoordinate(xAxis.getDataCoordinate(e.x));
            ITmfChartTimeProvider viewer = this.getChartViewer();
            if (viewer instanceof TmfXYChartViewer) {
                TmfXYChartViewer xyChartViewer = (TmfXYChartViewer)viewer;
                xyChartViewer.updateStatusLine(this.fStartTime, this.fEndTime, this.limitXDataCoordinate(xAxis.getDataCoordinate(e.x)));
            }
            this.getChartViewer().getControl().redraw();
        }
    }

    public void paintControl(PaintEvent e) {
        if (this.fIsUpdate && this.fStartTime != this.fEndTime) {
            IAxis xAxis = this.getXAxis();
            int startX = xAxis.getPixelCoordinate(this.fStartTime);
            int endX = xAxis.getPixelCoordinate(this.fEndTime);
            int prevAlpha = e.gc.getAlpha();
            e.gc.setAlpha(64);
            e.gc.setBackground(TmfXYChartViewer.getDisplay().getSystemColor(22));
            if (this.fStartTime < this.fEndTime) {
                e.gc.fillRectangle(startX, 0, endX - startX, e.height);
            } else {
                e.gc.fillRectangle(endX, 0, startX - endX, e.height);
            }
            e.gc.setAlpha(prevAlpha);
            e.gc.drawLine(startX, 0, startX, e.height);
            e.gc.drawLine(endX, 0, endX, e.height);
        }
    }

    public boolean drawBehindSeries() {
        return false;
    }
}

