/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.analysis.timing.ui.views.segmentstore.scatter;

import java.text.Format;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.tracecompass.common.core.format.SubSecondTimeWithUnitFormat;
import org.eclipse.tracecompass.internal.analysis.timing.ui.views.segmentstore.xyscatter.SegmentStoreScatterGraphTooltipProvider;
import org.eclipse.tracecompass.tmf.core.dataprovider.DataProviderManager;
import org.eclipse.tracecompass.tmf.core.model.OutputElementStyle;
import org.eclipse.tracecompass.tmf.core.model.xy.ITmfTreeXYDataProvider;
import org.eclipse.tracecompass.tmf.core.model.xy.ITmfXYDataProvider;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalHandler;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceClosedSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceOpenedSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceSelectedSignal;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimeRange;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.eclipse.tracecompass.tmf.ui.viewers.xychart.ITmfChartTimeProvider;
import org.eclipse.tracecompass.tmf.ui.viewers.xychart.TmfBaseProvider;
import org.eclipse.tracecompass.tmf.ui.viewers.xychart.linechart.TmfFilteredXYChartViewer;
import org.eclipse.tracecompass.tmf.ui.viewers.xychart.linechart.TmfXYChartSettings;

public class AbstractSegmentStoreScatterChartViewer2
extends TmfFilteredXYChartViewer {
    private static final Format FORMAT = SubSecondTimeWithUnitFormat.getInstance();
    private static final int DEFAULT_SERIES_WIDTH = 1;
    private String fAnalysisId;

    public AbstractSegmentStoreScatterChartViewer2(Composite parent, TmfXYChartSettings settings) {
        this(parent, settings, "");
    }

    public AbstractSegmentStoreScatterChartViewer2(Composite parent, TmfXYChartSettings settings, String analysisId) {
        super(parent, settings, "org.eclipse.tracecompass.internal.analysis.timing.core.segmentstore.scatter.dataprovider");
        this.fAnalysisId = analysisId;
        this.setTooltipProvider((TmfBaseProvider)new SegmentStoreScatterGraphTooltipProvider((ITmfChartTimeProvider)this));
        this.getSwtChart().getLegend().setVisible(false);
        this.getSwtChart().getAxisSet().getYAxis(0).getTick().setFormat(FORMAT);
    }

    protected String getAnalysisId() {
        return this.fAnalysisId;
    }

    protected @Nullable ITmfXYDataProvider initializeDataProvider(ITmfTrace trace) {
        String analysisId = this.getAnalysisId();
        if (analysisId.isEmpty()) {
            return null;
        }
        return (ITmfXYDataProvider)DataProviderManager.getInstance().getOrCreateDataProvider(trace, "org.eclipse.tracecompass.internal.analysis.timing.core.segmentstore.scatter.dataprovider:" + analysisId, ITmfTreeXYDataProvider.class);
    }

    @TmfSignalHandler
    public void traceSelected(@Nullable TmfTraceSelectedSignal signal) {
        super.traceSelected(signal);
        if (this.getTrace() != null) {
            TmfTimeRange timeRange = TmfTraceManager.getInstance().getCurrentTraceContext().getWindowRange();
            this.setWindowRange(timeRange.getStartTime().toNanos(), timeRange.getEndTime().toNanos());
        }
    }

    @TmfSignalHandler
    public void traceOpened(@Nullable TmfTraceOpenedSignal signal) {
        super.traceOpened(signal);
        if (this.getTrace() != null) {
            TmfTimeRange timeRange = TmfTraceManager.getInstance().getCurrentTraceContext().getWindowRange();
            this.setWindowRange(timeRange.getStartTime().toNanos(), timeRange.getEndTime().toNanos());
        }
    }

    public OutputElementStyle getSeriesStyle(@NonNull Long seriesId) {
        return this.getPresentationProvider().getSeriesStyle(seriesId, "scatter", 1);
    }

    @TmfSignalHandler
    public void traceClosed(@Nullable TmfTraceClosedSignal signal) {
        super.traceClosed(signal);
        if (signal != null && TmfTraceManager.getInstance().getActiveTrace() == null) {
            this.clearContent();
        }
        this.refresh();
    }
}

