/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;

public class SearchDecoration {
    private SearchDecoration() {
    }

    public static boolean validateRegex(String regex, ControlDecoration targetDecoration) {
        String errorMessage = SearchDecoration.getValidationError(regex, targetDecoration.getControl());
        if (errorMessage.isEmpty()) {
            targetDecoration.hide();
            return true;
        }
        Image decorationImage = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERROR").getImage();
        targetDecoration.setImage(decorationImage);
        targetDecoration.setDescriptionText(errorMessage);
        targetDecoration.show();
        return false;
    }

    private static String getValidationError(String regex, Control targetControl) {
        try {
            Pattern.compile(regex);
            return "";
        }
        catch (PatternSyntaxException e) {
            return SearchDecoration.buildValidationErrorString(e, targetControl);
        }
    }

    private static String buildValidationErrorString(PatternSyntaxException e, Control targetControl) {
        String description = e.getDescription();
        int errorIndex = e.getIndex();
        if (errorIndex == -1) {
            return description;
        }
        GC gc = new GC((Drawable)targetControl);
        Object pattern = e.getPattern();
        if (errorIndex >= ((String)pattern).length()) {
            pattern = (String)pattern + " ";
        }
        StringBuilder validationErrorMessage = new StringBuilder();
        validationErrorMessage.append(description);
        validationErrorMessage.append(" at index ").append(errorIndex).append(System.lineSeparator());
        validationErrorMessage.append((String)pattern).append(System.lineSeparator());
        String stringToIndexString = ((String)pattern).substring(0, errorIndex + 1);
        String hairSpace = "\u200a";
        int hairSpaceWidth = gc.stringExtent((String)hairSpace).x;
        int stringToIndex = gc.stringExtent((String)stringToIndexString).x;
        String lastCharacter = stringToIndexString.substring(stringToIndexString.length() - 1);
        int widthLastChar = gc.stringExtent((String)lastCharacter).x;
        int upWidth = gc.stringExtent((String)"^").x;
        double howFar = stringToIndex - widthLastChar / 2 - upWidth / 2;
        int currentWidth = 0;
        while ((double)currentWidth < howFar) {
            currentWidth += hairSpaceWidth;
            validationErrorMessage.append(hairSpace);
        }
        validationErrorMessage.append("^");
        gc.dispose();
        return validationErrorMessage.toString();
    }
}

