/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.ctf.core.tests.perf.trace;

import java.io.File;
import org.eclipse.test.performance.Dimension;
import org.eclipse.test.performance.Performance;
import org.eclipse.test.performance.PerformanceMeter;
import org.eclipse.tracecompass.ctf.core.CTFException;
import org.eclipse.tracecompass.ctf.core.event.IEventDefinition;
import org.eclipse.tracecompass.ctf.core.trace.CTFTrace;
import org.eclipse.tracecompass.ctf.core.trace.CTFTraceReader;
import org.junit.Assert;
import org.junit.Test;

public class LttngTraceReadBenchmark {
    private static final String TEST_SUITE_NAME = "Lttng Read Benchmark";
    private static final String TEST_ID = "org.eclipse.linuxtools#Lttng Read Benchmark";
    private static final int LOOP_COUNT = 10;

    @Test
    public void testKernelTrace() {
        File[] filesList;
        String directoryPath = "null";
        File parentDirectory = new File(directoryPath);
        if (!parentDirectory.isDirectory() || parentDirectory.list() == null) {
            System.err.println(String.format("Trace directory not found !\nYou need to setup the directory path before running thid benchmark. See the javadoc of this class.", new Object[0]));
            return;
        }
        File[] fileArray = filesList = parentDirectory.listFiles();
        int n = filesList.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            String path = file.getAbsolutePath() + "/kernel";
            CTFTrace trace = null;
            try {
                trace = new CTFTrace(path);
            }
            catch (CTFException e) {
                Assert.fail((String)e.getMessage());
            }
            LttngTraceReadBenchmark.readTrace(trace, "Kernel trace: " + path, false);
            ++n2;
        }
    }

    private static void readTrace(CTFTrace trace, String testName, boolean inGlobalSummary) {
        Performance perf = Performance.getDefault();
        PerformanceMeter pm = perf.createPerformanceMeter("org.eclipse.linuxtools#Lttng Read Benchmark#" + testName);
        perf.tagAsSummary(pm, "Lttng Read Benchmark:" + testName, Dimension.CPU_TIME);
        if (inGlobalSummary) {
            perf.tagAsGlobalSummary(pm, "Lttng Read Benchmark:" + testName, Dimension.CPU_TIME);
        }
        int loop = 0;
        while (loop < 10) {
            pm.start();
            try {
                Throwable throwable = null;
                Object var7_9 = null;
                try (CTFTraceReader traceReader = new CTFTraceReader(trace);){
                    while (traceReader.hasMoreEvents()) {
                        IEventDefinition ed = traceReader.getCurrentEventDef();
                        ed.getCPU();
                        traceReader.advance();
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (CTFException e) {
                Assert.fail((String)("Test failed at iteration " + loop + ":" + e.getMessage()));
            }
            pm.stop();
            ++loop;
        }
        pm.commit();
    }
}

