/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.ctf.core.tests.types;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import org.eclipse.tracecompass.ctf.core.event.metadata.DeclarationScope;
import org.eclipse.tracecompass.ctf.core.event.types.FloatDeclaration;
import org.eclipse.tracecompass.ctf.core.event.types.IDeclaration;
import org.eclipse.tracecompass.ctf.core.event.types.IntegerDeclaration;
import org.eclipse.tracecompass.ctf.core.trace.CTFTrace;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.ICommonTreeParser;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.JsonStructureFieldMemberMetadataNode;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl.TypeAliasParser;
import org.eclipse.tracecompass.internal.ctf.core.event.types.ICTFMetadataNode;
import org.junit.Assert;
import org.junit.Test;

public class TypeAliasParserTest {
    @Test
    public void testFixedLengthFloatingPointParsing() throws Exception {
        CTFTrace trace = new CTFTrace();
        DeclarationScope scope = new DeclarationScope(null, "test");
        JsonObject fieldClass = new JsonObject();
        fieldClass.add("type", (JsonElement)new JsonPrimitive("fixed-length-floating-point-number"));
        fieldClass.add("length", (JsonElement)new JsonPrimitive((Number)32));
        fieldClass.add("byte-order", (JsonElement)new JsonPrimitive("le"));
        JsonStructureFieldMemberMetadataNode node = new JsonStructureFieldMemberMetadataNode(null, "fixed-length-floating-point-number", "test", "float_field", fieldClass);
        IDeclaration result = TypeAliasParser.INSTANCE.parse((ICTFMetadataNode)node, (ICommonTreeParser.ICommonTreeParserParameter)new TypeAliasParser.Param(trace, scope));
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)(result instanceof FloatDeclaration));
        FloatDeclaration floatDecl = (FloatDeclaration)result;
        Assert.assertTrue((floatDecl.getExponent() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((floatDecl.getMantissa() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testStaticLengthStringParsing() throws Exception {
        CTFTrace trace = new CTFTrace();
        DeclarationScope scope = new DeclarationScope(null, "test");
        JsonObject fieldClass = new JsonObject();
        fieldClass.add("type", (JsonElement)new JsonPrimitive("static-length-string"));
        fieldClass.add("length", (JsonElement)new JsonPrimitive((Number)16));
        fieldClass.add("encoding", (JsonElement)new JsonPrimitive("utf-8"));
        JsonStructureFieldMemberMetadataNode node = new JsonStructureFieldMemberMetadataNode(null, "static-length-string", "test", "string_field", fieldClass);
        IDeclaration result = TypeAliasParser.INSTANCE.parse((ICTFMetadataNode)node, (ICommonTreeParser.ICommonTreeParserParameter)new TypeAliasParser.Param(trace, scope));
        Assert.assertNotNull((Object)result);
    }

    @Test
    public void testDynamicLengthStringParsing() throws Exception {
        CTFTrace trace = new CTFTrace();
        DeclarationScope scope = new DeclarationScope(null, "test");
        IntegerDeclaration lengthDecl = IntegerDeclaration.UINT_5L_DECL;
        scope.registerIdentifier("length", (IDeclaration)lengthDecl);
        JsonObject fieldClass = new JsonObject();
        fieldClass.add("type", (JsonElement)new JsonPrimitive("dynamic-length-string"));
        fieldClass.add("encoding", (JsonElement)new JsonPrimitive("utf-8"));
        JsonObject lengthFieldLocation = new JsonObject();
        lengthFieldLocation.add("path", (JsonElement)new JsonPrimitive("length"));
        fieldClass.add("length-field-location", (JsonElement)lengthFieldLocation);
        JsonStructureFieldMemberMetadataNode node = new JsonStructureFieldMemberMetadataNode(null, "dynamic-length-string", "test", "dyn_string_field", fieldClass);
        IDeclaration result = TypeAliasParser.INSTANCE.parse((ICTFMetadataNode)node, (ICommonTreeParser.ICommonTreeParserParameter)new TypeAliasParser.Param(trace, scope));
        Assert.assertNotNull((Object)result);
    }
}

