/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.pcap.core.tests.file;

import java.io.IOException;
import java.nio.file.Path;
import org.eclipse.tracecompass.internal.pcap.core.trace.BadPcapFileException;
import org.eclipse.tracecompass.internal.pcap.core.util.PcapHelper;
import org.eclipse.tracecompass.pcap.core.tests.shared.PcapTestTrace;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;

public class PcapFileOpenFailTest {
    @Test
    public void fileOpenBadPcapTest() throws IOException, BadPcapFileException {
        PcapTestTrace trace = PcapTestTrace.BAD_PCAPFILE;
        Assume.assumeTrue((boolean)trace.exists());
        Assert.assertNull((Object)PcapHelper.getPcapFile((Path)trace.getPath()));
    }

    @Test
    public void fileOpenBinaryFile() throws IOException, BadPcapFileException {
        PcapTestTrace trace = PcapTestTrace.KERNEL_TRACE;
        Assume.assumeTrue((boolean)trace.exists());
        Assert.assertNull((Object)PcapHelper.getPcapFile((Path)trace.getPath()));
    }

    @Test
    public void FileOpenDirectory() throws IOException {
        PcapTestTrace trace = PcapTestTrace.KERNEL_DIRECTORY;
        Assume.assumeTrue((boolean)trace.exists());
        try {
            PcapHelper.getPcapFile((Path)trace.getPath());
            Assert.fail((String)"The file was accepted even though it is not a pcapNg file!");
        }
        catch (IOException | BadPcapFileException e) {
            Assert.assertEquals((Object)"Bad Pcap File.", (Object)e.getMessage());
        }
    }
}

